/*
 * Decompiled with CFR 0.152.
 */
package org.basinmc.lavatory.version;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.basinmc.lavatory.ResolverContext;
import org.basinmc.lavatory.asset.AssetIndexReference;
import org.basinmc.lavatory.file.Download;
import org.basinmc.lavatory.file.LibraryReference;
import org.basinmc.lavatory.file.LoggerConfiguration;
import org.basinmc.lavatory.rule.RuleControlledResourceContainer;
import org.basinmc.lavatory.version.ProgramArgument;
import org.basinmc.lavatory.version.VersionType;

public class Version
implements RuleControlledResourceContainer {
    private final String id;
    private final int minimumLauncherVersion;
    private final VersionType type;
    private final OffsetDateTime releaseTime;
    private final OffsetDateTime modificationTime;
    private final String mainClass;
    private final List<ProgramArgument> gameArguments;
    private final List<ProgramArgument> jvmArguments;
    private final Download clientDownload;
    private final Download serverDownload;
    private final Download windowsServerDownload;
    private final String assets;
    private final AssetIndexReference assetIndex;
    private final Map<String, LibraryReference> libraries;
    private final LoggerConfiguration clientLoggerConfiguration;

    public Version(@NonNull String id, int minimumLauncherVersion, @JsonFormat(with={JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}) @NonNull VersionType type, @NonNull OffsetDateTime releaseTime, @NonNull OffsetDateTime modificationTime, @NonNull String mainClass, @NonNull List<ProgramArgument> gameArguments, @NonNull List<ProgramArgument> jvmArguments, @NonNull Download clientDownload, @Nullable Download serverDownload, @Nullable Download windowsServerDownload, String assets, @NonNull AssetIndexReference assetIndex, @NonNull Set<LibraryReference> libraries, @Nullable LoggerConfiguration clientLoggerConfiguration) {
        this.id = id;
        this.minimumLauncherVersion = minimumLauncherVersion;
        this.type = type;
        this.releaseTime = releaseTime;
        this.modificationTime = modificationTime;
        this.mainClass = mainClass;
        this.gameArguments = new ArrayList<ProgramArgument>(gameArguments);
        this.jvmArguments = new ArrayList<ProgramArgument>(jvmArguments);
        this.clientDownload = clientDownload;
        this.serverDownload = serverDownload;
        this.windowsServerDownload = windowsServerDownload;
        this.assets = assets;
        this.assetIndex = assetIndex;
        this.libraries = libraries.stream().collect(Collectors.toMap(LibraryReference::getName, l -> l, (a, b) -> a.calculatePriority() >= b.calculatePriority() ? a : b));
        this.clientLoggerConfiguration = clientLoggerConfiguration;
    }

    @JsonCreator
    protected Version(@JsonProperty(value="id", required=true) @NonNull String id, @JsonProperty(value="minimumLauncherVersion", required=true) int minimumLauncherVersion, @JsonProperty(value="type", required=true) @JsonFormat(with={JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}) @NonNull VersionType type, @JsonProperty(value="releaseTime", required=true) @NonNull OffsetDateTime releaseTime, @JsonProperty(value="time", required=true) @NonNull OffsetDateTime modificationTime, @JsonProperty(value="mainClass", required=true) @NonNull String mainClass, @JsonProperty(value="arguments") @Nullable Map<String, List<ProgramArgument>> arguments, @JsonProperty(value="downloads", required=true) @NonNull Map<String, Download> downloads, @JsonProperty(value="assets", required=true) @NonNull String assets, @JsonProperty(value="assetIndex", required=true) @NonNull AssetIndexReference assetIndex, @JsonProperty(value="libraries", required=true) @NonNull Set<LibraryReference> libraries, @JsonProperty(value="logging") @Nullable Map<String, LoggerConfiguration> loggerConfigurations, @JsonProperty(value="minecraftArguments") @Nullable String legacyArguments) {
        this.id = id;
        this.minimumLauncherVersion = minimumLauncherVersion;
        this.type = type;
        this.releaseTime = releaseTime;
        this.modificationTime = modificationTime;
        this.mainClass = mainClass;
        this.assets = assets;
        this.assetIndex = assetIndex;
        this.libraries = libraries.stream().collect(Collectors.toMap(LibraryReference::getName, l -> l, (a, b) -> a.calculatePriority() >= b.calculatePriority() ? a : b));
        LoggerConfiguration loggerConfiguration = this.clientLoggerConfiguration = loggerConfigurations == null ? null : loggerConfigurations.get("client");
        if (legacyArguments != null) {
            if (arguments == null) {
                arguments = new HashMap<String, List<ProgramArgument>>();
            }
            List args = arguments.computeIfAbsent("game", k -> new ArrayList());
            Stream.of(legacyArguments.split(" ")).map(ProgramArgument::new).forEach(args::add);
        }
        this.gameArguments = Optional.ofNullable(arguments).flatMap(m -> Optional.ofNullable((List)m.get("game"))).orElseGet(Collections::emptyList);
        this.jvmArguments = Optional.ofNullable(arguments).flatMap(m -> Optional.ofNullable((List)m.get("jvm"))).orElseGet(Collections::emptyList);
        this.clientDownload = downloads.get("client");
        this.serverDownload = downloads.get("server");
        this.windowsServerDownload = downloads.get("windows_server");
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public int getMinimumLauncherVersion() {
        return this.minimumLauncherVersion;
    }

    @NonNull
    public VersionType getType() {
        return this.type;
    }

    @NonNull
    public OffsetDateTime getReleaseTime() {
        return this.releaseTime;
    }

    @NonNull
    public OffsetDateTime getModificationTime() {
        return this.modificationTime;
    }

    @NonNull
    public String getMainClass() {
        return this.mainClass;
    }

    @NonNull
    public List<ProgramArgument> getGameArguments() {
        return Collections.unmodifiableList(this.gameArguments);
    }

    @NonNull
    public List<ProgramArgument> getJvmArguments() {
        return Collections.unmodifiableList(this.jvmArguments);
    }

    @NonNull
    public Download getClientDownload() {
        return this.clientDownload;
    }

    @NonNull
    public Optional<Download> getServerDownload() {
        return Optional.ofNullable(this.serverDownload);
    }

    @NonNull
    public Optional<Download> getWindowsServerDownload() {
        return Optional.ofNullable(this.windowsServerDownload);
    }

    @NonNull
    public String getAssets() {
        return this.assets;
    }

    @NonNull
    public AssetIndexReference getAssetIndex() {
        return this.assetIndex;
    }

    @NonNull
    public Optional<LibraryReference> getLibrary(@NonNull String name) {
        return Optional.ofNullable(this.libraries.get(name));
    }

    @NonNull
    public Set<LibraryReference> getLibraries() {
        return Collections.unmodifiableSet(new HashSet<LibraryReference>(this.libraries.values()));
    }

    @NonNull
    public Optional<LoggerConfiguration> getClientLoggerConfiguration() {
        return Optional.ofNullable(this.clientLoggerConfiguration);
    }

    @NonNull
    public static Version read(@NonNull InputStream inputStream) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.findAndRegisterModules();
        return (Version)mapper.readValue(inputStream, Version.class);
    }

    @NonNull
    public static Version read(@NonNull Path path) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            Version version = Version.read(inputStream);
            return version;
        }
    }

    @NonNull
    public static Version read(@NonNull Reader reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.findAndRegisterModules();
        return (Version)mapper.readValue(reader, Version.class);
    }

    @Override
    @NonNull
    public Version reduce(@NonNull ResolverContext ctx) {
        return new Version(this.id, this.minimumLauncherVersion, this.type, this.releaseTime, this.modificationTime, this.mainClass, this.gameArguments.stream().filter(a -> a.evaluate(ctx)).collect(Collectors.toList()), this.jvmArguments.stream().filter(a -> a.evaluate(ctx)).collect(Collectors.toList()), this.clientDownload, this.serverDownload, this.windowsServerDownload, this.assets, this.assetIndex, this.libraries.values().stream().filter(l -> l.evaluate(ctx)).collect(Collectors.toSet()), this.clientLoggerConfiguration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.minimumLauncherVersion == version.minimumLauncherVersion && Objects.equals(this.id, version.id) && this.type == version.type && Objects.equals(this.releaseTime, version.releaseTime) && Objects.equals(this.modificationTime, version.modificationTime) && Objects.equals(this.mainClass, version.mainClass) && Objects.equals(this.gameArguments, version.gameArguments) && Objects.equals(this.jvmArguments, version.jvmArguments) && Objects.equals(this.clientDownload, version.clientDownload) && Objects.equals(this.serverDownload, version.serverDownload) && Objects.equals(this.windowsServerDownload, version.windowsServerDownload) && Objects.equals(this.assets, version.assets) && Objects.equals(this.assetIndex, version.assetIndex) && Objects.equals(this.libraries, version.libraries);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.minimumLauncherVersion, this.type, this.releaseTime, this.modificationTime, this.mainClass, this.gameArguments, this.jvmArguments, this.clientDownload, this.serverDownload, this.windowsServerDownload, this.assets, this.assetIndex, this.libraries});
    }
}

