/*
 * Decompiled with CFR 0.152.
 */
package org.basinmc.lavatory.version;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.basinmc.lavatory.version.Version;
import org.basinmc.lavatory.version.VersionType;

public final class VersionReference {
    private final String id;
    private final VersionType type;
    private final OffsetDateTime releaseTime;
    private final OffsetDateTime modificationTime;
    private final URL url;

    @JsonCreator
    public VersionReference(@JsonProperty(value="id", required=true) @NonNull String id, @JsonProperty(value="type", required=true) @JsonFormat(with={JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}) @NonNull VersionType type, @JsonProperty(value="releaseTime", required=true) @NonNull OffsetDateTime releaseTime, @JsonProperty(value="time", required=true) @NonNull OffsetDateTime modificationTime, @JsonProperty(value="url", required=true) @NonNull URL url) {
        this.id = id;
        this.url = url;
        this.type = type;
        this.releaseTime = releaseTime;
        this.modificationTime = modificationTime;
    }

    @NonNull
    public Version fetch() throws IOException {
        try (InputStream inputStream = this.url.openStream();){
            Version version = Version.read(inputStream);
            return version;
        }
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public VersionType getType() {
        return this.type;
    }

    @NonNull
    public OffsetDateTime getReleaseTime() {
        return this.releaseTime;
    }

    @NonNull
    public OffsetDateTime getModificationTime() {
        return this.modificationTime;
    }

    @NonNull
    public URL getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionReference that = (VersionReference)o;
        return Objects.equals(this.id, that.id) && this.type == that.type && Objects.equals(this.releaseTime, that.releaseTime) && Objects.equals(this.modificationTime, that.modificationTime) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.releaseTime, this.modificationTime, this.url});
    }
}

