/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.easybeans;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.baswell.easybeans.EasyBeanAttribute;
import org.baswell.easybeans.EasyBeanMemberStructure;
import org.baswell.easybeans.OpenTypeMapper;
import org.baswell.easybeans.SharedMethods;

class EasyBeanAttributeStructure
extends EasyBeanMemberStructure {
    final boolean wasReadAnnotated;
    final boolean wasWriteAnnotated;
    private final Field field;
    private final Method getter;
    private final Method setter;
    private final boolean writeable;

    EasyBeanAttributeStructure(Class clazz, Field field) {
        super(clazz);
        assert (field != null);
        this.field = field;
        this.getter = null;
        this.setter = null;
        EasyBeanAttribute attMeta = field.getAnnotation(EasyBeanAttribute.class);
        this.wasAnnotated = attMeta != null;
        this.wasReadAnnotated = this.wasAnnotated;
        this.wasWriteAnnotated = this.wasAnnotated;
        if (this.wasAnnotated) {
            this.name = SharedMethods.hasContent(attMeta.name()) ? attMeta.name() : SharedMethods.capatalize(field.getName());
            this.description = SharedMethods.hasContent(attMeta.description()) ? attMeta.description() : this.name;
        } else {
            this.description = this.name = SharedMethods.capatalize(field.getName());
        }
        this.typeMapping = OpenTypeMapper.mapToOpenType(field);
        this.descriptor = SharedMethods.getDescriptor(field);
        this.writeable = Modifier.isFinal(field.getModifiers()) ? false : (attMeta != null ? !attMeta.readOnly() : true);
    }

    EasyBeanAttributeStructure(Class clazz, Method getter, Method setter, String getterSetterName) {
        super(clazz);
        assert (getter != null || setter != null);
        this.getter = getter;
        this.setter = setter;
        EasyBeanAttribute getterMeta = getter == null ? null : getter.getAnnotation(EasyBeanAttribute.class);
        EasyBeanAttribute setterMeta = setter == null ? null : setter.getAnnotation(EasyBeanAttribute.class);
        this.wasReadAnnotated = getterMeta != null;
        this.wasWriteAnnotated = setterMeta != null;
        boolean bl = this.wasAnnotated = this.wasReadAnnotated || this.wasWriteAnnotated;
        if (this.wasReadAnnotated) {
            if (SharedMethods.hasContent(getterMeta.name())) {
                this.name = getterMeta.name();
            } else {
                String string = this.name = this.wasWriteAnnotated && SharedMethods.hasContent(setterMeta.name()) ? setterMeta.name() : getterSetterName;
            }
            this.description = SharedMethods.hasContent(getterMeta.description()) ? getterMeta.description() : (this.wasWriteAnnotated && SharedMethods.hasContent(setterMeta.description()) ? setterMeta.description() : getterSetterName);
        } else {
            this.name = this.wasWriteAnnotated && SharedMethods.hasContent(setterMeta.name()) ? setterMeta.name() : getterSetterName;
            this.description = this.wasWriteAnnotated && SharedMethods.hasContent(setterMeta.description()) ? setterMeta.description() : getterSetterName;
        }
        this.field = null;
        this.typeMapping = OpenTypeMapper.mapAttributeToOpenType(getter != null ? getter : setter);
        this.descriptor = SharedMethods.getDescriptor(getter, setter);
        if (setter == null) {
            this.writeable = false;
        } else {
            boolean readOnly = getterMeta != null && getterMeta.readOnly();
            readOnly = readOnly || setterMeta != null && setterMeta.readOnly();
            this.writeable = !readOnly;
        }
    }

    boolean isIs() {
        return this.getter != null ? this.getter.getName().startsWith("is") : false;
    }

    boolean hasReadAccess() {
        return this.field != null || this.getter != null;
    }

    boolean hasWriteAccess() {
        return this.writeable;
    }

    Object get(Object pojo) throws IllegalAccessException, InvocationTargetException {
        if (this.field != null) {
            return this.field.get(pojo);
        }
        if (this.getter != null) {
            return this.getter.invoke(pojo, new Object[0]);
        }
        return null;
    }

    void set(Object pojo, Object value) throws IllegalAccessException, InvocationTargetException {
        if (this.field != null) {
            this.field.set(pojo, value);
        } else if (this.setter != null) {
            this.setter.invoke(pojo, value);
        }
    }
}

