/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.easybeans;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import org.baswell.easybeans.EasyBeanNotification;
import org.baswell.easybeans.EasyBeanNotifications;
import org.baswell.easybeans.EasyBeanWrapper;
import org.baswell.easybeans.EasyBeansNotifier;
import org.baswell.easybeans.EasyBeansNotifierUser;
import org.baswell.easybeans.InvalidEasyBeanAnnotation;
import org.baswell.easybeans.InvalidEasyBeanNameException;
import org.baswell.easybeans.InvalidEasyBeanOpenType;
import org.baswell.easybeans.SharedMethods;

public class EasyBeanNotificationWrapper
extends EasyBeanWrapper
implements NotificationEmitter,
EasyBeansNotifier {
    private List<NotificationListenerDatum> notificationListenerData;
    private AtomicLong sequenceNumberGenerator;

    public EasyBeanNotificationWrapper(EasyBeansNotifierUser bean) throws InvalidEasyBeanNameException, InvalidEasyBeanAnnotation, InvalidEasyBeanOpenType {
        super(bean);
        bean.setNotifier(this);
        this.sequenceNumberGenerator = new AtomicLong();
        this.notificationListenerData = new ArrayList<NotificationListenerDatum>();
    }

    public EasyBeanNotificationWrapper(NotificationBroadcaster bean) throws InvalidEasyBeanNameException, InvalidEasyBeanAnnotation, InvalidEasyBeanOpenType {
        super(bean);
    }

    @Override
    public void notify(String type, String message) {
        this.notify(new Notification(type, (Object)this.bean.getClass().getName(), this.sequenceNumberGenerator.incrementAndGet(), message));
    }

    @Override
    public void notify(Notification notification) {
        for (NotificationListenerDatum notificationListenerDatum : this.notificationListenerData) {
            notificationListenerDatum.notifyIfNotFiltered(notification);
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.mBeanInfo.getNotifications();
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (this.bean instanceof NotificationBroadcaster) {
            ((NotificationBroadcaster)this.bean).addNotificationListener(listener, filter, handback);
        }
        if (this.bean instanceof EasyBeansNotifierUser) {
            this.notificationListenerData.add(new NotificationListenerDatum(listener, filter, handback));
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (this.bean instanceof NotificationEmitter) {
            ((NotificationEmitter)this.bean).removeNotificationListener(listener, filter, handback);
        } else if (this.bean instanceof NotificationBroadcaster) {
            ((NotificationBroadcaster)this.bean).removeNotificationListener(listener);
        }
        if (this.bean instanceof EasyBeansNotifierUser) {
            for (int i = this.notificationListenerData.size() - 1; i >= 0; --i) {
                NotificationListenerDatum listenerEntry = this.notificationListenerData.get(i);
                if (!listenerEntry.equals(listener, filter, handback)) continue;
                this.notificationListenerData.remove(i);
            }
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (this.bean instanceof NotificationBroadcaster) {
            ((NotificationBroadcaster)this.bean).removeNotificationListener(listener);
        }
        if (this.bean instanceof EasyBeansNotifierUser) {
            for (int i = this.notificationListenerData.size() - 1; i >= 0; --i) {
                NotificationListenerDatum listenerEntry = this.notificationListenerData.get(i);
                if (!listenerEntry.equals(listener)) continue;
                this.notificationListenerData.remove(i);
            }
        }
    }

    @Override
    MBeanNotificationInfo[] loadNotificationInfo() {
        MBeanNotificationInfo[] notificationInfo = null;
        if (this.bean instanceof NotificationBroadcaster) {
            notificationInfo = ((NotificationBroadcaster)this.bean).getNotificationInfo();
        }
        if (notificationInfo != null && notificationInfo.length > 0) {
            return notificationInfo;
        }
        Annotation[] annotations = this.bean.getClass().getAnnotations();
        ArrayList<ModelMBeanNotificationInfo> notificationInfoList = new ArrayList<ModelMBeanNotificationInfo>();
        for (Annotation annotation : annotations) {
            if (annotation instanceof EasyBeanNotification) {
                EasyBeanNotification notificationMeta = (EasyBeanNotification)annotation;
                String name = notificationMeta.name();
                String description = notificationMeta.description();
                String[] notifyTypes = notificationMeta.types();
                notificationInfoList.add(new ModelMBeanNotificationInfo(notifyTypes, name, description, SharedMethods.getDescriptor(Arrays.asList(notificationMeta.descriptor()))));
                continue;
            }
            if (!(annotation instanceof EasyBeanNotifications)) continue;
            for (EasyBeanNotification notificationMeta : ((EasyBeanNotifications)annotation).value()) {
                String name = notificationMeta.name();
                String description = notificationMeta.description();
                String[] notifyTypes = notificationMeta.types();
                notificationInfoList.add(new ModelMBeanNotificationInfo(notifyTypes, name, description, SharedMethods.getDescriptor(Arrays.asList(notificationMeta.descriptor()))));
            }
        }
        return notificationInfoList.toArray(new ModelMBeanNotificationInfo[notificationInfoList.size()]);
    }

    private class NotificationListenerDatum {
        private NotificationListener listener;
        private NotificationFilter filter;
        private Object handback;

        public NotificationListenerDatum(NotificationListener listener, NotificationFilter filter, Object handback) {
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
        }

        void notifyIfNotFiltered(Notification notification) {
            if (this.filter == null || this.filter.isNotificationEnabled(notification)) {
                this.listener.handleNotification(notification, this.handback);
            }
        }

        boolean equals(NotificationListener listener, NotificationFilter filter, Object handback) {
            return this.listener == listener && this.filter == filter && this.handback == handback;
        }

        boolean equals(NotificationListener listener) {
            return this.listener == listener;
        }
    }
}

