/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.easybeans;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.management.Descriptor;
import org.baswell.easybeans.EasyBeanOpenType;
import org.baswell.easybeans.EasyBeanOpenTypeAttribute;
import org.baswell.easybeans.EasyBeanOpenTypeExposure;
import org.baswell.easybeans.EasyBeanTransient;
import org.baswell.easybeans.InvalidEasyBeanAnnotation;
import org.baswell.easybeans.InvalidEasyBeanOpenType;
import org.baswell.easybeans.SharedMethods;

class EasyBeanOpenTypeStructure {
    private String name;
    private String description;
    private EasyBeanOpenTypeExposure exposure;
    private Descriptor descriptor;
    private Type type;
    private Class rawClass;
    private Field field;
    private Method method;
    private Method getter;
    private Method setter;

    EasyBeanOpenTypeStructure(Type type) {
        this.type = type;
        this.rawClass = this.findRawClass(type);
        this.descriptor = SharedMethods.getDescriptor(this.rawClass);
        this.loadAttributes();
    }

    EasyBeanOpenTypeStructure(Field field) {
        this.field = field;
        this.type = field.getGenericType();
        this.rawClass = field.getType();
        this.descriptor = SharedMethods.getDescriptor(field);
        this.loadAttributes();
    }

    EasyBeanOpenTypeStructure(Method method, boolean attribute) {
        this.method = method;
        if (attribute) {
            if (method.getParameterTypes().length == 0) {
                this.type = method.getGenericReturnType();
                this.rawClass = method.getReturnType();
                this.getter = method;
            } else {
                this.type = method.getGenericParameterTypes()[0];
                this.rawClass = method.getParameterTypes()[0];
                this.setter = method;
            }
        } else {
            this.type = method.getGenericReturnType();
            this.rawClass = method.getReturnType();
        }
        this.descriptor = SharedMethods.getDescriptor(method);
        this.loadAttributes();
    }

    List<EasyBeanOpenTypeStructure> getAttributes() {
        List<Method> allMethods = SharedMethods.getAllMethods(this.rawClass);
        ArrayList<EasyBeanOpenTypeStructure> attributes = new ArrayList<EasyBeanOpenTypeStructure>();
        HashSet attributeNamesCreated = new HashSet();
        for (Method method : allMethods) {
            if (Modifier.isPublic(method.getModifiers())) {
                EasyBeanOpenTypeAttribute attributeMeta = method.getAnnotation(EasyBeanOpenTypeAttribute.class);
                if (method.getAnnotation(EasyBeanTransient.class) == null) {
                    if (attributeMeta == null && (this.exposure != EasyBeanOpenTypeExposure.ALL || !SharedMethods.isStandardGetter(method))) continue;
                    if (!SharedMethods.isSignatureGetter(method)) {
                        throw new InvalidEasyBeanAnnotation(this.rawClass, "Method " + method.getName() + " is annotated with EasyBeanOpenTypeAttribute but does not have a getter signature.");
                    }
                    attributes.add(new EasyBeanOpenTypeStructure(method, true));
                    continue;
                }
                if (method.getAnnotation(EasyBeanOpenTypeAttribute.class) == null) continue;
                throw new InvalidEasyBeanAnnotation(this.rawClass, "Method " + method.getName() + " is annotated with EasyBeanTransient and EasyBeanOpenTypeAttribute.");
            }
            if (method.getAnnotation(EasyBeanOpenTypeAttribute.class) == null) continue;
            throw new InvalidEasyBeanAnnotation(this.rawClass, "Non-public method " + method.getName() + " is annotated with EasyBeanOpenTypeAttribute.");
        }
        List<Field> allFields = SharedMethods.getAllFields(this.rawClass);
        for (Field field : allFields) {
            if (Modifier.isPublic(field.getModifiers())) {
                if (field.getAnnotation(EasyBeanTransient.class) == null) {
                    if (attributeNamesCreated.contains(field.getName().toLowerCase()) || this.exposure != EasyBeanOpenTypeExposure.ALL && field.getAnnotation(EasyBeanOpenTypeAttribute.class) == null) continue;
                    attributes.add(new EasyBeanOpenTypeStructure(field));
                    continue;
                }
                if (field.getAnnotation(EasyBeanOpenTypeAttribute.class) == null) continue;
                throw new InvalidEasyBeanAnnotation(this.rawClass, "Field " + field.getName() + " is annotated with EasyBeanTransient and EasyBeanOpenTypeAttribute.");
            }
            if (field.getAnnotation(EasyBeanOpenTypeAttribute.class) == null) continue;
            throw new InvalidEasyBeanAnnotation(this.rawClass, "Non-public field " + field.getName() + " is annotated with EasyBeanOpenTypeAttribute.");
        }
        return attributes;
    }

    String getName() {
        return this.name;
    }

    String getDescription() {
        return this.description;
    }

    Type getType() {
        return this.type;
    }

    Class getRawClass() {
        return this.rawClass;
    }

    boolean isTransient() {
        return this.getAnnotation(EasyBeanTransient.class) != null;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    Object get(Object pojo) throws IllegalAccessException, InvocationTargetException {
        if (this.field != null) {
            return this.field.get(pojo);
        }
        if (this.getter != null) {
            return this.getter.invoke(pojo, new Object[0]);
        }
        return null;
    }

    private void loadAttributes() {
        EasyBeanOpenType annotation = this.getAnnotation(EasyBeanOpenType.class);
        if (annotation != null) {
            this.name = annotation.name();
            this.description = annotation.description();
            this.exposure = annotation.exposure();
            if (annotation.exposeAsString()) {
                this.rawClass = String.class;
            }
        }
        if (SharedMethods.nullEmpty(this.name)) {
            this.name = this.rawClass.getSimpleName();
        }
        if (SharedMethods.nullEmpty(this.description)) {
            this.description = this.name;
        }
    }

    private <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T annotation = null;
        if (this.field != null) {
            annotation = this.field.getAnnotation(annotationClass);
        } else if (this.method != null) {
            annotation = this.method.getAnnotation(annotationClass);
        }
        if (annotation == null && this.rawClass != null) {
            annotation = this.rawClass.getAnnotation(annotationClass);
        }
        return annotation;
    }

    private Class findRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            return this.findRawClass(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof ParameterizedType) {
            return this.findRawClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            WildcardType wildCardType = (WildcardType)type;
            if (wildCardType.getLowerBounds().length > 0) {
                return this.findRawClass(wildCardType.getLowerBounds()[0]);
            }
            if (wildCardType.getUpperBounds().length > 0) {
                return this.findRawClass(wildCardType.getUpperBounds()[0]);
            }
            throw new InvalidEasyBeanOpenType(type, "Unable to convertToOpenType WildCardType with no lower or upper bounds.");
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            if (typeVar.getBounds().length > 0) {
                return this.findRawClass(typeVar.getBounds()[0]);
            }
            throw new InvalidEasyBeanOpenType(type, "Unable to convertToOpenType TypeVariable with no bounds.");
        }
        throw new InvalidEasyBeanOpenType(type, "Unsupported type.");
    }
}

