/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.easybeans;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.baswell.easybeans.EasyBeanMemberStructure;
import org.baswell.easybeans.EasyBeanOperation;
import org.baswell.easybeans.OpenTypeMapper;
import org.baswell.easybeans.OperationImpact;
import org.baswell.easybeans.SharedMethods;

class EasyBeanOperationStructure
extends EasyBeanMemberStructure {
    final Method method;
    final OperationImpact impact;
    final String[] parameterNames;
    final String[] parameterDescriptions;
    final String[] parameterDefaultValues;

    EasyBeanOperationStructure(Class clazz, Method method) {
        super(clazz);
        assert (method != null);
        this.method = method;
        EasyBeanOperation oppMeta = method.getAnnotation(EasyBeanOperation.class);
        boolean bl = this.wasAnnotated = oppMeta != null;
        if (oppMeta != null) {
            this.name = SharedMethods.hasContent(oppMeta.name()) ? oppMeta.name() : method.getName();
            this.description = SharedMethods.hasContent(oppMeta.description()) ? oppMeta.description() : this.name;
            this.parameterNames = oppMeta.parameterNames();
            this.parameterDescriptions = oppMeta.parameterDescriptions();
            this.parameterDefaultValues = oppMeta.parameterDefaultValues();
            this.impact = oppMeta.impact();
        } else {
            this.description = this.name = method.getName();
            this.parameterNames = null;
            this.parameterDescriptions = null;
            this.parameterDefaultValues = null;
            this.impact = OperationImpact.UNKNOWN;
        }
        this.typeMapping = OpenTypeMapper.mapOperationToOpenType(method);
        this.descriptor = SharedMethods.getDescriptor(method);
    }

    boolean signatureMatches(String[] parameterClassNames) {
        Class<?>[] sigClasses = this.method.getParameterTypes();
        if (sigClasses.length == parameterClassNames.length) {
            for (int i = 0; i < sigClasses.length; ++i) {
                if (SharedMethods.classesEquivalent(sigClasses[i], parameterClassNames[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    Object invoke(Object pojo, Object ... parameters) throws IllegalAccessException, InvocationTargetException {
        return this.method.invoke(pojo, parameters);
    }
}

