/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.easybeans;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.management.Descriptor;
import org.baswell.easybeans.EasyBean;
import org.baswell.easybeans.EasyBeanAttribute;
import org.baswell.easybeans.EasyBeanAttributeStructure;
import org.baswell.easybeans.EasyBeanConstructorStructure;
import org.baswell.easybeans.EasyBeanExposure;
import org.baswell.easybeans.EasyBeanOperation;
import org.baswell.easybeans.EasyBeanOperationStructure;
import org.baswell.easybeans.EasyBeanTransient;
import org.baswell.easybeans.InvalidEasyBeanAnnotation;
import org.baswell.easybeans.SharedMethods;

class EasyBeanStructure {
    final Class clazz;
    final String className;
    final String objectName;
    final String description;
    final EasyBeanExposure exposure;
    final Descriptor descriptor;
    final List<EasyBeanConstructorStructure> constructors;
    final List<EasyBeanAttributeStructure> attributes;
    final List<EasyBeanOperationStructure> operations;

    EasyBeanStructure(Class clazz) throws InvalidEasyBeanAnnotation {
        this.clazz = clazz;
        this.className = clazz.getCanonicalName();
        EasyBean easyBeanAnnotation = clazz.getAnnotation(EasyBean.class);
        this.objectName = easyBeanAnnotation == null ? null : easyBeanAnnotation.objectName();
        this.description = easyBeanAnnotation == null ? null : easyBeanAnnotation.description();
        this.exposure = easyBeanAnnotation == null ? null : easyBeanAnnotation.exposure();
        this.descriptor = easyBeanAnnotation == null ? null : SharedMethods.getDescriptor(clazz.getAnnotations());
        List<Constructor> publicConstructors = EasyBeanStructure.getPublicNonTransientConstructors(clazz);
        ArrayList<EasyBeanConstructorStructure> constructors = new ArrayList<EasyBeanConstructorStructure>();
        for (Constructor publicConstructor : publicConstructors) {
            constructors.add(new EasyBeanConstructorStructure(clazz, publicConstructor));
        }
        this.constructors = constructors;
        List<Method> allMethods = SharedMethods.getAllMethods(clazz);
        ArrayList<EasyBeanOperationStructure> operations = new ArrayList<EasyBeanOperationStructure>();
        ArrayList<EasyBeanAttributeStructure> attributes = new ArrayList<EasyBeanAttributeStructure>();
        HashSet<String> attributeNamesCreated = new HashSet<String>();
        for (Method method : allMethods) {
            if (Modifier.isPublic(method.getModifiers())) {
                if (method.getAnnotation(EasyBeanTransient.class) == null) {
                    EasyBeanAttribute attributeMeta;
                    EasyBeanOperation operationMeta = method.getAnnotation(EasyBeanOperation.class);
                    if (operationMeta != null & (attributeMeta = method.getAnnotation(EasyBeanAttribute.class)) != null) {
                        throw new InvalidEasyBeanAnnotation(clazz, "Method " + method.getName() + " is annotated with EasyBeanAttribute and EasyBeanOperation.");
                    }
                    if (operationMeta == null && SharedMethods.isStandardGetter(method)) {
                        String getterAttName = SharedMethods.getGetterSetterName(method.getName());
                        if (attributeNamesCreated.contains(getterAttName.toLowerCase())) continue;
                        attributeNamesCreated.add(getterAttName.toLowerCase());
                        Method setterMethod = null;
                        for (Method anotherPublicMethod : allMethods) {
                            if (!SharedMethods.isStandardSetter(anotherPublicMethod) || !SharedMethods.getGetterSetterName(anotherPublicMethod.getName()).equals(getterAttName)) continue;
                            setterMethod = anotherPublicMethod;
                            break;
                        }
                        attributes.add(new EasyBeanAttributeStructure(clazz, method, setterMethod, getterAttName));
                        continue;
                    }
                    if (operationMeta == null && SharedMethods.isStandardSetter(method)) {
                        String setterAttName = SharedMethods.getGetterSetterName(method.getName());
                        if (attributeNamesCreated.contains(setterAttName.toLowerCase())) continue;
                        attributeNamesCreated.add(setterAttName.toLowerCase());
                        Method getterMethod = null;
                        for (Method anotherPublicMethod : allMethods) {
                            if (!SharedMethods.isStandardGetter(anotherPublicMethod) || !SharedMethods.getGetterSetterName(anotherPublicMethod.getName()).equals(setterAttName)) continue;
                            getterMethod = anotherPublicMethod;
                            break;
                        }
                        attributes.add(new EasyBeanAttributeStructure(clazz, getterMethod, method, setterAttName));
                        continue;
                    }
                    operations.add(new EasyBeanOperationStructure(clazz, method));
                    continue;
                }
                if (method.getAnnotation(EasyBeanAttribute.class) != null) {
                    throw new InvalidEasyBeanAnnotation(clazz, "Method " + method.getName() + " is annotated with EasyBeanTransient and EasyBeanAttribute.");
                }
                if (method.getAnnotation(EasyBeanOperation.class) == null) continue;
                throw new InvalidEasyBeanAnnotation(clazz, "Method " + method.getName() + " is annotated with EasyBeanTransient and EasyBeanOperation.");
            }
            if (method.getAnnotation(EasyBeanAttribute.class) != null) {
                throw new InvalidEasyBeanAnnotation(clazz, "Non-public method " + method.getName() + " is annotated with EasyBeanAttribute.");
            }
            if (method.getAnnotation(EasyBeanOperation.class) == null) continue;
            throw new InvalidEasyBeanAnnotation(clazz, "Non-public method " + method.getName() + " is annotated with EasyBeanOperation.");
        }
        List<Field> allFields = SharedMethods.getAllFields(clazz);
        for (Field field : allFields) {
            if (Modifier.isPublic(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())) {
                EasyBeanTransient transientAnnotation = field.getAnnotation(EasyBeanTransient.class);
                if (transientAnnotation == null) {
                    if (attributeNamesCreated.contains(field.getName().toLowerCase())) continue;
                    attributes.add(new EasyBeanAttributeStructure(clazz, field));
                    continue;
                }
                if (field.getAnnotation(EasyBeanAttribute.class) == null) continue;
                throw new InvalidEasyBeanAnnotation(clazz, "Field " + field.getName() + " is annotated with EasyBeanTransient and EasyBeanAttribute.");
            }
            if (field.getAnnotation(EasyBeanAttribute.class) == null) continue;
            throw new InvalidEasyBeanAnnotation(clazz, "Non-public field " + field.getName() + " is annotated with EasyBeanAttribute.");
        }
        this.attributes = Collections.unmodifiableList(attributes);
        this.operations = Collections.unmodifiableList(operations);
    }

    static List<Constructor> getPublicNonTransientConstructors(Class clazz) {
        ArrayList<Constructor> publicConstructors = new ArrayList<Constructor>();
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors != null) {
            for (Constructor<?> constructor : constructors) {
                if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getAnnotation(EasyBeanTransient.class) != null) continue;
                publicConstructors.add(constructor);
            }
        }
        return publicConstructors;
    }
}

