/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.easybeans;

import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import org.baswell.easybeans.EasyBeanAttributeStructure;
import org.baswell.easybeans.EasyBeanConstructorStructure;
import org.baswell.easybeans.EasyBeanDescriptor;
import org.baswell.easybeans.EasyBeanExposure;
import org.baswell.easybeans.EasyBeanNameProvider;
import org.baswell.easybeans.EasyBeanOperationStructure;
import org.baswell.easybeans.EasyBeanStructure;
import org.baswell.easybeans.InvalidEasyBeanAnnotation;
import org.baswell.easybeans.InvalidEasyBeanNameException;
import org.baswell.easybeans.InvalidEasyBeanOpenType;
import org.baswell.easybeans.ObjectNameAlreadyRegistered;
import org.baswell.easybeans.OpenTypeConverter;
import org.baswell.easybeans.OpenTypeMapper;
import org.baswell.easybeans.OpenTypeMapping;
import org.baswell.easybeans.P;
import org.baswell.easybeans.Pair;
import org.baswell.easybeans.SharedMethods;
import org.baswell.easybeans.UnexpectedEasyBeanException;

public class EasyBeanWrapper
implements DynamicMBean {
    Object bean;
    EasyBeanExposure exposure;
    MBeanInfo mBeanInfo;
    ObjectName objectName;
    Map<String, EasyBeanAttributeStructure> readableAttributeStructures;
    Map<String, EasyBeanAttributeStructure> writableAttributeStructures;
    Map<String, List<EasyBeanOperationStructure>> operationStructures;

    public EasyBeanWrapper(Object bean) throws InvalidEasyBeanNameException, InvalidEasyBeanAnnotation, InvalidEasyBeanOpenType {
        this(bean, null);
    }

    public EasyBeanWrapper(Object bean, EasyBeanExposure exposure) throws InvalidEasyBeanNameException, InvalidEasyBeanAnnotation, InvalidEasyBeanOpenType {
        this.bean = bean;
        Class<?> clazz = bean.getClass();
        EasyBeanStructure beanStructure = new EasyBeanStructure(clazz);
        String objectNameString = null;
        objectNameString = SharedMethods.hasContent(beanStructure.objectName) ? beanStructure.objectName : clazz.getPackage().getName() + ":Name=" + clazz.getSimpleName();
        try {
            if (bean instanceof EasyBeanNameProvider) {
                this.objectName = ((EasyBeanNameProvider)bean).getObjectName();
                if (this.objectName == null) {
                    throw new InvalidEasyBeanNameException(clazz, "Object name cannot be null.", null);
                }
            } else {
                this.objectName = new ObjectName(objectNameString);
            }
            this.exposure = exposure != null ? exposure : (beanStructure.exposure != null ? beanStructure.exposure : EasyBeanExposure.ANNOTATED);
            OpenMBeanConstructorInfo[] constructorInfo = this.loadConstructorInfo(beanStructure.constructors);
            OpenMBeanAttributeInfo[] attributeInfo = this.loadAttributeInfo(beanStructure.attributes);
            OpenMBeanOperationInfo[] opInfo = this.loadOperationInfo(beanStructure.operations);
            MBeanNotificationInfo[] notificationInfo = this.loadNotificationInfo();
            this.mBeanInfo = new OpenMBeanInfoSupport(beanStructure.className, beanStructure.description, attributeInfo, constructorInfo, opInfo, notificationInfo, beanStructure.descriptor);
        }
        catch (MalformedObjectNameException monexc) {
            throw new InvalidEasyBeanNameException(clazz, objectNameString, monexc);
        }
    }

    public void register() throws ObjectNameAlreadyRegistered, UnexpectedEasyBeanException {
        this.register(ManagementFactory.getPlatformMBeanServer());
    }

    public void register(MBeanServer mBeanServer) throws ObjectNameAlreadyRegistered, UnexpectedEasyBeanException {
        try {
            mBeanServer.registerMBean(this, this.objectName);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new ObjectNameAlreadyRegistered(e, this.bean.getClass(), this.objectName);
        }
        catch (MBeanRegistrationException e) {
            throw new UnexpectedEasyBeanException(e);
        }
        catch (NotCompliantMBeanException e) {
            throw new UnexpectedEasyBeanException(e);
        }
    }

    public void unregister() throws UnexpectedEasyBeanException {
        this.unregister(ManagementFactory.getPlatformMBeanServer());
    }

    public void unregister(MBeanServer mBeanServer) throws UnexpectedEasyBeanException {
        try {
            mBeanServer.unregisterMBean(this.objectName);
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MBeanRegistrationException e) {
            throw new UnexpectedEasyBeanException(e);
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (!this.readableAttributeStructures.containsKey(attribute)) {
            throw new AttributeNotFoundException("No readable attribute found with name '" + attribute + "'.");
        }
        try {
            EasyBeanAttributeStructure beanAttribute = this.readableAttributeStructures.get(attribute);
            Object value = beanAttribute.get(this.bean);
            return OpenTypeConverter.convertToOpenType(value, beanAttribute.typeMapping);
        }
        catch (Exception exc) {
            String line = exc.getStackTrace()[0].toString();
            throw new ReflectionException(exc, "Unable to execute read attribute on " + attribute + " due to error: " + exc.getMessage() + " at line: " + line);
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList attList = new AttributeList();
        for (String attribute : attributes) {
            try {
                attList.add(new Attribute(attribute, this.getAttribute(attribute)));
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        return attList;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (this.operationStructures.containsKey(actionName)) {
            List<EasyBeanOperationStructure> operations = this.operationStructures.get(actionName);
            for (EasyBeanOperationStructure operation : operations) {
                if (!operation.signatureMatches(signature)) continue;
                try {
                    return OpenTypeConverter.convertToOpenType(operation.invoke(this.bean, params), operation.typeMapping);
                }
                catch (Throwable exc) {
                    if (exc instanceof InvocationTargetException) {
                        exc = ((InvocationTargetException)exc).getTargetException();
                    }
                    String line = exc.getStackTrace()[0].toString();
                    throw new RuntimeException("Unable to execute operation " + actionName + " due to error: " + exc.getMessage() + " at line: " + line);
                }
            }
        }
        throw new NoSuchElementException("No matching operation found with name " + actionName + " and signature " + signature);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String attName = attribute.getName();
        if (!this.writableAttributeStructures.containsKey(attName)) {
            throw new AttributeNotFoundException("No writeable attribute found with name '" + attName + "'.");
        }
        try {
            this.writableAttributeStructures.get(attName).set(this.bean, attribute.getValue());
        }
        catch (Exception exc) {
            String line = exc.getStackTrace()[0].toString();
            throw new RuntimeException("Unable to execute write attribute on " + attribute + " due to error: " + exc.getMessage() + " at line: " + line);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList updateAttributes = new AttributeList();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attribute = (Attribute)attributes.get(i);
            String attName = attribute.getName();
            try {
                this.setAttribute(attribute);
                updateAttributes.add(new Attribute(attName, this.getAttribute(attName)));
                continue;
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        return updateAttributes;
    }

    MBeanNotificationInfo[] loadNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    OpenMBeanConstructorInfo[] loadConstructorInfo(List<EasyBeanConstructorStructure> beanConstructors) {
        ArrayList<OpenMBeanConstructorInfoSupport> constructorsInfo = new ArrayList<OpenMBeanConstructorInfoSupport>();
        for (EasyBeanConstructorStructure beanConstructor : beanConstructors) {
            OpenMBeanParameterInfo[] paramsInfo;
            if (!beanConstructor.wasAnnotated && this.exposure != EasyBeanExposure.ALL || (paramsInfo = EasyBeanWrapper.getParameterInfo(this.bean.getClass(), beanConstructor.constructor.getParameterTypes(), beanConstructor.constructor.getParameterAnnotations(), beanConstructor.parameterNames, beanConstructor.parameterDescriptions, null)) == null) continue;
            constructorsInfo.add(new OpenMBeanConstructorInfoSupport(beanConstructor.name, beanConstructor.description, paramsInfo, beanConstructor.descriptor));
        }
        return constructorsInfo.toArray(new OpenMBeanConstructorInfo[constructorsInfo.size()]);
    }

    OpenMBeanAttributeInfo[] loadAttributeInfo(List<EasyBeanAttributeStructure> beanAttributes) {
        this.readableAttributeStructures = new HashMap<String, EasyBeanAttributeStructure>();
        this.writableAttributeStructures = new HashMap<String, EasyBeanAttributeStructure>();
        ArrayList<OpenMBeanAttributeInfoSupport> attributesInfo = new ArrayList<OpenMBeanAttributeInfoSupport>();
        for (EasyBeanAttributeStructure beanAttribute : beanAttributes) {
            boolean isWritable;
            if (beanAttribute.typeMapping == null) continue;
            boolean isReadable = beanAttribute.hasReadAccess() && (beanAttribute.wasReadAnnotated || this.exposure != EasyBeanExposure.ANNOTATED);
            boolean bl = isWritable = beanAttribute.hasWriteAccess() && (beanAttribute.wasWriteAnnotated || this.exposure == EasyBeanExposure.ALL);
            if (!isReadable && !isWritable) continue;
            attributesInfo.add(new OpenMBeanAttributeInfoSupport(beanAttribute.name, beanAttribute.description, beanAttribute.typeMapping.getOpenType(), isReadable, isWritable, beanAttribute.isIs(), beanAttribute.descriptor));
            if (isReadable) {
                this.readableAttributeStructures.put(beanAttribute.name, beanAttribute);
            }
            if (!isWritable) continue;
            this.writableAttributeStructures.put(beanAttribute.name, beanAttribute);
        }
        Collections.sort(attributesInfo, new Comparator<OpenMBeanAttributeInfo>(){

            @Override
            public int compare(OpenMBeanAttributeInfo a1, OpenMBeanAttributeInfo a2) {
                return a1.getName().compareTo(a2.getName());
            }
        });
        return attributesInfo.toArray(new OpenMBeanAttributeInfoSupport[attributesInfo.size()]);
    }

    OpenMBeanOperationInfo[] loadOperationInfo(List<EasyBeanOperationStructure> beanOperations) {
        this.operationStructures = new HashMap<String, List<EasyBeanOperationStructure>>();
        ArrayList<OpenMBeanOperationInfoSupport> operationsInfo = new ArrayList<OpenMBeanOperationInfoSupport>();
        for (EasyBeanOperationStructure beanOperation : beanOperations) {
            List<Object> operationsWithSameName;
            OpenMBeanParameterInfo[] paramsInfo;
            if (beanOperation.typeMapping == null || !beanOperation.wasAnnotated && this.exposure != EasyBeanExposure.ALL || (paramsInfo = EasyBeanWrapper.getParameterInfo(this.bean.getClass(), beanOperation.method.getParameterTypes(), beanOperation.method.getParameterAnnotations(), beanOperation.parameterNames, beanOperation.parameterDescriptions, beanOperation.parameterDefaultValues)) == null) continue;
            operationsInfo.add(new OpenMBeanOperationInfoSupport(beanOperation.name, beanOperation.description, paramsInfo, beanOperation.typeMapping.getOpenType(), beanOperation.impact.getMBeanImpact(), beanOperation.descriptor));
            if (this.operationStructures.containsKey(beanOperation.name)) {
                operationsWithSameName = this.operationStructures.get(beanOperation.name);
            } else {
                operationsWithSameName = new ArrayList();
                this.operationStructures.put(beanOperation.name, operationsWithSameName);
            }
            operationsWithSameName.add(beanOperation);
        }
        Collections.sort(operationsInfo, new Comparator<OpenMBeanOperationInfo>(){

            @Override
            public int compare(OpenMBeanOperationInfo o1, OpenMBeanOperationInfo o2) {
                int compare = o1.getName().compareTo(o2.getName());
                if (compare == 0) {
                    int numParams2;
                    int numParams1 = o1.getSignature().length;
                    if (numParams1 < (numParams2 = o2.getSignature().length)) {
                        return -1;
                    }
                    if (numParams1 == numParams2) {
                        return 0;
                    }
                    return 1;
                }
                return compare;
            }
        });
        return operationsInfo.toArray(new OpenMBeanOperationInfo[operationsInfo.size()]);
    }

    static OpenMBeanParameterInfo[] getParameterInfo(Class beanClass, Class<?>[] paramTypes, Annotation[][] annotations, String[] parameterNames, String[] parameterDescriptions, String[] parameterDefaultValues) {
        OpenMBeanParameterInfo[] paramsInfo = new OpenMBeanParameterInfo[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            String name = "arg" + i;
            OpenTypeMapping typeMapping = OpenTypeMapper.mapToOpenType(paramTypes[i]);
            if (typeMapping == null) {
                return null;
            }
            if (parameterNames != null && parameterNames.length > i) {
                name = parameterNames[i];
            }
            String description = parameterDescriptions != null && parameterDescriptions.length > i ? parameterDescriptions[i] : name;
            String defaultValueString = null;
            if (parameterDefaultValues != null && parameterDefaultValues.length > i) {
                defaultValueString = parameterDefaultValues[i];
            }
            ArrayList<Pair<String, Object>> descriptorPairs = new ArrayList<Pair<String, Object>>();
            for (Annotation annotation : annotations[i]) {
                if (!(annotation instanceof P)) continue;
                P jmxParameter = (P)annotation;
                if (jmxParameter.value().trim().length() > 0) {
                    name = jmxParameter.value();
                }
                if (jmxParameter.description().trim().length() > 0) {
                    description = jmxParameter.description();
                }
                if (jmxParameter.defaultValue().length > 0) {
                    defaultValueString = jmxParameter.defaultValue()[0];
                }
                for (EasyBeanDescriptor easyBeanDescriptor : jmxParameter.descriptor()) {
                    int count = Math.min(easyBeanDescriptor.names().length, easyBeanDescriptor.values().length);
                    for (int j = 0; j < count; ++j) {
                        descriptorPairs.add(Pair.pair(easyBeanDescriptor.names()[i], easyBeanDescriptor.values()[i]));
                    }
                }
                break;
            }
            if (defaultValueString != null && typeMapping.isSimpleType()) {
                Class simpleClass = typeMapping.getSimpleClass();
                if (SharedMethods.hasContent(defaultValueString) || simpleClass == String.class) {
                    descriptorPairs.add(Pair.pair("defaultValue", SharedMethods.mapSimpleType(defaultValueString, simpleClass)));
                }
            } else {
                throw new InvalidEasyBeanAnnotation(beanClass, "Default value " + defaultValueString + " for parameter " + paramTypes[i].getSimpleName() + " must be a simple type.");
            }
            Descriptor descriptor = descriptorPairs.isEmpty() ? null : SharedMethods.getDescriptorFromPairs(descriptorPairs);
            paramsInfo[i] = new OpenMBeanParameterInfoSupport(name, description, typeMapping.getOpenType(), descriptor);
        }
        return paramsInfo;
    }
}

