/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.easybeans;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcaster;
import org.baswell.easybeans.EasyBeanNotificationWrapper;
import org.baswell.easybeans.EasyBeanWrapper;
import org.baswell.easybeans.EasyBeansNotifierUser;
import org.baswell.easybeans.InvalidEasyBeanAnnotation;
import org.baswell.easybeans.InvalidEasyBeanNameException;
import org.baswell.easybeans.InvalidEasyBeanOpenType;
import org.baswell.easybeans.ObjectNameAlreadyRegistered;
import org.baswell.easybeans.UnexpectedEasyBeanException;

public class EasyBeansRegistery {
    private final MBeanServer mBeanServer;
    private Map<Object, EasyBeanWrapper> registeredBeans = new HashMap<Object, EasyBeanWrapper>();

    public EasyBeansRegistery() {
        this(ManagementFactory.getPlatformMBeanServer());
    }

    public EasyBeansRegistery(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public void register(Object bean) throws InvalidEasyBeanNameException, InvalidEasyBeanAnnotation, InvalidEasyBeanOpenType, ObjectNameAlreadyRegistered, UnexpectedEasyBeanException {
        EasyBeanWrapper wrapper = bean instanceof EasyBeanWrapper ? (EasyBeanWrapper)bean : (bean instanceof EasyBeansNotifierUser ? new EasyBeanNotificationWrapper((EasyBeansNotifierUser)bean) : (bean instanceof NotificationBroadcaster ? new EasyBeanNotificationWrapper((NotificationBroadcaster)bean) : new EasyBeanWrapper(bean)));
        wrapper.register(this.mBeanServer);
        this.registeredBeans.put(bean, wrapper);
    }

    public void register(List beans) throws InvalidEasyBeanNameException, InvalidEasyBeanAnnotation, InvalidEasyBeanOpenType, ObjectNameAlreadyRegistered, UnexpectedEasyBeanException {
        for (Object bean : beans) {
            this.register(bean);
        }
    }

    public void unregister(Object bean) throws UnexpectedEasyBeanException {
        EasyBeanWrapper wrapper = this.registeredBeans.remove(bean);
        if (wrapper != null) {
            wrapper.unregister(this.mBeanServer);
        }
    }

    public void unregisterAll() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        for (EasyBeanWrapper wrapper : this.registeredBeans.values()) {
            try {
                wrapper.unregister(this.mBeanServer);
            }
            catch (Exception exc) {}
        }
        this.registeredBeans.clear();
    }
}

