/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.easybeans;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;
import org.baswell.easybeans.EasyBeanOpenTypeStructure;
import org.baswell.easybeans.OpenTypeMapping;
import org.baswell.easybeans.Pair;

class OpenTypeMapper {
    static Map<Class, OpenTypeMapping> simpleTypeMapping = new ConcurrentHashMap<Class, OpenTypeMapping>();

    OpenTypeMapper() {
    }

    static OpenTypeMapping mapToOpenType(Class clazz) {
        return OpenTypeMapper.mapOpenType(new EasyBeanOpenTypeStructure(clazz));
    }

    static OpenTypeMapping mapToOpenType(Field field) {
        return OpenTypeMapper.mapOpenType(new EasyBeanOpenTypeStructure(field));
    }

    static OpenTypeMapping mapAttributeToOpenType(Method method) {
        return OpenTypeMapper.mapOpenType(new EasyBeanOpenTypeStructure(method, true));
    }

    static OpenTypeMapping mapOperationToOpenType(Method method) {
        return OpenTypeMapper.mapOpenType(new EasyBeanOpenTypeStructure(method, false));
    }

    static OpenTypeMapping mapOpenType(EasyBeanOpenTypeStructure typeWrapper) {
        return OpenTypeMapper.mapOpenType(typeWrapper, new ArrayList<Class>());
    }

    static OpenTypeMapping mapOpenType(EasyBeanOpenTypeStructure typeWrapper, List<Class> compositedClassesVisited) {
        Class rawClass = typeWrapper.getRawClass();
        if (typeWrapper.isTransient()) {
            return null;
        }
        if (simpleTypeMapping.containsKey(rawClass)) {
            return simpleTypeMapping.get(rawClass);
        }
        if (OpenTypeMapper.extendsClass(rawClass, Enum.class)) {
            return simpleTypeMapping.get(String.class);
        }
        if (rawClass.isArray() || OpenTypeMapper.implementsInterface(rawClass, Iterable.class)) {
            return OpenTypeMapper.mapArrayType(typeWrapper, compositedClassesVisited);
        }
        if (OpenTypeMapper.implementsInterface(rawClass, Map.class)) {
            return OpenTypeMapper.mapTabularType(typeWrapper, compositedClassesVisited);
        }
        return OpenTypeMapper.mapCompositeType(typeWrapper, compositedClassesVisited);
    }

    static OpenTypeMapping mapArrayType(EasyBeanOpenTypeStructure typeWrapper, List<Class> compositedClassesVisited) {
        Type type = typeWrapper.getType();
        Class rawClass = typeWrapper.getRawClass();
        try {
            OpenTypeMapping listTypeMapping;
            ParameterizedType paramType;
            if (rawClass.isArray()) {
                int numDimensions = OpenTypeMapper.numberArrayDimensions(rawClass);
                OpenTypeMapping elementTypeMapping = null;
                if (type instanceof GenericArrayType) {
                    GenericArrayType arrayType = (GenericArrayType)type;
                    Type componentType = OpenTypeMapper.getArrayComponentType(arrayType);
                    elementTypeMapping = OpenTypeMapper.mapOpenType(new EasyBeanOpenTypeStructure(componentType), compositedClassesVisited);
                } else {
                    Class componentClass = OpenTypeMapper.getArrayComponentClass(rawClass);
                    elementTypeMapping = OpenTypeMapper.mapOpenType(new EasyBeanOpenTypeStructure(componentClass), compositedClassesVisited);
                }
                if (elementTypeMapping == null) {
                    return null;
                }
                return new OpenTypeMapping(new ArrayType(numDimensions, elementTypeMapping.getOpenType()), elementTypeMapping);
            }
            Object componentType = null;
            if (type instanceof ParameterizedType && (paramType = (ParameterizedType)type).getActualTypeArguments().length == 1) {
                componentType = paramType.getActualTypeArguments()[0];
            }
            if (componentType == null) {
                componentType = String.class;
            }
            if ((listTypeMapping = OpenTypeMapper.mapOpenType(new EasyBeanOpenTypeStructure((Type)componentType), compositedClassesVisited)) == null) {
                return null;
            }
            return new OpenTypeMapping(new ArrayType(1, listTypeMapping.getOpenType()), listTypeMapping);
        }
        catch (OpenDataException odexc) {
            throw new RuntimeException(odexc);
        }
    }

    static OpenTypeMapping mapTabularType(EasyBeanOpenTypeStructure typeWrapper, List<Class> compositedClassesVisited) {
        ParameterizedType paramType;
        Type[] typeArgs;
        Type type = typeWrapper.getType();
        Class rawClass = typeWrapper.getRawClass();
        Pair<Object, Object> keyValueTypePair = null;
        if (type instanceof ParameterizedType && (typeArgs = (paramType = (ParameterizedType)type).getActualTypeArguments()).length == 2) {
            keyValueTypePair = Pair.pair(typeArgs[0], typeArgs[1]);
        }
        if (keyValueTypePair == null) {
            keyValueTypePair = Pair.pair(String.class, String.class);
        }
        OpenTypeMapping keyMapping = OpenTypeMapper.mapOpenType(new EasyBeanOpenTypeStructure((Type)keyValueTypePair.x), compositedClassesVisited);
        OpenTypeMapping valueMapping = OpenTypeMapper.mapOpenType(new EasyBeanOpenTypeStructure((Type)keyValueTypePair.y), compositedClassesVisited);
        if (keyMapping == null || valueMapping == null) {
            return null;
        }
        String[] attributeNames = new String[]{"key", "value"};
        String[] attributeDescriptions = new String[]{"Map key", "Map value"};
        OpenType[] attributeTypes = new OpenType[]{keyMapping.getOpenType(), valueMapping.getOpenType()};
        try {
            CompositeType rowType = new CompositeType(typeWrapper.getName(), typeWrapper.getDescription(), attributeNames, attributeDescriptions, attributeTypes);
            return new OpenTypeMapping(new TabularType(typeWrapper.getName(), typeWrapper.getDescription(), rowType, new String[]{"key"}), keyMapping, valueMapping);
        }
        catch (OpenDataException odexc) {
            throw new RuntimeException(odexc);
        }
    }

    static OpenTypeMapping mapCompositeType(EasyBeanOpenTypeStructure typeWrapper, List<Class> compositedClassesVisited) {
        Class rawClass = typeWrapper.getRawClass();
        if (compositedClassesVisited.contains(rawClass)) {
            return simpleTypeMapping.get(String.class);
        }
        try {
            compositedClassesVisited.add(rawClass);
            HashMap<String, Pair<EasyBeanOpenTypeStructure, OpenTypeMapping>> attributeMappings = new HashMap<String, Pair<EasyBeanOpenTypeStructure, OpenTypeMapping>>();
            ArrayList<String> attributeNameList = new ArrayList<String>();
            ArrayList<String> attributeDescriptionList = new ArrayList<String>();
            ArrayList<OpenType> attributeTypeList = new ArrayList<OpenType>();
            for (EasyBeanOpenTypeStructure attributeTypeWrapper : typeWrapper.getAttributes()) {
                OpenTypeMapping attributeTypeMapping = OpenTypeMapper.mapOpenType(attributeTypeWrapper, compositedClassesVisited);
                if (attributeTypeMapping == null) continue;
                attributeMappings.put(attributeTypeWrapper.getName(), Pair.pair(attributeTypeWrapper, attributeTypeMapping));
                attributeNameList.add(attributeTypeWrapper.getName());
                attributeDescriptionList.add(attributeTypeWrapper.getDescription());
                attributeTypeList.add(attributeTypeMapping.getOpenType());
            }
            if (attributeNameList.size() == 0) {
                Iterator<EasyBeanOpenTypeStructure> i$ = null;
                return i$;
            }
            String[] attributeNames = attributeNameList.toArray(new String[attributeNameList.size()]);
            String[] attributeDescriptions = attributeDescriptionList.toArray(new String[attributeDescriptionList.size()]);
            OpenType[] attributeTypes = attributeTypeList.toArray(new OpenType[attributeTypeList.size()]);
            OpenTypeMapping openTypeMapping = new OpenTypeMapping(new CompositeType(typeWrapper.getName(), typeWrapper.getDescription(), attributeNames, attributeDescriptions, attributeTypes), attributeMappings);
            return openTypeMapping;
        }
        catch (OpenDataException odexc) {
            throw new RuntimeException(odexc);
        }
        finally {
            compositedClassesVisited.remove(rawClass);
        }
    }

    static boolean implementsInterface(Class clazz, Class interfce) {
        Class<?>[] superInterfaces;
        if (clazz.equals(interfce)) {
            return true;
        }
        for (Class<?> superInterface : superInterfaces = clazz.getInterfaces()) {
            if (!OpenTypeMapper.implementsInterface(superInterface, interfce)) continue;
            return true;
        }
        return false;
    }

    static boolean extendsClass(Class clazz, Class superClass) {
        if (clazz == superClass) {
            return true;
        }
        if (clazz == Object.class) {
            return false;
        }
        if (clazz.getSuperclass() == null) {
            return false;
        }
        return OpenTypeMapper.extendsClass(clazz.getSuperclass(), superClass);
    }

    static int numberArrayDimensions(Class clazz) {
        char[] chars = clazz.getName().toCharArray();
        int numDimensions = 0;
        for (char chr : chars) {
            if (chr != '[') continue;
            ++numDimensions;
        }
        return numDimensions;
    }

    static Class getArrayComponentClass(Class clazz) {
        Class componentClass = clazz.getComponentType();
        return componentClass.isArray() ? OpenTypeMapper.getArrayComponentClass(componentClass) : componentClass;
    }

    static Type getArrayComponentType(GenericArrayType arrayType) {
        Type type = arrayType.getGenericComponentType();
        return type instanceof GenericArrayType ? OpenTypeMapper.getArrayComponentType((GenericArrayType)type) : type;
    }

    static {
        simpleTypeMapping.put(Object.class, new OpenTypeMapping(SimpleType.STRING, String.class));
        simpleTypeMapping.put(String.class, new OpenTypeMapping(SimpleType.STRING, String.class));
        simpleTypeMapping.put(BigDecimal.class, new OpenTypeMapping(SimpleType.BIGDECIMAL, BigDecimal.class));
        simpleTypeMapping.put(BigInteger.class, new OpenTypeMapping(SimpleType.BIGINTEGER, BigDecimal.class));
        simpleTypeMapping.put(Boolean.TYPE, new OpenTypeMapping(SimpleType.BOOLEAN, Boolean.class));
        simpleTypeMapping.put(Boolean.class, new OpenTypeMapping(SimpleType.BOOLEAN, Boolean.class));
        simpleTypeMapping.put(Byte.TYPE, new OpenTypeMapping(SimpleType.BYTE, Byte.class));
        simpleTypeMapping.put(Byte.class, new OpenTypeMapping(SimpleType.BYTE, Byte.class));
        simpleTypeMapping.put(Character.TYPE, new OpenTypeMapping(SimpleType.CHARACTER, Character.class));
        simpleTypeMapping.put(Character.class, new OpenTypeMapping(SimpleType.CHARACTER, Character.class));
        simpleTypeMapping.put(Date.class, new OpenTypeMapping(SimpleType.DATE, Date.class));
        simpleTypeMapping.put(Double.TYPE, new OpenTypeMapping(SimpleType.DOUBLE, Double.class));
        simpleTypeMapping.put(Double.class, new OpenTypeMapping(SimpleType.DOUBLE, Double.class));
        simpleTypeMapping.put(Float.TYPE, new OpenTypeMapping(SimpleType.FLOAT, Float.class));
        simpleTypeMapping.put(Float.class, new OpenTypeMapping(SimpleType.FLOAT, Float.class));
        simpleTypeMapping.put(Integer.TYPE, new OpenTypeMapping(SimpleType.INTEGER, Integer.class));
        simpleTypeMapping.put(Integer.class, new OpenTypeMapping(SimpleType.INTEGER, Integer.class));
        simpleTypeMapping.put(Long.TYPE, new OpenTypeMapping(SimpleType.LONG, Long.class));
        simpleTypeMapping.put(Long.class, new OpenTypeMapping(SimpleType.LONG, Long.class));
        simpleTypeMapping.put(ObjectName.class, new OpenTypeMapping(SimpleType.OBJECTNAME, ObjectName.class));
        simpleTypeMapping.put(Short.TYPE, new OpenTypeMapping(SimpleType.SHORT, Short.class));
        simpleTypeMapping.put(Short.class, new OpenTypeMapping(SimpleType.SHORT, Short.class));
        simpleTypeMapping.put(Long.TYPE, new OpenTypeMapping(SimpleType.LONG, Long.class));
        simpleTypeMapping.put(Long.class, new OpenTypeMapping(SimpleType.LONG, Long.class));
        simpleTypeMapping.put(Void.TYPE, new OpenTypeMapping(SimpleType.VOID, Void.class));
        simpleTypeMapping.put(Void.class, new OpenTypeMapping(SimpleType.VOID, Void.class));
    }
}

