/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.easybeans;

import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;
import org.baswell.easybeans.EasyBeanOpenTypeStructure;
import org.baswell.easybeans.Pair;

class OpenTypeMapping {
    private OpenType openType;
    private Class simpleClass;
    private OpenTypeMapping elementTypeMapping;
    private OpenTypeMapping keyTypeMapping;
    private OpenTypeMapping valueTypeMapping;
    private Map<String, Pair<EasyBeanOpenTypeStructure, OpenTypeMapping>> attributeMappings;

    OpenTypeMapping(SimpleType simpleType, Class simpleClass) {
        this.openType = simpleType;
        this.simpleClass = simpleClass;
    }

    OpenTypeMapping(ArrayType arrayType, OpenTypeMapping elementTypeMapping) {
        this.openType = arrayType;
        this.elementTypeMapping = elementTypeMapping;
    }

    OpenTypeMapping(TabularType tabularType, OpenTypeMapping keyTypeMapping, OpenTypeMapping valueTypeMapping) {
        this.openType = tabularType;
        this.keyTypeMapping = keyTypeMapping;
        this.valueTypeMapping = valueTypeMapping;
    }

    OpenTypeMapping(CompositeType compositeType, Map<String, Pair<EasyBeanOpenTypeStructure, OpenTypeMapping>> attributeMappings) {
        this.openType = compositeType;
        this.attributeMappings = attributeMappings;
    }

    OpenType getOpenType() {
        return this.openType;
    }

    boolean isSimpleType() {
        return this.openType instanceof SimpleType;
    }

    boolean isArrayType() {
        return this.openType instanceof ArrayType;
    }

    boolean isTabularType() {
        return this.openType instanceof TabularType;
    }

    boolean isCompositeType() {
        return this.openType instanceof CompositeType;
    }

    SimpleType getSimpleType() {
        return (SimpleType)this.openType;
    }

    ArrayType getArrayType() {
        return (ArrayType)this.openType;
    }

    TabularType getTabularType() {
        return (TabularType)this.openType;
    }

    Class getSimpleClass() {
        return this.simpleClass;
    }

    OpenTypeMapping getElementTypeMapping() {
        return this.elementTypeMapping;
    }

    OpenTypeMapping getKeyTypeMapping() {
        return this.keyTypeMapping;
    }

    OpenTypeMapping getValueTypeMapping() {
        return this.valueTypeMapping;
    }

    CompositeType getCompositeType() {
        return (CompositeType)this.openType;
    }

    EasyBeanOpenTypeStructure getAttributeStructure(String name) {
        return (EasyBeanOpenTypeStructure)this.attributeMappings.get((Object)name).x;
    }

    OpenTypeMapping getAttributeMapping(String name) {
        return (OpenTypeMapping)this.attributeMappings.get((Object)name).y;
    }
}

