/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.easybeans;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Descriptor;
import javax.management.modelmbean.DescriptorSupport;
import org.baswell.easybeans.EasyBeanDescriptor;
import org.baswell.easybeans.Pair;

class SharedMethods {
    private static Map<String, Class> classEquivalentMap = new ConcurrentHashMap<String, Class>();

    SharedMethods() {
    }

    static boolean nullEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    static boolean hasContent(String string) {
        return string != null && !string.trim().isEmpty();
    }

    static String capatalize(String text) {
        if (text.length() > 2) {
            return text.substring(0, 1).toUpperCase() + text.substring(1, text.length());
        }
        return text.toUpperCase();
    }

    static Descriptor getDescriptor(Class clazz) {
        return SharedMethods.getDescriptor(clazz.getClass().getAnnotations());
    }

    static Descriptor getDescriptor(AccessibleObject ... accessibleObjects) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (AccessibleObject accessibleObject : accessibleObjects) {
            Annotation[] annons;
            if (accessibleObject == null || (annons = accessibleObject.getAnnotations()) == null) continue;
            annotations.addAll(Arrays.asList(annons));
        }
        return SharedMethods.getDescriptor(annotations.toArray(new Annotation[annotations.size()]));
    }

    static Descriptor getDescriptor(Annotation[] annotations) {
        ArrayList<EasyBeanDescriptor> descriptors = new ArrayList<EasyBeanDescriptor>();
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof EasyBeanDescriptor)) continue;
                descriptors.add((EasyBeanDescriptor)annotation);
            }
        }
        return SharedMethods.getDescriptor(descriptors);
    }

    static Descriptor getDescriptor(List<EasyBeanDescriptor> descriptors) {
        ArrayList<Pair<String, Object>> descriptions = new ArrayList<Pair<String, Object>>();
        for (EasyBeanDescriptor descriptor : descriptors) {
            int numberFields = Math.min(descriptor.names().length, descriptor.values().length);
            for (int i = 0; i < numberFields; ++i) {
                descriptions.add(Pair.pair(descriptor.names()[i], descriptor.values()[i]));
            }
        }
        return SharedMethods.getDescriptorFromPairs(descriptions);
    }

    static Descriptor getDescriptorFromPairs(List<Pair<String, Object>> descriptions) {
        if (descriptions.size() > 0) {
            String[] names = new String[descriptions.size()];
            Object[] values = new Object[descriptions.size()];
            for (int i = 0; i < descriptions.size(); ++i) {
                names[i] = (String)descriptions.get((int)i).x;
                values[i] = descriptions.get((int)i).y;
            }
            return new DescriptorSupport(names, values);
        }
        return null;
    }

    static boolean isSignatureGetter(Method method) {
        return method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    static boolean isStandardGetter(Method method) {
        if (SharedMethods.isSignatureGetter(method)) {
            String name = method.getName();
            if (name.length() > 3 && name.startsWith("get")) {
                return true;
            }
            return name.length() > 2 && name.startsWith("is") && method.getReturnType() == Boolean.TYPE;
        }
        return false;
    }

    static boolean isSignatureSetter(Method method) {
        return method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 1;
    }

    static boolean isStandardSetter(Method method) {
        String name = method.getName();
        return name.length() > 3 && name.startsWith("set") && SharedMethods.isSignatureSetter(method);
    }

    static String getGetterSetterName(String methodName) {
        if ((methodName.startsWith("get") || methodName.startsWith("set")) && methodName.length() > 3) {
            return methodName.substring(3, methodName.length());
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            return methodName.substring(2, methodName.length());
        }
        return methodName;
    }

    static List<Field> getAllFields(Class clazz) {
        String declaringPackage;
        Class superClass;
        ArrayList<Field> allFields = new ArrayList<Field>();
        Field[] fields = clazz.getDeclaredFields();
        if (fields != null) {
            for (Field field : fields) {
                allFields.add(field);
            }
        }
        if ((superClass = clazz.getSuperclass()) != null && !(declaringPackage = superClass.getPackage().getName()).startsWith("java.") && !declaringPackage.startsWith("javax.")) {
            allFields.addAll(SharedMethods.getAllFields(superClass));
        }
        return allFields;
    }

    static List<Method> getAllMethods(Class clazz) {
        String declaringPackage;
        Class superClass;
        ArrayList<Method> allMethods = new ArrayList<Method>();
        Method[] methods = clazz.getDeclaredMethods();
        if (methods != null) {
            for (Method method : methods) {
                allMethods.add(method);
            }
        }
        if ((superClass = clazz.getSuperclass()) != null && !(declaringPackage = superClass.getPackage().getName()).startsWith("java.") && !declaringPackage.startsWith("javax.")) {
            allMethods.addAll(SharedMethods.getAllMethods(superClass));
        }
        return allMethods;
    }

    static Object mapSimpleType(String value, Class toType) throws NumberFormatException {
        if (toType == Byte.class || toType == Byte.TYPE) {
            return Byte.valueOf(value);
        }
        if (toType == Boolean.class || toType == Boolean.TYPE) {
            return Boolean.valueOf(value);
        }
        if (toType == Short.class || toType == Short.TYPE) {
            return Short.valueOf(value);
        }
        if (toType == Integer.class || toType == Integer.TYPE) {
            return Integer.valueOf(value);
        }
        if (toType == Long.class || toType == Long.TYPE) {
            return Long.valueOf(value);
        }
        if (toType == Float.class || toType == Float.TYPE) {
            return Float.valueOf(value);
        }
        if (toType == Double.class || toType == Double.TYPE) {
            return Double.valueOf(value);
        }
        return value;
    }

    static boolean classesEquivalent(Class<?> clazz, String canonicalName) {
        if (clazz.getCanonicalName().equals(canonicalName)) {
            return true;
        }
        if (classEquivalentMap.containsKey(clazz.getCanonicalName()) && classEquivalentMap.containsKey(canonicalName)) {
            return classEquivalentMap.get(clazz.getCanonicalName()) == classEquivalentMap.get(canonicalName);
        }
        return false;
    }

    static {
        classEquivalentMap.put(Byte.class.getCanonicalName(), Byte.class);
        classEquivalentMap.put(Byte.TYPE.getCanonicalName(), Byte.class);
        classEquivalentMap.put(Boolean.TYPE.getCanonicalName(), Boolean.class);
        classEquivalentMap.put(Boolean.class.getCanonicalName(), Boolean.class);
        classEquivalentMap.put(Short.TYPE.getCanonicalName(), Short.class);
        classEquivalentMap.put(Short.class.getCanonicalName(), Short.class);
        classEquivalentMap.put(Integer.TYPE.getCanonicalName(), Integer.class);
        classEquivalentMap.put(Integer.class.getCanonicalName(), Integer.class);
        classEquivalentMap.put(Long.TYPE.getCanonicalName(), Long.class);
        classEquivalentMap.put(Long.class.getCanonicalName(), Long.class);
        classEquivalentMap.put(Float.TYPE.getCanonicalName(), Float.class);
        classEquivalentMap.put(Float.class.getCanonicalName(), Float.class);
        classEquivalentMap.put(Double.TYPE.getCanonicalName(), Double.class);
        classEquivalentMap.put(Double.class.getCanonicalName(), Double.class);
    }
}

