/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.sessioncookie;

import java.security.GeneralSecurityException;
import javax.servlet.http.HttpSession;
import org.baswell.sessioncookie.SessionCookieDecodingException;
import org.baswell.sessioncookie.SessionCookieDecryptionException;
import org.baswell.sessioncookie.SessionCookieErrorHandler;
import org.baswell.sessioncookie.SessionCookieParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCookieDefaultErrorHandler
implements SessionCookieErrorHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void onSessionCookieSizeWarning(HttpSession session, int cookieSizeBytes) {
        this.log.warn(String.format("The session cookie for %s is %i bytes in size and might not be re=transmitted by the browser could not be decoded.", session.getId(), cookieSizeBytes));
    }

    @Override
    public void onCookieDecodeError(SessionCookieDecodingException exception) {
        this.log.warn(String.format("Received session cookie \"%s\" that could not be decoded.", exception.decryptedCookieValue), (Throwable)exception);
    }

    @Override
    public void onCookieDecryptError(SessionCookieDecryptionException exception) {
        this.log.warn(String.format("Received session cookie \"%s\" that could not be decrypted using algorithm %s.", exception.encryptedData, exception.algorithm), (Throwable)exception);
    }

    @Override
    public void onGeneralSecurityException(GeneralSecurityException exception, SessionCookieParameters parameters, boolean encrypting) {
        this.log.error(String.format("Received a general security exception using the SessionCookie parameters %s and cipher algorithm %s while %s.", parameters.getClass().toString(), parameters.getSymmetricEncryptionAlgorithm(), encrypting ? "encrypting" : "decrypting"), (Throwable)exception);
    }

    @Override
    public void onClassNotFoundFromSessionException(ClassNotFoundException exception) {
        this.log.error("Class not found exception from within session.", (Throwable)exception);
    }
}

