/*
 * Decompiled with CFR 0.152.
 */
package org.baswell.sessioncookie;

import java.security.GeneralSecurityException;
import javax.crypto.KeyGenerator;
import org.baswell.sessioncookie.SessionCookieParameters;

public class SessionCookieDefaultParameters
implements SessionCookieParameters {
    private int sessionTimeoutMinutes = 30;
    private int inactivityTimeoutSeconds = -1;
    private int maxInMemorySessions = -1;
    private boolean purgeSessionCacheWithBackgroundThread = false;
    private int minimumSecondsBetweenSessionCachePurges = 15;
    private volatile byte[] key;
    private String symmetricEncryptionAlgorithm = "AES";
    private String cookieDomain = DEFAULT_COOKIE_DOMAIN;
    private String cookieName = "org.baswell.sessioncookie";
    private int cookieSizeWarning = 4096;

    public void setSessionTimeoutMinutes(int sessionTimeoutMinutes) {
        this.sessionTimeoutMinutes = sessionTimeoutMinutes;
    }

    @Override
    public int getSessionTimeoutMinutes() {
        return this.sessionTimeoutMinutes;
    }

    public void setInactivityTimeoutSeconds(int inactivityTimeoutSeconds) {
        this.inactivityTimeoutSeconds = inactivityTimeoutSeconds;
    }

    @Override
    public int getInactivityTimeoutSeconds() {
        return this.inactivityTimeoutSeconds;
    }

    public void setMaxInMemorySessions(int maxInMemorySessions) {
        this.maxInMemorySessions = maxInMemorySessions;
    }

    @Override
    public int getMaxInMemorySessions() {
        return this.maxInMemorySessions;
    }

    public void setPurgeSessionCacheWithBackgroundThread(boolean purgeSessionCacheWithBackgroundThread) {
        this.purgeSessionCacheWithBackgroundThread = purgeSessionCacheWithBackgroundThread;
    }

    @Override
    public boolean getPurgeSessionCacheWithBackgroundThread() {
        return this.purgeSessionCacheWithBackgroundThread;
    }

    public void setMinimumSecondsBetweenSessionCachePurges(int minimumSecondsBetweenSessionCachePurges) {
        this.minimumSecondsBetweenSessionCachePurges = minimumSecondsBetweenSessionCachePurges;
    }

    @Override
    public int getMinimumSecondsBetweenSessionCachePurges() {
        return this.minimumSecondsBetweenSessionCachePurges;
    }

    public void setSymmetricEncryptionAlgorithm(String symmetricEncryptionAlgorithm) {
        this.symmetricEncryptionAlgorithm = symmetricEncryptionAlgorithm;
    }

    @Override
    public String getSymmetricEncryptionAlgorithm() {
        return this.symmetricEncryptionAlgorithm;
    }

    public void setSymmetricEncryptionKey(byte[] key) {
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSymmetricEncryptionKey() throws GeneralSecurityException {
        if (this.key == null) {
            SessionCookieDefaultParameters sessionCookieDefaultParameters = this;
            synchronized (sessionCookieDefaultParameters) {
                if (this.key == null) {
                    KeyGenerator generator = KeyGenerator.getInstance(this.getSymmetricEncryptionAlgorithm());
                    generator.init(256);
                    this.key = generator.generateKey().getEncoded();
                }
            }
        }
        return this.key;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    @Override
    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieSizeWarning(int cookieSizeWarning) {
        this.cookieSizeWarning = cookieSizeWarning;
    }

    @Override
    public int getCookieSizeWarning() {
        return this.cookieSizeWarning;
    }
}

