/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.common.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import org.batoo.common.collections.AbstractListListener;
import org.batoo.common.collections.FastLinkedListIterator;

public class FastLinkedList<E>
extends AbstractSequentialList<E>
implements List<E>,
Deque<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    final transient AbstractListListener<E> listener;
    transient int size = 0;
    transient FastLinkedListNode<E> first;
    transient FastLinkedListNode<E> last;

    public FastLinkedList() {
        this((AbstractListListener)null);
    }

    public FastLinkedList(AbstractListListener<E> listener) {
        this.listener = listener;
    }

    public FastLinkedList(AbstractListListener<E> listener, Collection<? extends E> c) {
        this.addAll(c);
        this.listener = listener;
    }

    public FastLinkedList(Collection<? extends E> c) {
        this(null, c);
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        this.linkLast(e);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.checkPositionIndex(index);
        if (index == this.size) {
            this.linkLast(element);
        } else {
            this.linkBefore(element, this.node(index));
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        FastLinkedListNode<Object> pred;
        FastLinkedListNode<E> succ;
        this.checkPositionIndex(index);
        Object[] a = c.toArray();
        int numNew = a.length;
        if (numNew == 0) {
            return false;
        }
        if (index == this.size) {
            succ = null;
            pred = this.last;
        } else {
            succ = this.node(index);
            pred = succ.prev;
        }
        Object[] arr$ = a;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object o;
            Object e = o = arr$[i$];
            FastLinkedListNode<Object> newNode = new FastLinkedListNode<Object>(pred, e, null);
            if (pred == null) {
                this.first = newNode;
            } else {
                pred.next = newNode;
            }
            pred = newNode;
        }
        if (succ == null) {
            this.last = pred;
        } else {
            pred.next = succ;
            succ.prev = pred;
        }
        this.size += numNew;
        ++this.modCount;
        return true;
    }

    @Override
    public void addFirst(E e) {
        this.linkFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.linkLast(e);
    }

    private void checkElementIndex(int index) {
        if (!this.isElementIndex(index)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private void checkPositionIndex(int index) {
        if (!this.isPositionIndex(index)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    @Override
    public void clear() {
        this.last = null;
        this.first = null;
        this.size = 0;
        ++this.modCount;
    }

    public Object clone() {
        FastLinkedList clone = this.superClone();
        clone.last = null;
        clone.first = null;
        clone.size = 0;
        clone.modCount = 0;
        FastLinkedListNode<E> x = this.first;
        while (x != null) {
            clone.add(x.item);
            x = x.next;
        }
        return clone;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public FastLinkedListIterator<E> descendingIterator() {
        return new FastLinkedListIterator(this, this.size, false);
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E get(int index) {
        this.checkElementIndex(index);
        return this.node((int)index).item;
    }

    @Override
    public E getFirst() {
        FastLinkedListNode<E> f = this.first;
        if (f == null) {
            throw new NoSuchElementException();
        }
        return f.item;
    }

    @Override
    public E getLast() {
        FastLinkedListNode<E> l = this.last;
        if (l == null) {
            throw new NoSuchElementException();
        }
        return l.item;
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            FastLinkedListNode<E> x = this.first;
            while (x != null) {
                if (x.item == null) {
                    return index;
                }
                ++index;
                x = x.next;
            }
        } else {
            FastLinkedListNode<E> x = this.first;
            while (x != null) {
                if (o.equals(x.item)) {
                    return index;
                }
                ++index;
                x = x.next;
            }
        }
        return -1;
    }

    private boolean isElementIndex(int index) {
        return index >= 0 && index < this.size;
    }

    private boolean isPositionIndex(int index) {
        return index >= 0 && index <= this.size;
    }

    @Override
    public FastLinkedListIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = this.size;
        if (o == null) {
            FastLinkedListNode<E> x = this.last;
            while (x != null) {
                --index;
                if (x.item == null) {
                    return index;
                }
                x = x.prev;
            }
        } else {
            FastLinkedListNode<E> x = this.last;
            while (x != null) {
                --index;
                if (o.equals(x.item)) {
                    return index;
                }
                x = x.prev;
            }
        }
        return -1;
    }

    void linkBefore(E e, FastLinkedListNode<E> succ) {
        FastLinkedListNode pred = succ.prev;
        FastLinkedListNode newNode = new FastLinkedListNode(pred, e, succ);
        succ.prev = newNode;
        if (pred == null) {
            this.first = newNode;
        } else {
            pred.next = newNode;
        }
        ++this.size;
        ++this.modCount;
        AbstractListListener<E> listener = this.listener;
        if (listener != null) {
            listener.elementAdded(e);
        }
    }

    private void linkFirst(E e) {
        FastLinkedListNode<E> f = this.first;
        FastLinkedListNode<E> newNode = new FastLinkedListNode<E>(null, e, f);
        this.first = newNode;
        if (f == null) {
            this.last = newNode;
        } else {
            f.prev = newNode;
        }
        ++this.size;
        ++this.modCount;
        AbstractListListener<E> listener = this.listener;
        if (listener != null) {
            listener.elementAdded(e);
        }
    }

    void linkLast(E e) {
        FastLinkedListNode<E> l = this.last;
        FastLinkedListNode<E> newNode = new FastLinkedListNode<E>(l, e, null);
        this.last = newNode;
        if (l == null) {
            this.first = newNode;
        } else {
            l.next = newNode;
        }
        ++this.size;
        ++this.modCount;
        AbstractListListener<E> listener = this.listener;
        if (listener != null) {
            listener.elementAdded(e);
        }
    }

    @Override
    public FastLinkedListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public FastLinkedListIterator<E> listIterator(int index) {
        this.checkPositionIndex(index);
        return new FastLinkedListIterator(this, index, true);
    }

    FastLinkedListNode<E> node(int index) {
        if (index < this.size >> 1) {
            FastLinkedListNode<E> x = this.first;
            for (int i = 0; i < index; ++i) {
                x = x.next;
            }
            return x;
        }
        FastLinkedListNode<E> x = this.last;
        for (int i = this.size - 1; i > index; --i) {
            x = x.prev;
        }
        return x;
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    @Override
    public E peek() {
        FastLinkedListNode<E> f = this.first;
        return f == null ? null : (E)f.item;
    }

    @Override
    public E peekFirst() {
        FastLinkedListNode<E> f = this.first;
        return f == null ? null : (E)f.item;
    }

    @Override
    public E peekLast() {
        FastLinkedListNode<E> l = this.last;
        return l == null ? null : (E)l.item;
    }

    @Override
    public E poll() {
        FastLinkedListNode<E> f = this.first;
        return f == null ? null : (E)this.unlinkFirst(f);
    }

    @Override
    public E pollFirst() {
        FastLinkedListNode<E> f = this.first;
        return f == null ? null : (E)this.unlinkFirst(f);
    }

    @Override
    public E pollLast() {
        FastLinkedListNode<E> l = this.last;
        return l == null ? null : (E)this.unlinkLast(l);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            this.linkLast(s.readObject());
        }
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E remove(int index) {
        this.checkElementIndex(index);
        return this.unlink(this.node(index));
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            FastLinkedListNode<E> x = this.first;
            while (x != null) {
                if (x.item == null) {
                    this.unlink(x);
                    return true;
                }
                x = x.next;
            }
        } else {
            FastLinkedListNode<E> x = this.first;
            while (x != null) {
                if (o.equals(x.item)) {
                    this.unlink(x);
                    return true;
                }
                x = x.next;
            }
        }
        return false;
    }

    @Override
    public E removeFirst() {
        FastLinkedListNode<E> f = this.first;
        if (f == null) {
            throw new NoSuchElementException();
        }
        return this.unlinkFirst(f);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o);
    }

    @Override
    public E removeLast() {
        FastLinkedListNode<E> l = this.last;
        if (l == null) {
            throw new NoSuchElementException();
        }
        return this.unlinkLast(l);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (o == null) {
            FastLinkedListNode<E> x = this.last;
            while (x != null) {
                if (x.item == null) {
                    this.unlink(x);
                    return true;
                }
                x = x.prev;
            }
        } else {
            FastLinkedListNode<E> x = this.last;
            while (x != null) {
                if (o.equals(x.item)) {
                    this.unlink(x);
                    return true;
                }
                x = x.prev;
            }
        }
        return false;
    }

    @Override
    public E set(int index, E element) {
        this.checkElementIndex(index);
        FastLinkedListNode<E> x = this.node(index);
        Object oldVal = x.item;
        x.item = element;
        return oldVal;
    }

    @Override
    public int size() {
        return this.size;
    }

    private FastLinkedList<E> superClone() {
        try {
            return (FastLinkedList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        FastLinkedListNode<E> x = this.first;
        while (x != null) {
            result[i++] = x.item;
            x = x.next;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int i = 0;
        T[] result = a;
        FastLinkedListNode<E> x = this.first;
        while (x != null) {
            result[i++] = x.item;
            x = x.next;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    E unlink(FastLinkedListNode<E> x) {
        Object element = x.item;
        FastLinkedListNode next = x.next;
        FastLinkedListNode prev = x.prev;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
            x.prev = null;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
            x.next = null;
        }
        x.item = null;
        --this.size;
        ++this.modCount;
        AbstractListListener listener = this.listener;
        if (listener != null) {
            listener.elementRemoved(element);
        }
        return element;
    }

    private E unlinkFirst(FastLinkedListNode<E> f) {
        Object element = f.item;
        FastLinkedListNode next = f.next;
        f.item = null;
        f.next = null;
        this.first = next;
        if (next == null) {
            this.last = null;
        } else {
            next.prev = null;
        }
        --this.size;
        ++this.modCount;
        AbstractListListener listener = this.listener;
        if (listener != null) {
            listener.elementRemoved(element);
        }
        return element;
    }

    private E unlinkLast(FastLinkedListNode<E> l) {
        Object element = l.item;
        FastLinkedListNode prev = l.prev;
        l.item = null;
        l.prev = null;
        this.last = prev;
        if (prev == null) {
            this.first = null;
        } else {
            prev.next = null;
        }
        --this.size;
        ++this.modCount;
        AbstractListListener listener = this.listener;
        if (listener != null) {
            listener.elementRemoved(element);
        }
        return element;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        FastLinkedListNode<E> x = this.first;
        while (x != null) {
            s.writeObject(x.item);
            x = x.next;
        }
    }

    static class FastLinkedListNode<E> {
        E item;
        FastLinkedListNode<E> next;
        FastLinkedListNode<E> prev;

        FastLinkedListNode(FastLinkedListNode<E> prev, E element, FastLinkedListNode<E> next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }
    }
}

