/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public class BatooUtils {
    private static final UUID uuid = UUID.randomUUID();

    public static String acronym(String name) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isUpperCase(name.charAt(i))) continue;
            builder.append(name.charAt(i));
        }
        if (builder.length() == 0) {
            builder.append(name.charAt(0));
        }
        return builder.toString();
    }

    public static <E> void addAll(Collection<? extends E> source, Collection<E> target) {
        if (source instanceof List) {
            List list = (List)source;
            for (int i = 0; i < list.size(); ++i) {
                target.add((E)list.get(i));
            }
        } else {
            target.addAll(source);
        }
    }

    public static String indent(String str) {
        if (StringUtils.isBlank((String)str)) {
            return "";
        }
        return "\t" + str.replaceAll("\n", "\n\t");
    }

    public static Map<String, Object> loadRuntimeProperties() {
        try {
            InputStream inRuntimeProperties = BatooUtils.class.getClassLoader().getResourceAsStream("batoo-jpa-runtime.properties");
            if (inRuntimeProperties != null) {
                Properties runtimeProperties = new Properties();
                runtimeProperties.load(inRuntimeProperties);
                inRuntimeProperties.close();
                if (runtimeProperties != null) {
                    HashMap propertiesMap = Maps.newHashMap();
                    for (Map.Entry<Object, Object> entry : runtimeProperties.entrySet()) {
                        propertiesMap.put((String)entry.getKey(), entry.getValue());
                    }
                    return propertiesMap;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Maps.newHashMap();
    }

    public static String lower(String string) {
        return string != null ? string.toLowerCase() : null;
    }

    public static <X> List<X> subtract(Collection<X> a, Collection<X> b) {
        ArrayList list = Lists.newArrayList(a);
        for (X element : b) {
            list.remove(element);
        }
        return list;
    }

    public static <X, Y> Map<X, Y> subtract(Map<X, Y> a, Map<X, Y> b) {
        HashMap map = Maps.newHashMap();
        for (X key : a.keySet()) {
            if (b.containsKey(key) && b.get(key).equals(a.get(key))) continue;
            map.put(key, b.get(key));
        }
        return map;
    }

    public static String tree(String str) {
        if (StringUtils.isBlank((String)str)) {
            return "";
        }
        return "|-->" + str.replaceAll("\n", "\n|   ");
    }

    public static String upper(String string) {
        return string != null ? string.toUpperCase() : null;
    }

    public static void gaBoot(final Map<String, Object> prop) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BatooUtils.ga(prop);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    private static int ga(Map<String, Object> prop) throws Exception {
        String state = prop.get("batoojpa.state") != null ? "" + prop.get("batoojpa.state") : "boot";
        String version = "&av=" + prop.get("batoojpa.version");
        String lang = "&ul=" + Locale.getDefault().getLanguage();
        String z = "&z=" + new Random().nextInt();
        String ua = "User-Agent: Java/" + prop.get("java.version") + " (" + prop.get("os.name") + " )" + "batoo/" + prop.get("batoojpa.build");
        String payload = "v=1&tid=UA-41772675-2&cid=" + uuid + "&t=appview&cd=" + state + "&an=batoo-jpa" + version + lang + z;
        String url = "http://www.google-analytics.com/collect?" + payload;
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestProperty("User-Agent", ua);
        return con.getResponseCode();
    }
}

