/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.batoo.common.BatooException;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.manager.JtaEntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.manager.PersistenceUtilImpl;
import org.batoo.jpa.parser.AndroidPersistenceParserImpl;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.PersistenceParserImpl;

public class BatooPersistenceProvider
implements PersistenceProvider {
    private static final BLogger LOG = BLoggerFactory.getLogger(BatooPersistenceProvider.class);
    private static final String PROVIDER_NAME = "org.batoo.jpa.core.BatooPersistenceProvider";
    private final ProviderUtil providerUtil = new PersistenceUtilImpl();

    public EntityManagerFactoryImpl createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        try {
            PersistenceParserImpl parser = new PersistenceParserImpl(info, (Map<String, Object>)map);
            return parser.getJtaDataSource() != null ? new JtaEntityManagerFactoryImpl(info.getPersistenceUnitName(), parser) : new EntityManagerFactoryImpl(info.getPersistenceUnitName(), parser);
        }
        catch (PersistenceException e) {
            throw e;
        }
        catch (MappingException e) {
            throw e;
        }
        catch (BatooException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PersistenceException("Unable to build the entity manager factory for persistence unit: " + info.getPersistenceUnitName(), (Throwable)e);
        }
    }

    public EntityManagerFactory createEntityManagerFactory(String emName, Map map) {
        String provider;
        try {
            PersistenceParserImpl parser = new PersistenceParserImpl(emName, (Map<String, Object>)map);
            provider = parser.getProvider();
            if (provider == null || PROVIDER_NAME.equals(provider)) {
                return new EntityManagerFactoryImpl(emName, parser);
            }
        }
        catch (Exception e) {
            if (e instanceof PersistenceException || e instanceof MappingException || e instanceof BatooException) {
                throw (RuntimeException)e;
            }
            throw new PersistenceException("Unable to build entity manager factory for persistence unit " + emName, (Throwable)e);
        }
        try {
            Class<?> providerClass = Class.forName(provider);
            PersistenceProvider persistenceProvider = (PersistenceProvider)providerClass.newInstance();
            return persistenceProvider.createEntityManagerFactory(emName, map);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException("Persistence provider " + provider + " is not found for persistence unit " + emName);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public EntityManagerFactory createEntityManagerFactory(String emName, Map<String, String> map, String[] classes) {
        try {
            AndroidPersistenceParserImpl parser = new AndroidPersistenceParserImpl(map, classes);
            return new EntityManagerFactoryImpl(emName, parser);
        }
        catch (Exception e) {
            if (e instanceof PersistenceException || e instanceof MappingException || e instanceof BatooException) {
                throw (RuntimeException)e;
            }
            LOG.info(e, "Unable to build persistence unit: " + emName);
            return null;
        }
    }

    public ProviderUtil getProviderUtil() {
        return this.providerUtil;
    }
}

