/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.path.AbstractPath;
import org.batoo.jpa.core.impl.criteria.path.BasicPath;

public abstract class AbstractTypeExpression<T>
extends AbstractExpression<Class<? extends T>> {
    private final AbstractPath<?> path;
    private String alias;

    public AbstractTypeExpression(AbstractPath<T> path) {
        super(path.getJavaType().getClass());
        this.path = path;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return "type(" + this.getPath().generateJpqlRestriction(query) + ")";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (this.getAlias() != null) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        String innerExpression;
        this.alias = query.getAlias(this);
        String string = innerExpression = this.path instanceof BasicPath ? this.path.getSqlRestrictionFragments(query)[0] : this.getSqlRestrictionFragments(query)[0];
        if (selected) {
            return innerExpression + " AS " + this.alias;
        }
        return innerExpression;
    }

    public AbstractPath<?> getPath() {
        return this.path;
    }

    protected Object handle(ResultSet row) throws SQLException {
        return row.getObject(this.alias);
    }
}

