/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.SubqueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.CollectionExpression;
import org.batoo.jpa.core.impl.criteria.join.AbstractPluralJoin;
import org.batoo.jpa.core.impl.criteria.join.Joinable;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;

public class MemberOfExpression<C extends Collection<E>, E>
extends AbstractExpression<Boolean> {
    private final boolean not;
    private final CollectionExpression<?, ?> values;
    private final AbstractExpression<?> value;

    public MemberOfExpression(boolean not, Expression<E> value, Expression<C> values) {
        super(Boolean.class);
        this.not = not;
        this.values = (CollectionExpression)values;
        this.value = (AbstractExpression)value;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return this.value.generateJpqlRestriction(query) + (this.not ? " not member of " : " member of ") + this.values.generateJpqlRestriction(query);
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        throw new IllegalArgumentException("Collection expressions cannot be selected");
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        throw new IllegalArgumentException("Collection expressions cannot be selected");
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        CriteriaBuilderImpl cb = query.getMetamodel().getEntityManagerFactory().getCriteriaBuilder();
        Joinable rp = this.values.getParentPath().getRootPath();
        SubqueryImpl<Object> s = query.subquery(Object.class);
        Root r = s.from(rp.getEntity());
        PluralAttributeImpl attribute = (PluralAttributeImpl)this.values.getMapping().getAttribute();
        AbstractPluralJoin j = (AbstractPluralJoin)r.join(attribute.getName());
        if (attribute.getElementType() instanceof EntityTypeImpl) {
            EntityTypeImpl entity = (EntityTypeImpl)attribute.getElementType();
            String idName = entity.getIdMapping().getAttribute().getName();
            s.select((Expression<Object>)j.get(idName));
        } else {
            s.select(j);
        }
        s.where((Expression<Boolean>)cb.equal((Expression)r, (AbstractExpression)((Object)rp)));
        return new String[]{this.value.getSqlRestrictionFragments(query)[0] + " IN " + s.getSqlRestrictionFragments(query)[0]};
    }

    @Override
    public Boolean handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return null;
    }
}

