/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.path.BasicPath;
import org.batoo.jpa.core.impl.manager.SessionImpl;

public class NegationExpression<N extends Number>
extends AbstractExpression<N> {
    private final AbstractExpression<N> inner;
    private String alias;

    public NegationExpression(Expression<N> inner) {
        super(inner.getJavaType());
        this.inner = (AbstractExpression)inner;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        return "-(" + this.inner.generateJpqlRestriction(query) + ")";
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        StringBuilder builder = new StringBuilder("-");
        if (!(this.inner instanceof BasicPath)) {
            builder.append("(").append(this.inner.generateJpqlRestriction(query)).append(")");
        } else {
            builder.append(this.inner.generateJpqlRestriction(query));
        }
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            builder.append(" as ").append(this.getAlias());
        }
        return builder.toString();
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (this.inner instanceof BasicPath) {
            if (selected) {
                return "-" + this.inner.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
            }
            return "-" + this.inner.getSqlRestrictionFragments(query)[0];
        }
        if (selected) {
            return "-" + this.inner.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return "-" + this.inner.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        return new String[]{"-(" + this.inner.getSqlRestrictionFragments(query)[0] + ")"};
    }

    @Override
    public N handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        Number value = (Number)row.getObject(this.alias);
        return (N)(this.getConverter() != null ? this.getConverter().convert(value) : value);
    }
}

