/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.jdbc.NumericFunctionType;

public class NumericFunctionExpression<N extends Number>
extends AbstractExpression<N> {
    private final NumericFunctionType type;
    private final AbstractExpression<?> x;
    private final AbstractExpression<Integer> y;
    private String alias;

    public NumericFunctionExpression(NumericFunctionType type, Expression<?> x, Expression<Integer> y) {
        super(Number.class.isAssignableFrom(x.getJavaType()) ? x.getJavaType() : Integer.class);
        this.type = type;
        this.x = (AbstractExpression)x;
        this.y = (AbstractExpression)y;
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        String xExpr = this.x.generateJpqlRestriction(query);
        String yExpr = this.y != null ? this.y.generateJpqlRestriction(query) : null;
        return MessageFormat.format(this.type.getJpqlFragment(), xExpr, yExpr);
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        if (StringUtils.isNotBlank((String)this.getAlias())) {
            return this.generateJpqlRestriction(query) + " as " + this.getAlias();
        }
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    @Override
    public String[] getSqlRestrictionFragments(BaseQueryImpl<?> query) {
        String xExpr = this.x.getSqlRestrictionFragments(query)[0];
        String yExpr = this.y != null ? this.y.getSqlRestrictionFragments(query)[0] : null;
        return new String[]{MessageFormat.format(query.getJdbcAdaptor().getNumericFunctionTemplate(this.type), xExpr, yExpr)};
    }

    @Override
    public N handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        return (N)((Number)row.getObject(this.alias));
    }
}

