/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.expression;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.criteria.ParameterExpression;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.QueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractParameterExpressionImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.TypeImpl;

public class ParameterExpressionImpl<T>
extends AbstractParameterExpressionImpl<T>
implements ParameterExpression<T> {
    private Integer position;
    private String alias;
    private boolean named = false;

    public ParameterExpressionImpl(BaseQueryImpl<?> q, TypeImpl<T> type, Class<T> paramClass, int position) {
        super(type, paramClass);
        this.position = position;
        this.alias(Integer.toString(position));
        q.getAlias(this);
    }

    public ParameterExpressionImpl(TypeImpl<T> type, Class<T> paramClass, String name) {
        super(type, paramClass);
        if (StringUtils.isNotBlank((String)name)) {
            this.alias(name);
        }
    }

    @Override
    protected void ensureAlias(BaseQueryImpl<?> query) {
        if (this.position == null && !StringUtils.isBlank((String)this.getAlias())) {
            this.named = true;
        }
        if (this.position == null) {
            this.position = query.getAlias(this);
            if (StringUtils.isBlank((String)this.getAlias())) {
                this.alias("param" + this.position);
            }
        }
    }

    @Override
    public String generateJpqlRestriction(BaseQueryImpl<?> query) {
        this.ensureAlias(query);
        try {
            int positionNo = Integer.parseInt(this.getAlias());
            return "?" + positionNo;
        }
        catch (Exception exception) {
            return ":" + this.getAlias();
        }
    }

    @Override
    public String generateJpqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        return this.generateJpqlRestriction(query);
    }

    @Override
    public String generateSqlSelect(AbstractCriteriaQueryImpl<?> query, boolean selected) {
        this.ensureAlias(query);
        this.alias = query.getAlias(this);
        if (selected) {
            return this.getSqlRestrictionFragments(query)[0] + " AS " + this.alias;
        }
        return this.getSqlRestrictionFragments(query)[0];
    }

    public String getName() {
        return this.named ? this.getAlias() : null;
    }

    public Class<T> getParameterType() {
        return this.getJavaType();
    }

    public Integer getPosition() {
        return this.named ? null : this.position;
    }

    @Override
    public T handle(QueryImpl<?> query, SessionImpl session, ResultSet row) throws SQLException {
        Object value = query.getParameterValue(this);
        return (T)(this.getConverter() != null ? this.getConverter().convert(value) : value);
    }

    @Override
    public void setParameter(MetamodelImpl metamodel, Connection connections, Object[] parameters, MutableInt sqlIndex, Object value) {
        super.setParameter(metamodel, connections, parameters, sqlIndex, value);
    }

    public String toString() {
        return "ParameterExpressionImpl [position=" + this.position + ", name=" + this.getName() + "]";
    }
}

