/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.criteria.path;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.persistence.criteria.Path;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.batoo.jpa.core.impl.criteria.BaseQueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.AbstractExpression;
import org.batoo.jpa.core.impl.criteria.expression.CollectionExpression;
import org.batoo.jpa.core.impl.criteria.expression.MapExpression;
import org.batoo.jpa.core.impl.criteria.join.FetchParentImpl;
import org.batoo.jpa.core.impl.criteria.path.AbstractPath;
import org.batoo.jpa.core.impl.criteria.path.BasicPath;
import org.batoo.jpa.core.impl.criteria.path.EmbeddedAttributePath;
import org.batoo.jpa.core.impl.criteria.path.EntityPath;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.MapAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.PluralAttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.SingularAttributeImpl;
import org.batoo.jpa.core.impl.model.mapping.AbstractMapping;
import org.batoo.jpa.core.impl.model.mapping.BasicMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.SingularAssociationMappingImpl;
import org.batoo.jpa.jdbc.AbstractColumn;

public abstract class ParentPath<Z, X>
extends AbstractPath<X>
implements Path<X> {
    final Map<String, AbstractExpression<?>> children = Maps.newHashMap();

    public ParentPath(ParentPath<?, Z> parent, Class<X> javaType) {
        super(parent, javaType);
    }

    public final <K, V, M extends Map<K, V>> MapExpression<M, K, V> get(MapAttribute<? super X, K, V> map) {
        return new MapExpression(this.getMapping(map.getName()));
    }

    public final <E, C extends Collection<E>> CollectionExpression<C, E> get(PluralAttribute<? super X, C, E> collection) {
        return new CollectionExpression(this, this.getMapping(collection.getName()));
    }

    @Override
    public final <Y> AbstractPath<Y> get(SingularAttribute<? super X, Y> attribute) {
        AbstractMapping mapping = this.getMapping(attribute.getName());
        switch (attribute.getPersistentAttributeType()) {
            case EMBEDDED: {
                return new EmbeddedAttributePath(this, (EmbeddedMappingImpl)mapping);
            }
            case BASIC: {
                return new BasicPath(this, (BasicMappingImpl)mapping);
            }
        }
        return new EntityPath(this, (SingularAssociationMappingImpl)mapping, (EntityTypeImpl)attribute.getType());
    }

    @Override
    public final <Y> AbstractPath<Y> get(String name) {
        AbstractExpression<?> path = this.children.get(name);
        if (path != null) {
            return (AbstractPath)path;
        }
        AbstractMapping mapping = this.getMapping(name);
        AttributeImpl attribute = mapping.getAttribute();
        if (attribute.isCollection()) {
            throw new IllegalArgumentException("Cannot deference a plural attribute as path: " + name);
        }
        return this.get((SingularAttribute)attribute);
    }

    public String getColumnAlias(BaseQueryImpl<?> query, AbstractColumn column) {
        return null;
    }

    public <Y, C extends Collection<Y>> AbstractExpression<Y> getExpression(String attributeName) {
        AttributeImpl<X, C> attribute = this.getMapping(attributeName).getAttribute();
        if (!attribute.isCollection()) {
            return this.get((SingularAttributeImpl)attribute);
        }
        if (((PluralAttributeImpl)attribute).getCollectionType() == PluralAttribute.CollectionType.MAP) {
            return this.get((MapAttributeImpl)attribute);
        }
        return this.get((PluralAttribute)attribute);
    }

    public abstract FetchParentImpl<?, X> getFetchRoot();

    protected abstract <C, Y> AbstractMapping<? super X, C, Y> getMapping(String var1);
}

