/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.deployment;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.persistence.metamodel.ManagedType;
import org.batoo.common.BatooException;
import org.batoo.common.log.BLogger;
import org.batoo.common.util.IncrementalNamingThreadFactory;
import org.batoo.jpa.core.impl.deployment.DeploymentUnitTask;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.TypeImpl;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;

public abstract class DeploymentManager<X> {
    private final BLogger log;
    private final MetamodelImpl metamodel;
    private final List<ManagedType<?>> types = Lists.newArrayList();
    private final Collection<NamedQueryMetadata> namedQueries = Lists.newArrayList();
    private final Set<TypeImpl<?>> performed = Collections.synchronizedSet(Sets.newHashSet());
    private final ThreadPoolExecutor executer;
    private final Context context;

    public DeploymentManager(BLogger log, String name, MetamodelImpl metamodel, Context context) {
        this.log = log;
        this.metamodel = metamodel;
        this.context = context;
        switch (context) {
            case MANAGED_TYPES: {
                this.types.addAll(this.metamodel.getManagedTypes());
                break;
            }
            case IDENTIFIABLE_TYPES: {
                this.types.addAll(this.metamodel.getIdentifiables());
                break;
            }
            case ENTITIES: {
                this.types.addAll(this.metamodel.getEntities());
                break;
            }
            case NAMED_QUERIES: {
                this.namedQueries.addAll(this.metamodel.getNamedQueries());
            }
        }
        int nThreads = Runtime.getRuntime().availableProcessors() * 2;
        this.executer = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue(), new IncrementalNamingThreadFactory(name)){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
                return new DeploymentUnitFuture((DeploymentUnitTask)callable);
            }
        };
        this.log.debug("Number of threads is {0}", nThreads);
    }

    public MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    protected void handleException(Throwable t) throws BatooException {
        if (t instanceof BatooException) {
            throw (BatooException)t;
        }
        if (t.getCause() != null) {
            throw new BatooException("Unknown error occurred during deployment", t.getCause());
        }
        this.handleException(t.getCause());
    }

    public boolean hasPerformed(TypeImpl<?> type) {
        if (type == null) {
            return true;
        }
        if (!this.types.contains(type)) {
            return true;
        }
        return this.performed.contains(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void perform() throws BatooException {
        long start = System.currentTimeMillis();
        ArrayList futures = Lists.newArrayList();
        if (this.context == Context.NAMED_QUERIES) {
            for (NamedQueryMetadata query : this.namedQueries) {
                futures.add(this.executer.submit(new DeploymentUnitTask(this, query)));
            }
        } else {
            ArrayList unSortedTasks = Lists.newArrayList((Iterable)Lists.transform(this.types, (Function)new Function<ManagedType<?>, DeploymentUnitTask>(){

                public DeploymentUnitTask apply(ManagedType<?> type) {
                    return new DeploymentUnitTask(DeploymentManager.this, type);
                }
            }));
            ArrayList sortedTasks = Lists.newArrayList();
            block6: while (unSortedTasks.size() > 0) {
                Iterator i = unSortedTasks.iterator();
                while (i.hasNext()) {
                    DeploymentUnitTask task = (DeploymentUnitTask)i.next();
                    boolean hasDependency = false;
                    for (DeploymentUnitTask other : unSortedTasks) {
                        if (task.compareTo(other) <= 0) continue;
                        hasDependency = true;
                        break;
                    }
                    if (hasDependency) continue;
                    i.remove();
                    sortedTasks.add(task);
                    continue block6;
                }
            }
            for (DeploymentUnitTask task : sortedTasks) {
                futures.add(this.executer.submit(task));
            }
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception t) {
            this.handleException(t);
        }
        finally {
            this.executer.shutdownNow();
        }
        this.log.debug("Deployment pass took {0} msecs", System.currentTimeMillis() - start);
    }

    public abstract Void perform(X var1) throws BatooException;

    public void performed(X type) {
        if (!(type instanceof NamedQueryMetadata)) {
            this.performed.add((TypeImpl)type);
        }
    }

    private static class DeploymentUnitFuture
    extends FutureTask<Void>
    implements Comparable<DeploymentUnitFuture> {
        private final DeploymentUnitTask task;

        public DeploymentUnitFuture(DeploymentUnitTask task) {
            super(task);
            this.task = task;
        }

        @Override
        public int compareTo(DeploymentUnitFuture o) {
            return this.task.compareTo(o.task);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeploymentUnitFuture other = (DeploymentUnitFuture)obj;
            return !(this.task == null ? other.task != null : !this.task.equals(other.task));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.task == null ? 0 : this.task.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "DeploymentUnitFuture [task=" + this.task + "]";
        }
    }

    protected static enum Context {
        MANAGED_TYPES,
        IDENTIFIABLE_TYPES,
        ENTITIES,
        NAMED_QUERIES;

    }
}

