/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.InheritanceType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.FetchParent;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.batoo.common.reflect.AbstractAccessor;
import org.batoo.common.reflect.ConstructorAccessor;
import org.batoo.common.reflect.ReflectHelper;
import org.batoo.common.util.BatooUtils;
import org.batoo.common.util.FinalWrapper;
import org.batoo.common.util.Pair;
import org.batoo.jpa.annotations.FetchStrategyType;
import org.batoo.jpa.core.impl.criteria.AbstractCriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaBuilderImpl;
import org.batoo.jpa.core.impl.criteria.CriteriaQueryImpl;
import org.batoo.jpa.core.impl.criteria.expression.PredicateImpl;
import org.batoo.jpa.core.impl.instance.EnhancedInstance;
import org.batoo.jpa.core.impl.instance.Enhancer;
import org.batoo.jpa.core.impl.instance.ManagedId;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.instance.Status;
import org.batoo.jpa.core.impl.manager.EntityManagerFactoryImpl;
import org.batoo.jpa.core.impl.manager.EntityManagerImpl;
import org.batoo.jpa.core.impl.manager.SessionImpl;
import org.batoo.jpa.core.impl.model.IdentifiableTypeImpl;
import org.batoo.jpa.core.impl.model.MetamodelImpl;
import org.batoo.jpa.core.impl.model.TypeImpl;
import org.batoo.jpa.core.impl.model.attribute.AssociatedSingularAttribute;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.attribute.EmbeddedAttribute;
import org.batoo.jpa.core.impl.model.mapping.AbstractMapping;
import org.batoo.jpa.core.impl.model.mapping.AssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.BasicMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.EntityMapping;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;
import org.batoo.jpa.core.impl.model.mapping.PluralAssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.PluralMappingEx;
import org.batoo.jpa.core.impl.model.mapping.SingularAssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.SingularMappingEx;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.AbstractTable;
import org.batoo.jpa.jdbc.BasicColumn;
import org.batoo.jpa.jdbc.DiscriminatorColumn;
import org.batoo.jpa.jdbc.EntityTable;
import org.batoo.jpa.jdbc.IdType;
import org.batoo.jpa.jdbc.JoinColumn;
import org.batoo.jpa.jdbc.SecondaryTable;
import org.batoo.jpa.jdbc.mapping.Mapping;
import org.batoo.jpa.jdbc.mapping.MappingType;
import org.batoo.jpa.jdbc.mapping.SingularMapping;
import org.batoo.jpa.jdbc.model.EntityTypeDescriptor;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.AssociationMetadata;
import org.batoo.jpa.parser.metadata.AttributeOverrideMetadata;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;
import org.batoo.jpa.parser.metadata.IndexMetadata;
import org.batoo.jpa.parser.metadata.SecondaryTableMetadata;
import org.batoo.jpa.parser.metadata.type.EntityMetadata;

public class EntityTypeImpl<X>
extends IdentifiableTypeImpl<X>
implements EntityType<X>,
EntityTypeDescriptor {
    private final EntityMetadata metadata;
    private final String name;
    private EntityTable primaryTable;
    private final Map<String, EntityTable> tableMap = Maps.newHashMap();
    private FinalWrapper<EntityTable[]> tables;
    private FinalWrapper<EntityTable[]> updateTables;
    private FinalWrapper<EntityTable[]> allTables;
    private final HashMap<String, AssociatedSingularAttribute<? super X, ?>> idMap = Maps.newHashMap();
    private final ConstructorAccessor constructor;
    private CriteriaQueryImpl<X> selectCriteria;
    private CriteriaQueryImpl<X> refreshCriteria;
    private int dependencyCount;
    private boolean canBatchRemoves;
    private final HashMap<EntityTypeImpl<?>, AssociationMappingImpl<?, ?, ?>[]> dependencyMap = Maps.newHashMap();
    private FinalWrapper<BasicMappingImpl<?, ?>[]> basicMappingImpls;
    private FinalWrapper<AbstractMapping<?, ?, ?>[]> singularMappings;
    private FinalWrapper<PluralMappingEx<?, ?, ?>[]> mappingsPluralSorted;
    private FinalWrapper<PluralMappingEx<?, ?, ?>[]> mappingsPlural;
    private FinalWrapper<JoinedMapping<?, ?, ?>[]> mappingsJoined;
    private FinalWrapper<AssociationMappingImpl<?, ?, ?>[]> associations;
    private FinalWrapper<AssociationMappingImpl<?, ?, ?>[]> associationsDetachable;
    private FinalWrapper<AssociationMappingImpl<?, ?, ?>[]> associationsJoined;
    private FinalWrapper<AssociationMappingImpl<?, ?, ?>[]> associationsNotPersistable;
    private FinalWrapper<AssociationMappingImpl<?, ?, ?>[]> associationsPersistable;
    private FinalWrapper<AssociationMappingImpl<?, ?, ?>[]> associationsRemovable;
    private FinalWrapper<PluralAssociationMappingImpl<?, ?, ?>[]> associationsPlural;
    private FinalWrapper<SingularAssociationMappingImpl<?, ?>[]> associationsSingular;
    private FinalWrapper<SingularAssociationMappingImpl<?, ?>[]> associationsSingularLazy;
    private final Map<Method, Method> idMethods = Maps.newHashMap();
    private SingularMappingEx<? super X, ?> idMapping;
    private Boolean suitableForBatchInsert;
    private Pair<SingularMapping<?, ?>, AbstractAccessor>[] idMappings;
    private InheritanceType inheritanceType;
    private final Map<String, EntityTypeImpl<? extends X>> children = Maps.newHashMap();
    private final String discriminatorValue;
    private DiscriminatorColumn discriminatorColumn;
    private EntityTypeImpl<? super X> rootType;
    private final EntityMapping<X> entityMapping;
    private final List<IndexMetadata> indexes;
    private final int maxFetchJoinDepth;

    public EntityTypeImpl(MetamodelImpl metamodel, IdentifiableTypeImpl<? super X> parent, Class<X> javaType, EntityMetadata metadata) {
        super(metamodel, parent, javaType, metadata);
        this.name = metadata.getName();
        this.metadata = metadata;
        this.indexes = metadata.getIndexes();
        this.inheritanceType = metadata.getInheritanceType();
        this.discriminatorValue = StringUtils.isNotBlank((String)metadata.getDiscriminatorValue()) ? metadata.getDiscriminatorValue() : this.name;
        this.maxFetchJoinDepth = metamodel.getEntityManagerFactory().getMaxFetchJoinDepth();
        this.addAttributes(metadata);
        this.initTables(metadata);
        this.entityMapping = new EntityMapping(this);
        this.linkMappings();
        this.initIndexes();
        if (metadata.getTableGenerator() != null) {
            metamodel.addTableGenerator(metadata.getTableGenerator());
        }
        if (metadata.getSequenceGenerator() != null) {
            metamodel.addSequenceGenerator(metadata.getSequenceGenerator());
        }
        this.constructor = this.enhance();
    }

    @Override
    protected void addAttribute(AttributeImpl<? super X, ?> attribute) {
        AssociatedSingularAttribute singularAttribute;
        super.addAttribute(attribute);
        if ((attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE) && StringUtils.isNotBlank((String)(singularAttribute = (AssociatedSingularAttribute)attribute).getMapsId())) {
            this.idMap.put(singularAttribute.getMapsId(), singularAttribute);
        }
    }

    public boolean canBatchRemoves() {
        return this.canBatchRemoves;
    }

    private ConstructorAccessor enhance() {
        try {
            Class enhancedClass = Enhancer.enhance(this);
            Constructor constructor = enhancedClass.getConstructor(Class.class, SessionImpl.class, Object.class, Boolean.TYPE);
            return ReflectHelper.createConstructor(constructor);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot enhance class: " + this.getJavaType(), e);
        }
    }

    public boolean extendz(EntityTypeImpl<?> parent) {
        EntityTypeImpl supertype = this;
        do {
            if (supertype != parent) continue;
            return true;
        } while ((supertype = supertype.getSupertype()) != null);
        return false;
    }

    public void fireCallbacks(Object instance, EntityListenerMetadata.EntityListenerType type) {
        this.fireCallbacks(true, instance, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityTable[] getAllTables() {
        FinalWrapper<EntityTable[]> wrapper = this.allTables;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.allTables == null) {
                    HashMap _tableMap = Maps.newHashMap();
                    this.getAllTables(_tableMap);
                    EntityTable[] _tables = new EntityTable[_tableMap.size()];
                    _tableMap.values().toArray(_tables);
                    Arrays.sort(_tables, new Comparator<EntityTable>(){

                        @Override
                        public int compare(EntityTable o1, EntityTable o2) {
                            if (o1 instanceof SecondaryTable && !(o2 instanceof SecondaryTable)) {
                                return 1;
                            }
                            if (o2 instanceof SecondaryTable && !(o1 instanceof SecondaryTable)) {
                                return -1;
                            }
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    this.allTables = new FinalWrapper<EntityTable[]>(_tables);
                }
                wrapper = this.allTables;
            }
        }
        return (EntityTable[])wrapper.value;
    }

    private void getAllTables(Map<String, EntityTable> tableMap) {
        tableMap.putAll(this.tableMap);
        for (EntityTypeImpl<? extends X> entityTypeImpl : this.children.values()) {
            if (entityTypeImpl == this) continue;
            super.getAllTables(tableMap);
            tableMap.putAll(entityTypeImpl.tableMap);
        }
    }

    public AssociationMetadata getAssociationOverride(String path) {
        for (AssociationMetadata override : this.metadata.getAssociationOverrides()) {
            if (!override.getName().equals(path)) continue;
            return override;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationMappingImpl<?, ?, ?>[] getAssociations() {
        FinalWrapper<AssociationMappingImpl<?, ?, ?>[]> wrapper = this.associations;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.associations == null) {
                    ArrayList _associations = Lists.newArrayList();
                    this.entityMapping.addAssociations(_associations);
                    AssociationMappingImpl[] __associatedAttributes = new AssociationMappingImpl[_associations.size()];
                    _associations.toArray(__associatedAttributes);
                    this.associations = new FinalWrapper<AssociationMappingImpl[]>(__associatedAttributes);
                }
                wrapper = this.associations;
            }
        }
        return (AssociationMappingImpl[])wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationMappingImpl<?, ?, ?>[] getAssociationsDetachable() {
        FinalWrapper<AssociationMappingImpl<?, ?, ?>[]> wrapper = this.associationsDetachable;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.associationsDetachable == null) {
                    ArrayList _associationsDetachable = Lists.newArrayList();
                    for (AssociationMappingImpl<?, ?, ?> association : this.getAssociations()) {
                        if (!association.cascadesDetach()) continue;
                        _associationsDetachable.add(association);
                    }
                    AssociationMappingImpl[] __associationsDetachable = new AssociationMappingImpl[_associationsDetachable.size()];
                    _associationsDetachable.toArray(__associationsDetachable);
                    this.associationsDetachable = new FinalWrapper<AssociationMappingImpl[]>(__associationsDetachable);
                }
                wrapper = this.associationsDetachable;
            }
        }
        return (AssociationMappingImpl[])wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationMappingImpl<?, ?, ?>[] getAssociationsJoined() {
        FinalWrapper<AssociationMappingImpl<?, ?, ?>[]> wrapper = this.associationsJoined;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.associationsJoined == null) {
                    ArrayList joinedAssociations = Lists.newArrayList();
                    for (AssociationMappingImpl<?, ?, ?> association : this.getAssociations()) {
                        if (association.getJoinTable() == null) continue;
                        joinedAssociations.add(association);
                    }
                    AssociationMappingImpl[] __joinedAssociations = new AssociationMappingImpl[joinedAssociations.size()];
                    joinedAssociations.toArray(__joinedAssociations);
                    this.associationsJoined = new FinalWrapper<AssociationMappingImpl[]>(__joinedAssociations);
                }
            }
        }
        return (AssociationMappingImpl[])wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationMappingImpl<?, ?, ?>[] getAssociationsNotPersistable() {
        FinalWrapper<AssociationMappingImpl<?, ?, ?>[]> wrapper = this.associationsNotPersistable;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.associationsNotPersistable == null) {
                    ArrayList _associationsNotPersistable = Lists.newArrayList();
                    for (AssociationMappingImpl<?, ?, ?> mapping : this.getAssociations()) {
                        if (mapping.cascadesPersist()) continue;
                        _associationsNotPersistable.add(mapping);
                    }
                    AssociationMappingImpl[] __associationsNotPersistable = new AssociationMappingImpl[_associationsNotPersistable.size()];
                    _associationsNotPersistable.toArray(__associationsNotPersistable);
                    this.associationsNotPersistable = new FinalWrapper<AssociationMappingImpl[]>(__associationsNotPersistable);
                }
                wrapper = this.associationsNotPersistable;
            }
        }
        return (AssociationMappingImpl[])wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationMappingImpl<?, ?, ?>[] getAssociationsPersistable() {
        FinalWrapper<AssociationMappingImpl<?, ?, ?>[]> wrapper = this.associationsPersistable;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.associationsPersistable == null) {
                    ArrayList _associationsPersistable = Lists.newArrayList();
                    for (AssociationMappingImpl<?, ?, ?> association : this.getAssociations()) {
                        if (!association.cascadesPersist()) continue;
                        _associationsPersistable.add(association);
                    }
                    AssociationMappingImpl[] __associationsPersistable = new AssociationMappingImpl[_associationsPersistable.size()];
                    _associationsPersistable.toArray(__associationsPersistable);
                    this.associationsPersistable = new FinalWrapper<AssociationMappingImpl[]>(__associationsPersistable);
                }
                wrapper = this.associationsPersistable;
            }
        }
        return (AssociationMappingImpl[])wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluralAssociationMappingImpl<?, ?, ?>[] getAssociationsPlural() {
        FinalWrapper<PluralAssociationMappingImpl<?, ?, ?>[]> wrapper = this.associationsPlural;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.associationsPlural == null) {
                    ArrayList _associationsPlural = Lists.newArrayList();
                    for (AssociationMappingImpl<?, ?, ?> mapping : this.getAssociations()) {
                        if (!(mapping instanceof PluralAssociationMappingImpl)) continue;
                        _associationsPlural.add((PluralAssociationMappingImpl)mapping);
                    }
                    PluralAssociationMappingImpl[] __associationsPlural = new PluralAssociationMappingImpl[_associationsPlural.size()];
                    _associationsPlural.toArray(__associationsPlural);
                    this.associationsPlural = new FinalWrapper<PluralAssociationMappingImpl[]>(__associationsPlural);
                }
                wrapper = this.associationsPlural;
            }
        }
        return (PluralAssociationMappingImpl[])wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssociationMappingImpl<?, ?, ?>[] getAssociationsRemovable() {
        FinalWrapper<AssociationMappingImpl<?, ?, ?>[]> wrapper = this.associationsRemovable;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.associationsRemovable == null) {
                    ArrayList _associationsRemovable = Lists.newArrayList();
                    for (AssociationMappingImpl<?, ?, ?> association : this.getAssociations()) {
                        if (!association.cascadesRemove() && !association.removesOrphans()) continue;
                        _associationsRemovable.add(association);
                    }
                    AssociationMappingImpl[] __associationsRemovable = new AssociationMappingImpl[_associationsRemovable.size()];
                    _associationsRemovable.toArray(__associationsRemovable);
                    this.associationsRemovable = new FinalWrapper<AssociationMappingImpl[]>(__associationsRemovable);
                }
                wrapper = this.associationsRemovable;
            }
        }
        return (AssociationMappingImpl[])wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingularAssociationMappingImpl<?, ?>[] getAssociationsSingular() {
        FinalWrapper<SingularAssociationMappingImpl<?, ?>[]> wrapper = this.associationsSingular;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.associationsSingular == null) {
                    ArrayList _associationsSingular = Lists.newArrayList();
                    for (AssociationMappingImpl<?, ?, ?> association : this.getAssociations()) {
                        if (!(association instanceof SingularAssociationMappingImpl)) continue;
                        _associationsSingular.add((SingularAssociationMappingImpl)association);
                    }
                    SingularAssociationMappingImpl[] __associationsSingular = new SingularAssociationMappingImpl[_associationsSingular.size()];
                    _associationsSingular.toArray(__associationsSingular);
                    this.associationsSingular = new FinalWrapper<SingularAssociationMappingImpl[]>(__associationsSingular);
                }
                wrapper = this.associationsSingular;
            }
        }
        return (SingularAssociationMappingImpl[])wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingularAssociationMappingImpl<?, ?>[] getAssociationsSingularOwnerLazy() {
        FinalWrapper<SingularAssociationMappingImpl<?, ?>[]> wrapper = this.associationsSingularLazy;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.associationsSingularLazy == null) {
                    ArrayList _associationsSingularLazy = Lists.newArrayList();
                    for (AssociationMappingImpl<?, ?, ?> mapping : this.getAssociations()) {
                        SingularAssociationMappingImpl singularMapping;
                        if (!(mapping instanceof SingularAssociationMappingImpl) || !(singularMapping = (SingularAssociationMappingImpl)mapping).isOwner() || singularMapping.isEager()) continue;
                        _associationsSingularLazy.add(singularMapping);
                    }
                    SingularAssociationMappingImpl[] __associationsSingularLazy = new SingularAssociationMappingImpl[_associationsSingularLazy.size()];
                    _associationsSingularLazy.toArray(__associationsSingularLazy);
                    this.associationsSingularLazy = new FinalWrapper<SingularAssociationMappingImpl[]>(__associationsSingularLazy);
                }
                wrapper = this.associationsSingularLazy;
            }
        }
        return (SingularAssociationMappingImpl[])wrapper.value;
    }

    public ColumnMetadata getAttributeOverride(String path) {
        for (AttributeOverrideMetadata override : this.metadata.getAttributeOverrides()) {
            if (!override.getName().equals(path)) continue;
            return override.getColumn();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicMappingImpl<?, ?>[] getBasicMappings() {
        FinalWrapper<BasicMappingImpl<?, ?>[]> wrapper = this.basicMappingImpls;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.basicMappingImpls == null) {
                    ArrayList _basicMappings = Lists.newArrayList();
                    this.entityMapping.addBasicMappings(_basicMappings);
                    BasicMappingImpl[] __basicMappings = new BasicMappingImpl[_basicMappings.size()];
                    _basicMappings.toArray(__basicMappings);
                    this.basicMappingImpls = new FinalWrapper<BasicMappingImpl[]>(__basicMappings);
                }
                wrapper = this.basicMappingImpls;
            }
        }
        return (BasicMappingImpl[])wrapper.value;
    }

    public Class<X> getBindableJavaType() {
        return this.getJavaType();
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.ENTITY_TYPE;
    }

    public EntityTypeImpl<? extends X> getChildType(String discriminatorValue) {
        if (discriminatorValue.equals(this.discriminatorValue)) {
            return this;
        }
        return this.children.get(discriminatorValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CriteriaQueryImpl<X> getCriteriaRefresh() {
        if (this.refreshCriteria != null) {
            return this.refreshCriteria;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.refreshCriteria != null) {
                return this.refreshCriteria;
            }
            CriteriaBuilderImpl cb = this.getMetamodel().getEntityManagerFactory().getCriteriaBuilder();
            Object q = cb.createQuery(this.getJavaType());
            ((AbstractCriteriaQueryImpl)q).internal();
            Root r = ((AbstractCriteriaQueryImpl)q).from(this);
            q = ((CriteriaQueryImpl)q).select((Selection)r);
            r.alias(BatooUtils.acronym(this.name).toLowerCase());
            if (this.getRootType().hasSingleIdAttribute()) {
                SingularMapping idMapping = this.getRootType().getIdMapping();
                ParameterExpression pe = cb.parameter(idMapping.getAttribute().getJavaType());
                Path path = r.get(idMapping.getAttribute().getName());
                Predicate predicate = cb.equal((Expression)path, (Expression)pe);
                this.refreshCriteria = ((CriteriaQueryImpl)q).where((Expression)predicate);
                return this.refreshCriteria;
            }
            ArrayList predicates = Lists.newArrayList();
            for (Pair<SingularMapping<?, ?>, AbstractAccessor> pair : this.getIdMappings()) {
                SingularMapping<?, ?> _idMapping = pair.getFirst();
                ParameterExpression pe = cb.parameter(_idMapping.getJavaType());
                Path path = r.get(_idMapping.getName());
                Predicate predicate = cb.equal((Expression)path, (Expression)pe);
                predicates.add(predicate);
            }
            this.refreshCriteria = ((CriteriaQueryImpl)q).where(predicates.toArray(new PredicateImpl[predicates.size()]));
            return this.refreshCriteria;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CriteriaQueryImpl<X> getCriteriaSelect() {
        if (this.selectCriteria != null) {
            return this.selectCriteria;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.selectCriteria != null) {
                return this.selectCriteria;
            }
            CriteriaBuilderImpl cb = this.getMetamodel().getEntityManagerFactory().getCriteriaBuilder();
            Object q = cb.createQuery(this.getJavaType());
            ((AbstractCriteriaQueryImpl)q).internal();
            Root r = ((AbstractCriteriaQueryImpl)q).from(this);
            q = ((CriteriaQueryImpl)q).select((Selection)r);
            r.alias(BatooUtils.acronym(this.name).toLowerCase());
            this.prepareEagerJoins((FetchParent<?, ?>)r, 0, null);
            if (this.getRootType().hasSingleIdAttribute()) {
                SingularMapping _idMapping = this.getRootType().getIdMapping();
                ParameterExpression pe = cb.parameter(_idMapping.getAttribute().getJavaType());
                Path path = r.get(_idMapping.getAttribute().getName());
                Predicate predicate = cb.equal((Expression)path, (Expression)pe);
                this.selectCriteria = ((CriteriaQueryImpl)q).where((Expression)predicate);
                return this.selectCriteria;
            }
            ArrayList predicates = Lists.newArrayList();
            for (Pair<SingularMapping<?, ?>, AbstractAccessor> pair : this.getIdMappings()) {
                SingularMapping<?, ?> _idMapping = pair.getFirst();
                ParameterExpression pe = cb.parameter(_idMapping.getJavaType());
                Path path = r.get(_idMapping.getName());
                Predicate predicate = cb.equal((Expression)path, (Expression)pe);
                predicates.add(predicate);
            }
            this.selectCriteria = ((CriteriaQueryImpl)q).where(predicates.toArray(new PredicateImpl[predicates.size()]));
            return this.selectCriteria;
        }
    }

    public AssociationMappingImpl<?, ?, ?>[] getDependenciesFor(EntityTypeImpl<?> associate) {
        return this.dependencyMap.get(associate);
    }

    public int getDependencyCount() {
        return this.dependencyCount;
    }

    public DiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public Set<String> getDiscriminators() {
        return this.children.keySet();
    }

    @Override
    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public ManagedId<X> getId(Object instance) {
        Object id;
        MutableBoolean allNull = new MutableBoolean(true);
        if (this.hasSingleIdAttribute()) {
            id = this.getIdImpl(instance, this.getIdMapping(), allNull);
        } else {
            id = this.newCompositeId();
            for (Pair<SingularMapping<?, ?>, AbstractAccessor> pair : this.getIdMappings()) {
                SingularMapping<?, ?> child = pair.getFirst();
                Object childId = this.getIdImpl(instance, child, allNull);
                if (childId != null) {
                    allNull.setValue(false);
                }
                pair.getSecond().set(id, childId);
            }
        }
        if (allNull.booleanValue()) {
            return null;
        }
        return new ManagedId(id, this);
    }

    public ManagedId<X> getId(SessionImpl session, ResultSet row) throws SQLException {
        return this.getId(session, row, this.getPrimaryTable().getIdFields());
    }

    public ManagedId<X> getId(SessionImpl session, ResultSet row, HashMap<AbstractColumn, String> idFields) throws SQLException {
        Object id;
        MutableBoolean allNull = new MutableBoolean(true);
        if (this.hasSingleIdAttribute()) {
            id = this.getIdImpl(session, row, idFields, this.getIdMapping(), allNull);
        } else {
            id = this.newCompositeId();
            for (Pair<SingularMapping<?, ?>, AbstractAccessor> pair : this.getIdMappings()) {
                SingularMapping<?, ?> child = pair.getFirst();
                Object childId = this.getIdImpl(session, row, idFields, child, allNull);
                if (childId != null) {
                    allNull.setValue(false);
                }
                pair.getSecond().set(id, childId);
            }
        }
        if (allNull.booleanValue()) {
            return null;
        }
        return new ManagedId(id, this);
    }

    private Object getIdImpl(Object instance, SingularMapping<?, ?> idMapping, MutableBoolean allNull) {
        if (idMapping instanceof BasicMappingImpl) {
            Object value = idMapping.get(instance);
            if (value != null) {
                allNull.setValue(false);
            }
            return value;
        }
        if (idMapping instanceof EmbeddedMappingImpl) {
            EmbeddedMappingImpl embeddedMapping = (EmbeddedMappingImpl)idMapping;
            Object id = ((EmbeddedAttribute)embeddedMapping.getAttribute()).newInstance();
            for (Mapping child : embeddedMapping.getChildren()) {
                Object childId = this.getIdImpl(instance, (SingularMappingEx)child, allNull);
                if (childId != null) {
                    allNull.setValue(false);
                }
                ((AbstractMapping)child).getAttribute().set(id, childId);
            }
            return allNull.booleanValue() ? null : id;
        }
        SingularAssociationMappingImpl singularAssociationMapping = (SingularAssociationMappingImpl)idMapping;
        Object associate = idMapping.get(instance);
        ManagedId<X> id = ((EntityTypeImpl)singularAssociationMapping.getType()).getId(associate);
        return id != null ? id.getId() : null;
    }

    private Object getIdImpl(SessionImpl session, ResultSet row, HashMap<AbstractColumn, String> idFields, SingularMapping<?, ?> idMapping, MutableBoolean allNull) throws SQLException {
        if (idMapping instanceof BasicMappingImpl) {
            BasicColumn column = ((BasicMappingImpl)idMapping).getColumn();
            String field = idFields.get(column);
            Object value = row.getObject(field);
            if (value != null) {
                allNull.setValue(false);
            }
            return value;
        }
        if (idMapping instanceof EmbeddedMappingImpl) {
            EmbeddedMappingImpl embeddedMapping = (EmbeddedMappingImpl)idMapping;
            Object id = ((EmbeddedAttribute)embeddedMapping.getAttribute()).newInstance();
            for (Mapping child : embeddedMapping.getChildren()) {
                Object childId = this.getIdImpl(session, row, idFields, (SingularMappingEx)child, allNull);
                AttributeImpl attribute = ((AbstractMapping)child).getAttribute();
                Attribute.PersistentAttributeType attributeType = attribute.getPersistentAttributeType();
                if (attributeType == Attribute.PersistentAttributeType.MANY_TO_ONE || attributeType == Attribute.PersistentAttributeType.ONE_TO_ONE) {
                    childId = session.getEntityManager().getReference(attribute.getJavaType(), childId);
                }
                attribute.set(id, childId);
            }
            return allNull.booleanValue() ? null : id;
        }
        SingularAssociationMappingImpl singularAssociationMapping = (SingularAssociationMappingImpl)idMapping;
        HashMap translatedIdFields = Maps.newHashMap();
        for (JoinColumn joinColumn : singularAssociationMapping.getForeignKey().getJoinColumns()) {
            translatedIdFields.put(joinColumn.getReferencedColumn(), idFields.get(joinColumn));
        }
        ManagedId<X> id = ((EntityTypeImpl)singularAssociationMapping.getType()).getId(session, row, translatedIdFields);
        return id != null ? id.getId() : null;
    }

    public SingularMappingEx<? super X, ?> getIdMapping() {
        if (this.idMapping != null) {
            return this.idMapping;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.idMapping != null) {
                return this.idMapping;
            }
            for (Mapping mapping : this.entityMapping.getChildren()) {
                if (!(mapping instanceof SingularMappingEx) || !((SingularMappingEx)mapping).getAttribute().isId()) continue;
                this.idMapping = (SingularMappingEx)mapping;
                return this.idMapping;
            }
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<SingularMapping<?, ?>, AbstractAccessor>[] getIdMappings() {
        if (this.idMappings != null) {
            return this.idMappings;
        }
        EntityTypeImpl entityTypeImpl = this;
        synchronized (entityTypeImpl) {
            if (this.idMappings != null) {
                return this.idMappings;
            }
            ArrayList _idMappings = Lists.newArrayList();
            for (Mapping mapping : this.entityMapping.getChildren()) {
                TypeImpl type;
                Field field;
                if (!(mapping instanceof SingularMappingEx) || !((SingularMappingEx)mapping).getAttribute().isId()) continue;
                try {
                    field = this.getIdClass().getDeclaredField(mapping.getName());
                }
                catch (Exception e) {
                    throw new MappingException("Attribute not found: " + this.getIdClass().getName() + "." + mapping.getName(), mapping.getLocator());
                }
                Class<Object> javaType = mapping instanceof SingularAssociationMappingImpl ? (((IdentifiableTypeImpl)(type = ((SingularAssociationMappingImpl)mapping).getType())).hasSingleIdAttribute() ? ((IdentifiableTypeImpl)type).getIdType().getJavaType() : ((IdentifiableTypeImpl)type).getIdClass()) : mapping.getJavaType();
                if (field.getType() != javaType) {
                    throw new MappingException("Attribute types mismatch: " + field + ", " + mapping.getJavaType(), mapping.getLocator());
                }
                SingularMappingEx singularMapping = (SingularMappingEx)mapping;
                AbstractAccessor accessor = ReflectHelper.getAccessor(field);
                _idMappings.add(new Pair<SingularMappingEx, AbstractAccessor>(singularMapping, accessor));
            }
            Pair[] idMappings0 = new Pair[_idMappings.size()];
            _idMappings.toArray(idMappings0);
            this.idMappings = idMappings0;
        }
        return this.idMappings;
    }

    public InheritanceType getInheritanceType() {
        return this.inheritanceType;
    }

    public Object getInstanceId(X instance) {
        return this.getIdMapping().get(instance);
    }

    public ManagedInstance<X> getManagedInstance(SessionImpl session, X instance) {
        if (instance == null) {
            throw new NullPointerException();
        }
        return new ManagedInstance<X>(this, session, instance);
    }

    public ManagedInstance<X> getManagedInstanceById(SessionImpl session, ManagedId<X> id, boolean lazy) {
        try {
            Object instance = this.constructor.newInstance(new Object[]{this.getJavaType(), session, id.getId(), !lazy});
            ManagedInstance<Object> managedInstance = new ManagedInstance<Object>(this, session, instance, id);
            ((EnhancedInstance)instance).__enhanced__$$__setManagedInstance(managedInstance);
            return managedInstance;
        }
        catch (Exception e) {
            throw new PersistenceException("Cannot create instance " + id, (Throwable)e);
        }
    }

    public Object getMappedId(String name, Object instance) {
        AssociatedSingularAttribute<X, ?> attribute = this.idMap.get(name);
        if (attribute == null) {
            return null;
        }
        Object mappedEntity = attribute.get(instance);
        if (mappedEntity == null) {
            return null;
        }
        EntityType entity = this.getMetamodel().entity(mappedEntity.getClass());
        if (entity.hasSingleIdAttribute()) {
            return entity.getIdMapping().get(mappedEntity);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinedMapping<?, ?, ?>[] getMappingsJoined() {
        FinalWrapper<JoinedMapping<?, ?, ?>[]> wrapper = this.mappingsJoined;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.mappingsJoined == null) {
                    ArrayList _mappingsJoined = Lists.newArrayList();
                    this.entityMapping.addJoinedMappings(_mappingsJoined);
                    JoinedMapping[] __mappingsJoined = new JoinedMapping[_mappingsJoined.size()];
                    _mappingsJoined.toArray(__mappingsJoined);
                    this.mappingsJoined = new FinalWrapper<JoinedMapping[]>(__mappingsJoined);
                }
                wrapper = this.mappingsJoined;
            }
        }
        return (JoinedMapping[])wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluralMappingEx<?, ?, ?>[] getMappingsPlural() {
        FinalWrapper<PluralMappingEx<?, ?, ?>[]> wrapper = this.mappingsPlural;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.mappingsPlural == null) {
                    ArrayList _mappingsPlural = Lists.newArrayList();
                    this.entityMapping.addPluralMappings(_mappingsPlural);
                    PluralMappingEx[] __mappingsPlural = new PluralMappingEx[_mappingsPlural.size()];
                    _mappingsPlural.toArray(__mappingsPlural);
                    this.mappingsPlural = new FinalWrapper<PluralMappingEx[]>(__mappingsPlural);
                }
                wrapper = this.mappingsPlural;
            }
        }
        return (PluralMappingEx[])wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluralMappingEx<?, ?, ?>[] getMappingsPluralSorted() {
        FinalWrapper<PluralMappingEx<?, ?, ?>[]> wrapper = this.mappingsPluralSorted;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.mappingsPluralSorted == null) {
                    ArrayList _mappingsPluralSorted = Lists.newArrayList();
                    for (PluralMappingEx<?, ?, ?> mapping : this.getMappingsPlural()) {
                        if (mapping.getOrderBy() == null) continue;
                        _mappingsPluralSorted.add(mapping);
                    }
                    PluralMappingEx[] __mappingsPluralSorted = new PluralMappingEx[_mappingsPluralSorted.size()];
                    _mappingsPluralSorted.toArray(__mappingsPluralSorted);
                    this.mappingsPluralSorted = new FinalWrapper<PluralMappingEx[]>(__mappingsPluralSorted);
                }
                wrapper = this.mappingsPluralSorted;
            }
        }
        return (PluralMappingEx[])wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractMapping<?, ?, ?>[] getMappingsSingular() {
        FinalWrapper<AbstractMapping<?, ?, ?>[]> wrapper = this.singularMappings;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.singularMappings == null) {
                    ArrayList _singularMappings = Lists.newArrayList();
                    this.entityMapping.addSingularMappings(_singularMappings);
                    AbstractMapping[] __singularMappings = new AbstractMapping[_singularMappings.size()];
                    _singularMappings.toArray(__singularMappings);
                    this.singularMappings = new FinalWrapper<AbstractMapping[]>(__singularMappings);
                }
                wrapper = this.singularMappings;
            }
        }
        return (AbstractMapping[])wrapper.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public EntityTypeImpl<? super X> getParent() {
        if (this.isRoot()) {
            return null;
        }
        return (EntityTypeImpl)this.getSupertype();
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }

    @Override
    public EntityTable getPrimaryTable() {
        return this.primaryTable;
    }

    public EntityMapping<X> getRootMapping() {
        return this.entityMapping;
    }

    public EntityTypeImpl<? super X> getRootType() {
        if (this.rootType != null) {
            return this.rootType;
        }
        EntityTypeImpl supertype = this;
        while (supertype.getSupertype() instanceof EntityTypeImpl) {
            supertype = (EntityTypeImpl)supertype.getSupertype();
        }
        this.rootType = supertype;
        return this.rootType;
    }

    @Override
    public AbstractTable getTable(String tableName) {
        if (StringUtils.isBlank((String)tableName)) {
            return this.primaryTable;
        }
        return this.tableMap.get(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityTable[] getTables() {
        FinalWrapper<EntityTable[]> wrapper = this.tables;
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.tables == null) {
                    EntityTable[] _tables = new EntityTable[this.tableMap.size()];
                    this.tableMap.values().toArray(_tables);
                    Arrays.sort(_tables, new Comparator<EntityTable>(){

                        @Override
                        public int compare(EntityTable o1, EntityTable o2) {
                            if (o1 instanceof SecondaryTable && !(o2 instanceof SecondaryTable)) {
                                return 1;
                            }
                            if (o2 instanceof SecondaryTable && !(o1 instanceof SecondaryTable)) {
                                return -1;
                            }
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    this.tables = new FinalWrapper<EntityTable[]>(_tables);
                }
                wrapper = this.tables;
            }
        }
        return (EntityTable[])wrapper.value;
    }

    private void initCustomIndexes() {
        for (IndexMetadata index : this.indexes) {
            EntityTable table;
            EntityTable entityTable = table = StringUtils.isNotBlank((String)index.getTable()) ? this.tableMap.get(index.getTable()) : this.primaryTable;
            if (table == null) {
                throw new MappingException("Cannot locate table for index " + index.getName(), index.getLocator());
            }
            ArrayList columns = Lists.newArrayList();
            for (String path : index.getColumnNames()) {
                Mapping mapping = this.getRootMapping().getMapping(path);
                if (!(mapping instanceof BasicMappingImpl)) {
                    throw new MappingException("Cannot locate the basic path " + path + " for index " + index.getName(), index.getLocator());
                }
                columns.add(((BasicMappingImpl)mapping).getColumn());
            }
            table.addIndex(index.getName(), columns.toArray(new BasicColumn[columns.size()]));
        }
    }

    private void initIndexes() {
        for (BasicMappingImpl<?, ?> basicMapping : this.getBasicMappings()) {
            EntityTable table;
            IndexMetadata index = ((BasicAttribute)basicMapping.getAttribute()).getIndex();
            if (index == null) continue;
            EntityTable entityTable = table = StringUtils.isNotBlank((String)index.getTable()) ? this.tableMap.get(index.getTable()) : this.primaryTable;
            if (table == null) {
                throw new MappingException("Cannot locate table for index " + index.getName(), index.getLocator());
            }
            if (!table.addIndex(index.getName(), basicMapping.getColumn())) continue;
            throw new MappingException("Duplicate index with the same name " + index.getName(), index.getLocator());
        }
        this.initCustomIndexes();
    }

    private void initTables(EntityMetadata metadata) {
        if (this.getRootType() != this) {
            if (this.getRootType().getInheritanceType() == null) {
                super.setInherited();
            }
            switch (this.getRootType().getInheritanceType()) {
                case SINGLE_TABLE: {
                    if (this.getRootType() == this) {
                        this.primaryTable = new EntityTable(this.getMetamodel().getJdbcAdaptor(), this, metadata.getTable());
                        this.tableMap.put(this.primaryTable.getName(), this.primaryTable);
                        break;
                    }
                    EntityTypeImpl supertype = (EntityTypeImpl)this.getSupertype();
                    this.primaryTable = supertype.primaryTable;
                    this.tableMap.putAll(supertype.tableMap);
                    break;
                }
                case JOINED: {
                    if (this.getRootType() == this) {
                        this.primaryTable = new EntityTable(this.getMetamodel().getJdbcAdaptor(), this, metadata.getTable());
                        this.tableMap.put(this.primaryTable.getName(), this.primaryTable);
                        break;
                    }
                    EntityTypeImpl supertype = (EntityTypeImpl)this.getSupertype();
                    this.tableMap.putAll(supertype.tableMap);
                    this.primaryTable = new SecondaryTable(this.getMetamodel().getJdbcAdaptor(), (EntityTypeDescriptor)this, metadata.getTable());
                    this.tableMap.put(this.primaryTable.getName(), this.primaryTable);
                    break;
                }
                case TABLE_PER_CLASS: {
                    throw new MappingException("TABLE_PER_CLASS inheritence type is not yet supported", this.getRootType().getLocator());
                }
            }
        } else {
            this.primaryTable = new EntityTable(this.getMetamodel().getJdbcAdaptor(), this, metadata.getTable());
            this.tableMap.put(this.primaryTable.getName(), this.primaryTable);
        }
        for (SecondaryTableMetadata secondaryTableMetadata : metadata.getSecondaryTables()) {
            SecondaryTable secondaryTable = new SecondaryTable(this.getMetamodel().getJdbcAdaptor(), (EntityTypeDescriptor)this, secondaryTableMetadata);
            this.tableMap.put(secondaryTableMetadata.getName(), secondaryTable);
        }
    }

    public boolean isIdMethod(Method method) {
        if (this.idMethods.containsKey(method)) {
            return true;
        }
        String methodName = method.getName();
        if (methodName.startsWith("get") && methodName.length() > 3) {
            for (SingularAttribute attribute : this.getSingularAttributes()) {
                String getterName = "get" + StringUtils.capitalize((String)attribute.getName());
                if (!attribute.isId() || !getterName.equals(method.getName())) continue;
                this.idMethods.put(method, method);
                return true;
            }
        }
        return false;
    }

    public boolean isRoot() {
        return this.getRootType() == this;
    }

    public boolean isSuitableForBatchInsert() {
        if (this.suitableForBatchInsert != null) {
            return this.suitableForBatchInsert;
        }
        this.suitableForBatchInsert = this.hasSingleIdAttribute() && this.idMapping instanceof BasicMappingImpl && ((BasicAttribute)((BasicMappingImpl)this.idMapping).getAttribute()).getIdType() != IdType.IDENTITY;
        return this.suitableForBatchInsert;
    }

    private void linkMappings() {
        if (this.getRootType().getInheritanceType() != null) {
            EntityTypeImpl parent = this;
            do {
                parent.children.put(this.discriminatorValue, this);
            } while ((parent = parent.getSupertype()) instanceof EntityTypeImpl);
        }
        if (this.getRootType() == this && this.inheritanceType != null) {
            this.discriminatorColumn = new DiscriminatorColumn(this.getMetamodel().getJdbcAdaptor(), this.primaryTable, this.metadata.getDiscriminatorColumn());
        }
        this.entityMapping.createMappings();
        for (EntityTable table : this.tableMap.values()) {
            if (!(table instanceof SecondaryTable)) continue;
            ((SecondaryTable)table).link();
        }
        this.canBatchRemoves = this.getVersionAttribute() == null && this.hasSingleIdAttribute() && this.getIdMapping() instanceof javax.naming.directory.BasicAttribute;
    }

    public void performInsert(Connection connection, ManagedInstance<?>[] managedInstances, int size) throws SQLException {
        Object[] instances = new Object[size];
        for (int i = 0; i < size; ++i) {
            instances[i] = managedInstances[i].getInstance();
        }
        for (EntityTable table : this.getTables()) {
            table.performInsert(connection, this, instances, size);
        }
        for (int i = 0; i < size; ++i) {
            managedInstances[i].setStatus(Status.MANAGED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRefresh(Connection connection, ManagedInstance<X> instance, LockModeType lockMode, Set<Object> processed) {
        SessionImpl session = instance.getSession();
        TypedQuery q = session.getEntityManager().createQuery(this.getCriteriaRefresh());
        if (processed.size() == 0) {
            q.setLockMode(lockMode);
        }
        Object id = instance.getId().getId();
        if (this.hasSingleIdAttribute()) {
            q.setParameter(1, id);
        } else {
            int i = 1;
            for (Pair<SingularMapping<?, ?>, AbstractAccessor> pair : this.getIdMappings()) {
                q.setParameter(i++, pair.getSecond().get(id));
            }
        }
        instance.setRefreshing(true);
        try {
            q.getSingleResult();
        }
        finally {
            instance.setRefreshing(false);
        }
    }

    public void performRemove(Connection connection, ManagedInstance<?>[] managedInstances, int size) throws SQLException {
        Object[] instances = new Object[size];
        for (int i = 0; i < size; ++i) {
            instances[i] = managedInstances[i].getInstance();
        }
        for (EntityTable table : this.getTables()) {
            if (table == this.primaryTable) continue;
            table.performRemove(connection, instances, size);
        }
        this.primaryTable.performRemove(connection, instances, size);
    }

    public X performSelect(EntityManagerImpl entityManager, Object id, LockModeType lockMode) {
        TypedQuery q = entityManager.createQuery(this.getCriteriaSelect());
        q.setLockMode(lockMode);
        if (this.hasSingleIdAttribute()) {
            q.setParameter(1, id);
        } else {
            int i = 1;
            for (Pair<SingularMapping<?, ?>, AbstractAccessor> pair : this.getIdMappings()) {
                q.setParameter(i++, pair.getSecond().get(id));
            }
        }
        return q.getSingleResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performUpdate(Connection connection, ManagedInstance<?> managedInstance) throws SQLException {
        FinalWrapper<EntityTable[]> wrapper = this.updateTables;
        Object instance = managedInstance.getInstance();
        Object oldVersion = managedInstance.getOldVersion();
        if (wrapper == null) {
            EntityTypeImpl entityTypeImpl = this;
            synchronized (entityTypeImpl) {
                if (this.updateTables == null) {
                    ArrayList _updateTables = Lists.newArrayList((Object[])this.getTables());
                    Iterator i = _updateTables.iterator();
                    while (i.hasNext()) {
                        if (((EntityTable)i.next()).performUpdateWithUpdatability(connection, this, managedInstance.getInstance(), oldVersion)) continue;
                        i.remove();
                    }
                    this.updateTables = new FinalWrapper<EntityTable[]>(_updateTables.toArray(new EntityTable[_updateTables.size()]));
                }
                wrapper = this.updateTables;
            }
        } else {
            for (EntityTable table : (EntityTable[])wrapper.value) {
                table.performUpdate(connection, this, instance, oldVersion);
            }
        }
    }

    public void performVersionUpdate(Connection connection, ManagedInstance<? extends X> instance, Object oldVersion, Object newVersion) throws SQLException {
        this.getTables()[0].performVersionUpdate(connection, instance.getInstance(), oldVersion, newVersion);
    }

    public void prepareDependenciesFor(EntityTypeImpl<?> associate) {
        HashSet attributes = Sets.newHashSet();
        for (AssociationMappingImpl<?, ?, ?> association : this.getAssociations()) {
            Class javaType;
            if (!association.isOwner() || association.getAttribute().getPersistentAttributeType() != Attribute.PersistentAttributeType.ONE_TO_ONE && association.getAttribute().getPersistentAttributeType() != Attribute.PersistentAttributeType.MANY_TO_ONE || !(javaType = association.getAttribute().getJavaType()).isAssignableFrom(associate.getBindableJavaType())) continue;
            attributes.add(association);
        }
        AssociationMappingImpl[] dependencies = new AssociationMappingImpl[attributes.size()];
        attributes.toArray(dependencies);
        this.dependencyCount += dependencies.length;
        this.dependencyMap.put(associate, dependencies);
    }

    public void prepareEagerJoins(FetchParent<?, ?> r, int depth, AssociationMappingImpl<?, ?, ?> parent) {
        if (depth < this.maxFetchJoinDepth) {
            this.prepareEagerJoins(r, depth, parent, this.entityMapping.getEagerMappings());
        }
    }

    private void prepareEagerJoins(FetchParent<?, ?> r, int depth, AssociationMappingImpl<?, ?, ?> parent, JoinedMapping<?, ?, ?>[] mappings) {
        for (JoinedMapping<?, ?, ?> mapping : mappings) {
            if (mapping.getMappingType() == MappingType.ELEMENT_COLLECTION) {
                r.fetch(mapping.getAttribute().getName(), JoinType.LEFT);
                continue;
            }
            if (mapping.getMappingType() == MappingType.EMBEDDABLE) {
                Fetch r2 = r.fetch(mapping.getAttribute().getName(), JoinType.LEFT);
                this.prepareEagerJoins((FetchParent<?, ?>)r2, depth, parent, ((EmbeddedMappingImpl)mapping).getEagerMappings());
                continue;
            }
            AssociationMappingImpl association = (AssociationMappingImpl)mapping;
            if (parent != null && association.getInverse() == parent && parent.getAttribute().getPersistentAttributeType() != Attribute.PersistentAttributeType.MANY_TO_ONE || association.getMaxFetchJoinDepth() < depth || association.getFetchStrategy() == FetchStrategyType.SELECT) continue;
            Fetch r2 = r.fetch(((AbstractMapping)((Object)mapping)).getAttribute().getName(), JoinType.LEFT);
            TypeImpl type = association.getType();
            ((EntityTypeImpl)type).prepareEagerJoins((FetchParent<?, ?>)r2, depth + 1, association);
        }
    }

    public Set<ConstraintViolation<Object>> runValidators(EntityManagerFactoryImpl entityManagerFactory, ManagedInstance<?> instance) {
        Class[] groups;
        ValidatorFactory factory = entityManagerFactory.getValidationFactory();
        Validator validator = factory.usingContext().getValidator();
        switch (instance.getStatus()) {
            case NEW: {
                groups = entityManagerFactory.getPersistValidators();
                break;
            }
            case MANAGED: {
                groups = entityManagerFactory.getUpdateValidators();
                break;
            }
            default: {
                groups = entityManagerFactory.getRemoveValidators();
            }
        }
        return validator.validate(instance.getInstance(), groups);
    }

    public void setId(SessionImpl session, Object instance, Object id) {
        if (this.hasSingleIdAttribute()) {
            this.setIdImpl(session, instance, id, this.getIdMapping());
        } else {
            for (Pair<SingularMapping<?, ?>, AbstractAccessor> pair : this.getIdMappings()) {
                SingularMapping<?, ?> child = pair.getFirst();
                AbstractAccessor accessor = pair.getSecond();
                Object childId = id != null ? accessor.get(id) : null;
                this.setIdImpl(session, instance, childId, child);
            }
        }
    }

    private void setIdImpl(SessionImpl session, Object instance, Object id, SingularMapping<?, ?> idMapping) {
        if (idMapping instanceof BasicMappingImpl) {
            idMapping.set(instance, id);
        } else if (idMapping instanceof EmbeddedMappingImpl) {
            EmbeddedMappingImpl embeddedMapping = (EmbeddedMappingImpl)idMapping;
            if (id != null) {
                for (Mapping child : embeddedMapping.getChildren()) {
                    Object childId = ((AbstractMapping)child).getAttribute().get(id);
                    this.setIdImpl(session, instance, childId, (SingularMappingEx)child);
                }
            }
        } else {
            SingularAssociationMappingImpl singularAssociationMapping = (SingularAssociationMappingImpl)idMapping;
            TypeImpl type = singularAssociationMapping.getType();
            if (id == null || type.getJavaType().isAssignableFrom(id.getClass())) {
                idMapping.set(instance, id);
            } else {
                idMapping.set(instance, session.getEntityManager().getReference(type.getJavaType(), id));
            }
        }
    }

    private synchronized void setInherited() {
        if (this.inheritanceType == null) {
            this.inheritanceType = InheritanceType.SINGLE_TABLE;
            if (this.discriminatorColumn == null) {
                this.discriminatorColumn = new DiscriminatorColumn(this.getMetamodel().getJdbcAdaptor(), this.primaryTable, this.metadata.getDiscriminatorColumn());
            }
        }
    }

    public String toString() {
        return "EntityTypeImpl [name=" + this.name + "]";
    }
}

