/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.MappedSuperclassTypeImpl;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.mapping.AbstractMapping;
import org.batoo.jpa.core.impl.model.mapping.AbstractParentMapping;
import org.batoo.jpa.core.impl.model.mapping.ElementMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.EmbeddedMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.SingularMappingEx;
import org.batoo.jpa.jdbc.AbstractTable;
import org.batoo.jpa.jdbc.BasicColumn;
import org.batoo.jpa.jdbc.IdType;
import org.batoo.jpa.jdbc.TypeFactory;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.mapping.BasicMapping;
import org.batoo.jpa.jdbc.mapping.ParentMapping;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.ColumnTransformerMetadata;

public class BasicMappingImpl<Z, X>
extends AbstractMapping<Z, X, X>
implements SingularMappingEx<Z, X>,
BasicMapping<Z, X> {
    private final BasicAttribute<? super Z, X> attribute;
    private final BasicColumn column;

    public BasicMappingImpl(AbstractParentMapping<?, Z> parent, BasicAttribute<? super Z, X> attribute) {
        super(parent, attribute, attribute.getJavaType(), attribute.getName());
        this.attribute = attribute;
        ColumnMetadata columnMetadata = this.getColumnMetadata();
        int sqlType = TypeFactory.getSqlType(this.attribute.getJavaType(), attribute.getTemporalType(), attribute.getEnumType(), attribute.isLob());
        JdbcAdaptor jdbcAdaptor = attribute.getMetamodel().getJdbcAdaptor();
        this.column = new BasicColumn(jdbcAdaptor, this, sqlType, columnMetadata);
        String tableName = this.column.getTableName();
        if (this.getRoot().isEntity()) {
            EntityTypeImpl type = (EntityTypeImpl)this.getRoot().getType();
            if (StringUtils.isBlank((String)tableName)) {
                this.column.setTable(type.getPrimaryTable());
            } else {
                AbstractTable table = type.getTable(tableName);
                if (table == null) {
                    throw new MappingException("Table " + tableName + " could not be found", this.column.getLocator());
                }
                this.column.setTable(table);
            }
        } else {
            this.column.setTable(((ElementMappingImpl)this.getRoot()).getCollectionTable());
        }
    }

    @Override
    public boolean fillValue(EntityTypeImpl<?> type, ManagedInstance<?> managedInstance, Object instance) {
        return this.attribute.fillValue(type, managedInstance, instance);
    }

    @Override
    public BasicAttribute<? super Z, X> getAttribute() {
        return this.attribute;
    }

    @Override
    public BasicColumn getColumn() {
        return this.column;
    }

    private ColumnMetadata getColumnMetadata() {
        ColumnMetadata metadata = null;
        String path = ((AbstractParentMapping)this.getParent()).getRootPath(this.attribute.getName());
        AttributeImpl<Z, Z> rootAttribute = ((AbstractParentMapping)this.getParent()).getRootAttribute(this.attribute);
        if (rootAttribute.getDeclaringType() == this.getRoot().getType() && this.getParent() instanceof EmbeddedMappingImpl && (metadata = ((EmbeddedMappingImpl)this.getParent()).getAttributeOverride(path)) != null) {
            return metadata;
        }
        if (rootAttribute.getDeclaringType() == this.getRoot().getType() && this.getParent() instanceof EmbeddedMappingImpl && (metadata = ((EmbeddedMappingImpl)this.getParent()).getAttributeOverride(path)) != null) {
            return metadata;
        }
        if (rootAttribute.getDeclaringType() instanceof MappedSuperclassTypeImpl && (metadata = ((EntityTypeImpl)this.getRoot().getType()).getAttributeOverride(path)) != null) {
            return metadata;
        }
        if (this.getParent() instanceof EmbeddedMappingImpl && (metadata = ((EmbeddedMappingImpl)this.getParent()).getAttributeOverride(path)) != null) {
            return metadata;
        }
        return this.attribute.getMetadata().getColumn();
    }

    @Override
    public ColumnTransformerMetadata getColumnTransformer() {
        return this.attribute.getColumnTransformer();
    }

    @Override
    public EnumType getEnumType() {
        return this.attribute.getEnumType();
    }

    @Override
    public IdType getIdType() {
        if (this.attribute.getIdType() != null) {
            return this.attribute.getIdType();
        }
        ParentMapping parent = this.getParent();
        if (parent instanceof EmbeddedMappingImpl) {
            return ((EmbeddedMappingImpl)parent).getIdType();
        }
        return null;
    }

    @Override
    public TemporalType getTemporalType() {
        return this.attribute.getTemporalType();
    }

    @Override
    public boolean isId() {
        return this.getIdType() != null;
    }

    @Override
    public boolean isLob() {
        return this.attribute.isLob();
    }

    @Override
    public boolean isVersion() {
        return this.attribute.isVersion();
    }
}

