/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.model.mapping;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.persistence.criteria.JoinType;
import org.batoo.jpa.core.impl.instance.ManagedInstance;
import org.batoo.jpa.core.impl.model.EmbeddableTypeImpl;
import org.batoo.jpa.core.impl.model.EntityTypeImpl;
import org.batoo.jpa.core.impl.model.attribute.AttributeImpl;
import org.batoo.jpa.core.impl.model.attribute.BasicAttribute;
import org.batoo.jpa.core.impl.model.attribute.EmbeddedAttribute;
import org.batoo.jpa.core.impl.model.mapping.AbstractMapping;
import org.batoo.jpa.core.impl.model.mapping.AbstractParentMapping;
import org.batoo.jpa.core.impl.model.mapping.BasicMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.JoinedMapping;
import org.batoo.jpa.core.impl.model.mapping.SingularAssociationMappingImpl;
import org.batoo.jpa.core.impl.model.mapping.SingularMappingEx;
import org.batoo.jpa.jdbc.IdType;
import org.batoo.jpa.jdbc.JoinableTable;
import org.batoo.jpa.jdbc.mapping.EmbeddedMapping;
import org.batoo.jpa.jdbc.mapping.Mapping;
import org.batoo.jpa.jdbc.mapping.MappingType;
import org.batoo.jpa.jdbc.mapping.ParentMapping;
import org.batoo.jpa.jdbc.mapping.RootMapping;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.AssociationMetadata;
import org.batoo.jpa.parser.metadata.ColumnMetadata;

public class EmbeddedMappingImpl<Z, X>
extends AbstractParentMapping<Z, X>
implements SingularMappingEx<Z, X>,
JoinedMapping<Z, X, X>,
EmbeddedMapping<Z, X> {
    private final EmbeddableTypeImpl<X> embeddable;
    private final EmbeddedAttribute<? super Z, X> attribute;
    private AbstractMapping<? super X, ?, ?>[] singularMappings;

    public EmbeddedMappingImpl(AbstractParentMapping<?, Z> parent, EmbeddedAttribute<? super Z, X> attribute) {
        super(parent, attribute, attribute.getBindableJavaType(), attribute.getName());
        this.attribute = attribute;
        this.embeddable = attribute.getType();
    }

    @Override
    public Object extractKey(Object value) {
        return null;
    }

    @Override
    public boolean fillValue(EntityTypeImpl<?> type, ManagedInstance<?> managedInstance, Object instance) {
        Object value = this.get(instance);
        if (value == null) {
            value = ((EmbeddedAttribute)this.getAttribute()).newInstance();
            this.getAttribute().set(instance, value);
        }
        for (Mapping mapping : this.getChildren()) {
            if (mapping instanceof EmbeddedMappingImpl) {
                ((EmbeddedMappingImpl)mapping).fillValue(type, managedInstance, value);
                continue;
            }
            if (mapping instanceof BasicMappingImpl) {
                ((BasicAttribute)((BasicMappingImpl)mapping).getAttribute()).fillValue(type, managedInstance, value);
                continue;
            }
            if (mapping instanceof SingularAssociationMappingImpl) continue;
            throw new MappingException("Embbeded ids can only have basic and embedded attributes.", this.getType().getLocator());
        }
        return true;
    }

    @Override
    public void flush(Connection connection, ManagedInstance<?> managedInstance, boolean removals, boolean force) throws SQLException {
    }

    public AssociationMetadata getAssociationOverride(String path) {
        AssociationMetadata metadata = null;
        if (this.getParent() instanceof EmbeddedMappingImpl) {
            metadata = ((EmbeddedMappingImpl)this.getParent()).getAssociationOverride(this.getAttribute().getName() + "." + path);
        }
        if (metadata != null) {
            return metadata;
        }
        return ((EmbeddedAttribute)this.getAttribute()).getAssociationOverride(path);
    }

    @Override
    public EmbeddedAttribute<? super Z, X> getAttribute() {
        return this.attribute;
    }

    public ColumnMetadata getAttributeOverride(String path) {
        ColumnMetadata metadata = null;
        if (this.getParent() instanceof EmbeddedMappingImpl) {
            metadata = ((EmbeddedMappingImpl)this.getParent()).getAttributeOverride(this.getAttribute().getName() + "." + path);
        }
        if (metadata != null) {
            return metadata;
        }
        return ((EmbeddedAttribute)this.getAttribute()).getAttributeOverride(path);
    }

    @Override
    public IdType getIdType() {
        if (this.attribute.isId()) {
            return IdType.MANUAL;
        }
        ParentMapping parent = this.getParent();
        if (parent instanceof EmbeddedMappingImpl) {
            return ((EmbeddedMappingImpl)parent).getIdType();
        }
        return null;
    }

    @Override
    public JoinableTable getJoinTable() {
        return null;
    }

    @Override
    public MappingType getMappingType() {
        return MappingType.EMBEDDABLE;
    }

    @Override
    public RootMapping<?> getRoot() {
        return ((AbstractMapping)((Object)this.getParent())).getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractMapping<? super X, ?, ?>[] getSingularMappings() {
        if (this.singularMappings != null) {
            return this.singularMappings;
        }
        EmbeddedMappingImpl embeddedMappingImpl = this;
        synchronized (embeddedMappingImpl) {
            if (this.singularMappings != null) {
                return this.singularMappings;
            }
            ArrayList singularMappings = Lists.newArrayList();
            for (Mapping mapping : this.getChildren()) {
                AttributeImpl attribute = ((AbstractMapping)mapping).getAttribute();
                switch (attribute.getPersistentAttributeType()) {
                    case BASIC: 
                    case EMBEDDED: {
                        singularMappings.add((AbstractMapping)mapping);
                        break;
                    }
                    case MANY_TO_ONE: 
                    case ONE_TO_ONE: {
                        SingularAssociationMappingImpl association = (SingularAssociationMappingImpl)mapping;
                        if (!association.isOwner() || association.getJoinTable() != null) break;
                        singularMappings.add((AbstractMapping)mapping);
                    }
                }
            }
            Collections.sort(singularMappings, new Comparator<AbstractMapping<? super X, ?, ?>>(){

                @Override
                public int compare(AbstractMapping<? super X, ?, ?> o1, AbstractMapping<? super X, ?, ?> o2) {
                    return o1.getAttribute().getAttributeId().compareTo(o2.getAttribute().getAttributeId());
                }
            });
            this.singularMappings = singularMappings.toArray(new AbstractMapping[singularMappings.size()]);
            return this.singularMappings;
        }
    }

    @Override
    public EmbeddableTypeImpl<X> getType() {
        return this.embeddable;
    }

    @Override
    public void initialize(ManagedInstance<?> instance) {
    }

    @Override
    public boolean isAssociation() {
        return false;
    }

    @Override
    public boolean isEager() {
        return true;
    }

    @Override
    public boolean isId() {
        return this.attribute.isId();
    }

    @Override
    public boolean isJoined() {
        return true;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public String join(String parentAlias, String alias, JoinType joinType) {
        return null;
    }
}

