/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.core.impl.nativequery;

import java.io.IOException;
import java.io.Reader;

public class SqlReader {
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private static int defaultExpectedLineLength = 80;
    private final Reader in;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private boolean skipLF = false;

    public SqlReader(Reader in) {
        this.in = in;
        this.cb = new char[8192];
        this.nChars = 0;
        this.nextChar = 0;
    }

    private void fill() throws IOException {
        int n;
        int dst;
        if (this.markedChar <= -1) {
            dst = 0;
        } else {
            int delta = this.nextChar - this.markedChar;
            if (delta >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                dst = 0;
            } else {
                if (this.readAheadLimit <= this.cb.length) {
                    System.arraycopy(this.cb, this.markedChar, this.cb, 0, delta);
                    this.markedChar = 0;
                    dst = delta;
                } else {
                    char[] ncb = new char[this.readAheadLimit];
                    System.arraycopy(this.cb, this.markedChar, ncb, 0, delta);
                    this.cb = ncb;
                    this.markedChar = 0;
                    dst = delta;
                }
                this.nextChar = this.nChars = delta;
            }
        }
        while ((n = this.in.read(this.cb, dst, this.cb.length - dst)) == 0) {
        }
        if (n > 0) {
            this.nChars = dst + n;
            this.nextChar = dst;
        }
    }

    public String readLine() throws IOException {
        StringBuilder s = null;
        boolean omitLF = this.skipLF;
        while (true) {
            int i;
            if (this.nextChar >= this.nChars) {
                this.fill();
            }
            if (this.nextChar >= this.nChars) {
                if (s != null && s.length() > 0) {
                    return s.toString();
                }
                return null;
            }
            boolean eol = false;
            char c = '\u0000';
            if (!omitLF || this.cb[this.nextChar] == '\n') {
                // empty if block
            }
            this.skipLF = false;
            omitLF = false;
            for (i = ++this.nextChar; i < this.nChars; ++i) {
                c = this.cb[i];
                if (c != '\n' && c != '\r') continue;
                eol = true;
                break;
            }
            int startChar = this.nextChar;
            this.nextChar = i;
            if (eol) {
                String str;
                if (s == null) {
                    str = new String(this.cb, startChar, i - startChar);
                } else {
                    s.append(this.cb, startChar, i - startChar);
                    str = s.toString();
                }
                ++this.nextChar;
                if (c == '\r') {
                    this.skipLF = true;
                }
                return str;
            }
            if (s == null) {
                s = new StringBuilder(defaultExpectedLineLength);
            }
            s.append(this.cb, startChar, i - startChar);
        }
    }
}

