/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.batoo.common.util.FinalWrapper;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.AbstractTable;
import org.batoo.jpa.jdbc.ElementColumn;
import org.batoo.jpa.jdbc.ForeignKey;
import org.batoo.jpa.jdbc.JoinColumn;
import org.batoo.jpa.jdbc.Joinable;
import org.batoo.jpa.jdbc.JoinableTable;
import org.batoo.jpa.jdbc.MapKeyColumn;
import org.batoo.jpa.jdbc.OrderColumn;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.jdbc.mapping.ElementCollectionMapping;
import org.batoo.jpa.jdbc.mapping.RootMapping;
import org.batoo.jpa.jdbc.model.EmbeddableTypeDescriptor;
import org.batoo.jpa.jdbc.model.EntityTypeDescriptor;
import org.batoo.jpa.jdbc.model.TypeDescriptor;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.metadata.CollectionTableMetadata;
import org.batoo.jpa.parser.metadata.ColumnMetadata;

public class CollectionTable
extends AbstractTable
implements JoinableTable {
    private final JdbcAdaptor jdbcAdaptor;
    private final ForeignKey key;
    private OrderColumn orderColumn;
    private ElementColumn elementColumn;
    private FinalWrapper<String> removeSql;
    private FinalWrapper<String> removeAllSql;
    private AbstractColumn[] removeColumns;
    private JoinColumn[] removeAllColumns;
    private MapKeyColumn keyColumn;
    private final ElementCollectionMapping<?, ?, ?> mapping;

    public CollectionTable(JdbcAdaptor jdbcAdaptor, ElementCollectionMapping<?, ?, ?> mapping, CollectionTableMetadata metadata) {
        super(metadata);
        this.jdbcAdaptor = jdbcAdaptor;
        this.mapping = mapping;
        this.key = new ForeignKey(this.jdbcAdaptor, this.mapping, metadata != null ? metadata.getJoinColumns() : Collections.emptyList());
    }

    public ElementColumn getElementColumn() {
        return this.elementColumn;
    }

    public ForeignKey getKey() {
        return this.key;
    }

    public MapKeyColumn getKeyColumn() {
        return this.keyColumn;
    }

    public ElementCollectionMapping<?, ?, ?> getMapping() {
        return this.mapping;
    }

    public OrderColumn getOrderColumn() {
        return this.orderColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoveAllSql() {
        FinalWrapper<String> wrapper = this.removeAllSql;
        if (wrapper == null) {
            CollectionTable collectionTable = this;
            synchronized (collectionTable) {
                if (this.removeAllSql == null) {
                    ArrayList restrictions = Lists.newArrayList();
                    this.removeAllColumns = new JoinColumn[this.key.getJoinColumns().size()];
                    int i = 0;
                    for (JoinColumn column : this.key.getJoinColumns()) {
                        restrictions.add(column.getName() + " = ?");
                        this.removeAllColumns[i++] = column;
                    }
                    this.removeAllSql = new FinalWrapper<String>("DELETE FROM " + this.getQName() + " WHERE " + Joiner.on((String)" AND ").join((Iterable)restrictions));
                }
                wrapper = this.removeAllSql;
            }
        }
        return (String)wrapper.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoveSql() {
        FinalWrapper<String> wrapper = this.removeSql;
        if (wrapper == null) {
            CollectionTable collectionTable = this;
            synchronized (collectionTable) {
                if (this.removeSql == null) {
                    ArrayList restrictions = Lists.newArrayList();
                    this.removeColumns = new AbstractColumn[this.getColumns().length];
                    int i = 0;
                    for (AbstractColumn column : this.getColumns()) {
                        if (column == this.orderColumn) continue;
                        restrictions.add(column.getName() + " = ?");
                        this.removeColumns[i++] = column;
                    }
                    this.removeSql = new FinalWrapper<String>("DELETE FROM " + this.getQName() + " WHERE " + Joiner.on((String)" AND ").join((Iterable)restrictions));
                }
                wrapper = this.removeSql;
            }
        }
        return (String)wrapper.value;
    }

    public void link(EntityTypeDescriptor entity, EmbeddableTypeDescriptor type, String defaultName, RootMapping<?> elementMapping) {
        if (StringUtils.isBlank((String)this.getName())) {
            this.setName(defaultName);
        }
        this.key.link(null, entity);
        this.key.setTable(this);
    }

    public void link(EntityTypeDescriptor entity, TypeDescriptor type, String defaultName, ColumnMetadata metadata, EnumType enumType, TemporalType temporalType, boolean lob) {
        if (StringUtils.isBlank((String)this.getName())) {
            this.setName(entity.getName() + "_" + defaultName);
        }
        this.key.link(null, entity);
        this.key.setTable(this);
        this.elementColumn = new ElementColumn(this.jdbcAdaptor, this.mapping, this, metadata == null || StringUtils.isBlank((String)metadata.getName()) ? defaultName : metadata.getName(), type.getJavaType(), enumType, temporalType, lob, metadata);
    }

    @Override
    public void performInsert(Connection connection, Object source, Joinable[] batch, int size) throws SQLException {
        String insertSql = this.getInsertSql(null, size);
        AbstractColumn[] insertColumns = this.getInsertColumns(null, size);
        Object[] params = new Object[insertColumns.length * size];
        boolean hasLob = false;
        int paramIndex = 0;
        for (int i = 0; i < size; ++i) {
            for (AbstractColumn column : insertColumns) {
                params[paramIndex++] = column == this.orderColumn ? Integer.valueOf(batch[i].getIndex()) : (column == this.keyColumn ? this.keyColumn.getValue(connection, batch[i].getKey()) : (this.elementColumn == column ? this.elementColumn.getValue(connection, batch[i].getValue()) : (column instanceof JoinColumn ? column.getValue(connection, source) : column.getValue(connection, batch[i].getValue()))));
                hasLob |= column.isLob();
            }
        }
        new QueryRunner(this.jdbcAdaptor, hasLob).update(connection, insertSql, params);
    }

    @Override
    public void performRemove(Connection connection, Object source, Object key, Object destination) throws SQLException {
        String removeSql = this.getRemoveSql();
        Object[] params = new Object[this.removeColumns.length];
        boolean hasLob = false;
        int i = 0;
        for (AbstractColumn column : this.removeColumns) {
            params[i++] = column instanceof ElementColumn ? column.getValue(connection, destination) : (column == this.keyColumn ? this.keyColumn.getValue(connection, key) : (column instanceof JoinColumn ? column.getValue(connection, source) : column.getValue(connection, destination)));
            hasLob |= column.isLob();
        }
        new QueryRunner(this.jdbcAdaptor, hasLob).update(connection, removeSql, params);
    }

    @Override
    public void performRemoveAll(Connection connection, Object source) throws SQLException {
        String removeAllSql = this.getRemoveAllSql();
        Object[] params = new Object[this.removeAllColumns.length];
        int i = 0;
        for (JoinColumn sourceRemoveColumn : this.removeAllColumns) {
            params[i++] = sourceRemoveColumn.getValue(connection, source);
        }
        new QueryRunner(this.jdbcAdaptor, false).update(connection, removeAllSql, params);
    }

    public void setKeyColumn(ColumnMetadata mapKeyColumn, String name, TemporalType mapKeyTemporalType, EnumType mapKeyEnumType, Class<?> mapKeyJavaType) {
        this.keyColumn = new MapKeyColumn(this, mapKeyColumn, name, mapKeyTemporalType, mapKeyEnumType, mapKeyJavaType);
    }

    public void setOrderColumn(ColumnMetadata orderColumn, String name, AbstractLocator locator) {
        this.orderColumn = new OrderColumn(this, orderColumn, name, locator);
    }
}

