/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.jdbc;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.apache.commons.lang.StringUtils;
import org.batoo.common.reflect.AbstractAccessor;
import org.batoo.common.util.FinalWrapper;
import org.batoo.common.util.Pair;
import org.batoo.jpa.jdbc.AbstractColumn;
import org.batoo.jpa.jdbc.AbstractTable;
import org.batoo.jpa.jdbc.EntityTable;
import org.batoo.jpa.jdbc.JoinColumn;
import org.batoo.jpa.jdbc.Joinable;
import org.batoo.jpa.jdbc.OrderColumn;
import org.batoo.jpa.jdbc.SecondaryTable;
import org.batoo.jpa.jdbc.adapter.JdbcAdaptor;
import org.batoo.jpa.jdbc.dbutils.QueryRunner;
import org.batoo.jpa.jdbc.mapping.AssociationMapping;
import org.batoo.jpa.jdbc.mapping.BasicMapping;
import org.batoo.jpa.jdbc.mapping.EmbeddedMapping;
import org.batoo.jpa.jdbc.mapping.Mapping;
import org.batoo.jpa.jdbc.mapping.SingularAssociationMapping;
import org.batoo.jpa.jdbc.mapping.SingularMapping;
import org.batoo.jpa.jdbc.model.EntityTypeDescriptor;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.JoinColumnMetadata;
import org.batoo.jpa.parser.metadata.PrimaryKeyJoinColumnMetadata;

public class ForeignKey {
    private final JdbcAdaptor jdbcAdaptor;
    private Mapping<?, ?, ?> masterMapping;
    private final List<JoinColumn> joinColumns = Lists.newArrayList();
    private final boolean joinMetadataProvided;
    private final boolean inverseOwner;
    private final boolean readOnly;
    private AbstractTable table;
    private String tableName;
    private Mapping<?, ?, ?> mapping;
    private OrderColumn orderColumn;
    private FinalWrapper<String> singleChildSql;
    private AbstractColumn[] singleChildRestrictions;
    private FinalWrapper<String> allChildrenSql;
    private AbstractColumn[] singleChildUpdates;
    private JoinColumn[] allChildrenRestrictions;

    public ForeignKey(JdbcAdaptor jdbcAdaptor, Mapping<?, ?, ?> mapping, List<JoinColumnMetadata> metadata) {
        this(jdbcAdaptor, mapping, metadata, false);
    }

    public ForeignKey(JdbcAdaptor jdbcAdaptor, Mapping<?, ?, ?> mapping, List<JoinColumnMetadata> metadata, boolean inverseOwner) {
        this.jdbcAdaptor = jdbcAdaptor;
        this.mapping = mapping;
        this.inverseOwner = inverseOwner;
        this.readOnly = this.isReadOnly(metadata);
        for (JoinColumnMetadata columnMetadata : metadata) {
            this.joinColumns.add(new JoinColumn(jdbcAdaptor, columnMetadata, this.readOnly));
        }
        this.joinMetadataProvided = this.joinColumns.size() > 0;
    }

    public ForeignKey(JdbcAdaptor jdbcAdaptor, SecondaryTable table, EntityTypeDescriptor entity, List<PrimaryKeyJoinColumnMetadata> metadata) {
        this.jdbcAdaptor = jdbcAdaptor;
        this.inverseOwner = false;
        this.readOnly = false;
        if (entity.hasSingleIdAttribute()) {
            this.createJoinColumns(table, entity.getIdMapping(), metadata);
        } else {
            for (Pair<SingularMapping<?, ?>, AbstractAccessor> pair : entity.getIdMappings()) {
                this.createJoinColumns(table, pair.getFirst(), metadata);
            }
        }
        this.table = table;
        this.table.addForeignKey(this);
        this.joinMetadataProvided = this.joinColumns.size() > 0;
    }

    public String createDestinationJoin(JoinType joinType, String parentAlias, String alias) {
        if (this.inverseOwner) {
            return this.createSourceJoin(joinType, parentAlias, alias);
        }
        return this.createJoin(joinType, parentAlias, alias, this.joinColumns.get(0).getReferencedTable().getQName(), false);
    }

    private String createJoin(JoinType joinType, String parentAlias, String alias, String tableName, boolean source) {
        ArrayList parts = Lists.newArrayList();
        for (JoinColumn joinColumn : this.joinColumns) {
            String leftColumnName = source ? joinColumn.getReferencedColumnName() : joinColumn.getName();
            String rightColumnName = source ? joinColumn.getName() : joinColumn.getReferencedColumnName();
            String part = parentAlias + "." + leftColumnName + " = " + alias + "." + rightColumnName;
            parts.add(part);
        }
        String join = Joiner.on((String)" AND ").join((Iterable)parts);
        switch (joinType) {
            case INNER: {
                return "INNER JOIN " + tableName + " " + alias + " ON " + join;
            }
            case LEFT: {
                return "LEFT JOIN " + tableName + " " + alias + " ON " + join;
            }
        }
        return "RIGHT JOIN " + tableName + " " + alias + " ON " + join;
    }

    private void createJoinColumns(SecondaryTable table, SingularMapping<?, ?> mapping, List<PrimaryKeyJoinColumnMetadata> metadata) {
        if (mapping instanceof BasicMapping) {
            BasicMapping basicMapping = (BasicMapping)mapping;
            PrimaryKeyJoinColumnMetadata columnMetadata = this.getColumnMetadata(metadata, basicMapping.getColumn(), mapping);
            this.joinColumns.add(new JoinColumn(this.jdbcAdaptor, columnMetadata, table, (AbstractColumn)((BasicMapping)mapping).getColumn()));
        } else if (mapping instanceof SingularAssociationMapping) {
            ForeignKey foreignKey = ((SingularAssociationMapping)mapping).getForeignKey();
            for (JoinColumn joinColumn : foreignKey.getJoinColumns()) {
                PrimaryKeyJoinColumnMetadata columnMetadata = this.getColumnMetadata(metadata, joinColumn, mapping);
                this.joinColumns.add(new JoinColumn(this.jdbcAdaptor, columnMetadata, table, joinColumn));
            }
        } else {
            EmbeddedMapping embeddedMapping = (EmbeddedMapping)mapping;
            for (Mapping child : embeddedMapping.getChildren()) {
                if (child instanceof SingularMapping) {
                    this.createJoinColumns(table, (SingularMapping)child, metadata);
                    continue;
                }
                throw new MappingException("EmbeddedId types cannot have plural mappings", mapping.getLocator());
            }
        }
    }

    public String createSourceJoin(JoinType joinType, String parentAlias, String alias) {
        return this.createJoin(joinType, parentAlias, alias, this.joinColumns.get(0).getTable().getQName(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAllChildrenSql() {
        FinalWrapper<String> wrapper = this.allChildrenSql;
        if (wrapper == null) {
            ForeignKey foreignKey = this;
            synchronized (foreignKey) {
                if (this.allChildrenSql == null) {
                    final ArrayList allChildrenRestrictions = Lists.newArrayList();
                    String updates = Joiner.on((String)", ").join((Iterable)Lists.transform(this.joinColumns, (Function)new Function<JoinColumn, String>(){

                        public String apply(JoinColumn input) {
                            return input.getName() + " = NULL";
                        }
                    }));
                    String restrictions = Joiner.on((String)", ").join((Iterable)Lists.transform(this.joinColumns, (Function)new Function<JoinColumn, String>(){

                        public String apply(JoinColumn input) {
                            allChildrenRestrictions.add(input);
                            return input.getName() + " = ?";
                        }
                    }));
                    String order = this.orderColumn != null ? ", " + this.orderColumn.getName() + " = NULL" : "";
                    this.allChildrenRestrictions = allChildrenRestrictions.toArray(new JoinColumn[allChildrenRestrictions.size()]);
                    this.allChildrenSql = new FinalWrapper<String>("UPDATE " + this.table.getQName() + "\nSET " + updates + order + "\nWHERE " + restrictions);
                }
                wrapper = this.allChildrenSql;
            }
        }
        return (String)wrapper.value;
    }

    private PrimaryKeyJoinColumnMetadata getColumnMetadata(List<PrimaryKeyJoinColumnMetadata> metadata, AbstractColumn column, SingularMapping<?, ?> mapping) {
        if (metadata == null || metadata.isEmpty()) {
            return null;
        }
        for (PrimaryKeyJoinColumnMetadata columnMetadata : metadata) {
            if (!column.getName().equals(columnMetadata.getReferencedColumnName())) continue;
            return columnMetadata;
        }
        throw new MappingException("Primary key field cannot be found for " + mapping.getJavaMember() + ".", mapping.getLocator());
    }

    public List<JoinColumn> getJoinColumns() {
        return this.joinColumns;
    }

    public Mapping<?, ?, ?> getMapping() {
        return this.mapping;
    }

    public String getName() {
        ArrayList columns = Lists.newArrayList(this.joinColumns);
        Collections.sort(columns, new Comparator<JoinColumn>(){

            @Override
            public int compare(JoinColumn o1, JoinColumn o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        int prime = 31;
        int id = 31 * ((JoinColumn)columns.get(0)).getReferencedTable().getQName().hashCode();
        id = 31 * ((JoinColumn)columns.get(0)).getTable().getQName().hashCode();
        for (JoinColumn joinColumn : columns) {
            id = 31 * id + joinColumn.getName().hashCode();
        }
        return "FK_" + Integer.toHexString(id).toUpperCase();
    }

    public OrderColumn getOrderColumn() {
        return this.orderColumn;
    }

    public String getReferencedTableName() {
        return this.joinColumns.get(0).getReferencedTable().getName();
    }

    public String getReferencedTableQName() {
        return this.joinColumns.get(0).getReferencedTable().getQName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSingleChildSql() {
        FinalWrapper<String> wrapper = this.singleChildSql;
        if (wrapper == null) {
            ForeignKey foreignKey = this;
            synchronized (foreignKey) {
                if (this.singleChildSql == null) {
                    String order;
                    final ArrayList singleChildRestrictions = Lists.newArrayList();
                    final ArrayList singleChildUpdates = Lists.newArrayList();
                    String updates = Joiner.on((String)", ").join((Iterable)Lists.transform(this.joinColumns, (Function)new Function<JoinColumn, String>(){

                        public String apply(JoinColumn input) {
                            singleChildUpdates.add(input);
                            return input.getName() + " = ?";
                        }
                    }));
                    if (this.orderColumn != null) {
                        singleChildUpdates.add(this.orderColumn);
                        order = ", " + this.orderColumn.getName() + " = ?";
                    } else {
                        order = "";
                    }
                    EntityTable table = (EntityTable)this.table;
                    String restrictions = Joiner.on((String)" AND ").join((Iterable)Collections2.transform(table.getPkColumns(), (Function)new Function<AbstractColumn, String>(){

                        public String apply(AbstractColumn input) {
                            singleChildRestrictions.add(input);
                            return input.getName() + " = ?";
                        }
                    }));
                    this.singleChildRestrictions = singleChildRestrictions.toArray(new AbstractColumn[singleChildRestrictions.size()]);
                    this.singleChildUpdates = singleChildUpdates.toArray(new AbstractColumn[singleChildUpdates.size()]);
                    this.singleChildSql = new FinalWrapper<String>("UPDATE " + this.table.getQName() + "\nSET " + updates + order + "\nWHERE " + restrictions);
                }
                wrapper = this.singleChildSql;
            }
        }
        return (String)wrapper.value;
    }

    public AbstractTable getTable() {
        return this.table;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private boolean isReadOnly(List<JoinColumnMetadata> metadata) {
        for (JoinColumnMetadata columnMetadata : metadata) {
            if (columnMetadata.isUpdatable() || columnMetadata.isInsertable()) continue;
            return true;
        }
        return false;
    }

    public void link(AssociationMapping<?, ?, ?> mapping, EntityTypeDescriptor targetEntity) {
        SingularAssociationMapping singularAssociationMapping;
        String mapsId;
        if (mapping instanceof SingularAssociationMapping && (mapsId = (singularAssociationMapping = (SingularAssociationMapping)mapping).getMapsId()) != null) {
            Class<Object> idClass;
            EntityTypeDescriptor type = (EntityTypeDescriptor)singularAssociationMapping.getRoot().getTypeDescriptor();
            if (!type.hasSingleIdAttribute() || !(type.getIdMapping() instanceof EmbeddedMapping)) {
                throw new MappingException("MapsId can only be used in combination with EmbeddedId", mapping.getLocator());
            }
            EmbeddedMapping embeddedMapping = (EmbeddedMapping)type.getIdMapping();
            this.masterMapping = !mapsId.isEmpty() ? embeddedMapping.getChild(mapsId) : embeddedMapping.getChild(mapping.getName());
            if (this.masterMapping == null) {
                throw new MappingException("Cannot locate the mapping declared by MapsId " + mapsId, mapping.getLocator());
            }
            Class<Object> clazz = idClass = targetEntity.hasSingleIdAttribute() ? targetEntity.getIdMapping().getJavaType() : targetEntity.getIdClass();
            if (idClass != this.masterMapping.getJavaType()) {
                throw new MappingException("MapsId mapped attribute type " + this.masterMapping.getJavaType().getName() + " is not compatible with target entity primary key type " + idClass.getName(), mapping.getLocator());
            }
        }
        if (targetEntity.hasSingleIdAttribute()) {
            this.linkImpl(mapping, targetEntity.getIdMapping());
        } else {
            for (Pair<SingularMapping<?, ?>, AbstractAccessor> pair : targetEntity.getIdMappings()) {
                this.linkImpl(mapping, pair.getFirst());
            }
        }
        if (mapping != null) {
            AbstractTable table = ((EntityTypeDescriptor)mapping.getRoot().getTypeDescriptor()).getTable(this.tableName);
            if (table == null) {
                throw new MappingException("Table " + this.tableName + " could not be found", new AbstractLocator[0]);
            }
            this.setTable(table);
        }
    }

    private void linkImpl(AssociationMapping<?, ?, ?> mapping, SingularMapping<?, ?> idMapping) {
        if (!this.joinMetadataProvided) {
            if (this.masterMapping != null) {
                if (!(idMapping instanceof BasicMapping)) {
                    throw new MappingException("MapsId without metadata points to composite primary key", mapping.getLocator());
                }
                BasicMapping basicMapping = (BasicMapping)this.masterMapping;
                this.joinColumns.add(new JoinColumn(this.jdbcAdaptor, mapping, (AbstractColumn)((BasicMapping)idMapping).getColumn(), basicMapping.getColumn()));
            } else {
                this.linkJoinColumns(mapping, idMapping);
            }
        } else {
            this.linkJoinColumnsWithMetadata(mapping, idMapping);
        }
    }

    private void linkJoinColumns(AssociationMapping<?, ?, ?> mapping, SingularMapping<?, ?> idMapping) {
        boolean id;
        boolean bl = id = mapping instanceof SingularMapping && ((SingularMapping)((Object)mapping)).isId();
        if (idMapping instanceof BasicMapping) {
            this.joinColumns.add(new JoinColumn(this.jdbcAdaptor, mapping, (AbstractColumn)((BasicMapping)idMapping).getColumn(), id));
        } else if (idMapping instanceof SingularAssociationMapping) {
            ForeignKey foreignKey = ((SingularAssociationMapping)idMapping).getForeignKey();
            for (JoinColumn joinColumn : foreignKey.getJoinColumns()) {
                this.joinColumns.add(new JoinColumn(this.jdbcAdaptor, mapping, (AbstractColumn)joinColumn, id));
            }
        } else {
            EmbeddedMapping embeddedMapping = (EmbeddedMapping)idMapping;
            for (Mapping child : embeddedMapping.getChildren()) {
                if (child instanceof SingularMapping) {
                    this.linkJoinColumns(mapping, (SingularMapping)child);
                    continue;
                }
                throw new MappingException("EmbeddedId types cannot have plural mappings", mapping.getLocator());
            }
        }
    }

    private void linkJoinColumnsWithMetadata(AssociationMapping<?, ?, ?> mapping, SingularMapping<?, ?> idMapping) {
        boolean id;
        boolean virtual = this.masterMapping != null;
        boolean bl = id = !virtual && mapping instanceof SingularAssociationMapping && ((SingularMapping)((Object)mapping)).isId();
        if (idMapping instanceof BasicMapping) {
            BasicMapping basicMapping = (BasicMapping)idMapping;
            JoinColumn joinColumn = this.locateJoinColumn(basicMapping.getColumn());
            if (virtual) {
                joinColumn.setColumnProperties(mapping, (AbstractColumn)((BasicMapping)idMapping).getColumn(), this.locateMasterColumn(mapping, joinColumn));
            } else {
                joinColumn.setColumnProperties(mapping, (AbstractColumn)((BasicMapping)idMapping).getColumn(), id);
            }
        } else if (idMapping instanceof SingularAssociationMapping) {
            ForeignKey foreignKey = ((SingularAssociationMapping)mapping).getForeignKey();
            for (JoinColumn referencedColumn : foreignKey.getJoinColumns()) {
                JoinColumn joinColumn = this.locateJoinColumn(referencedColumn);
                if (virtual) {
                    joinColumn.setColumnProperties(mapping, (AbstractColumn)referencedColumn, this.locateMasterColumn(mapping, joinColumn));
                } else {
                    joinColumn.setColumnProperties(mapping, (AbstractColumn)referencedColumn, id);
                }
                joinColumn.setColumnProperties(mapping, (AbstractColumn)referencedColumn, id);
            }
        } else {
            EmbeddedMapping embeddedMapping = (EmbeddedMapping)idMapping;
            for (Mapping child : embeddedMapping.getChildren()) {
                if (child instanceof SingularMapping) {
                    this.linkJoinColumnsWithMetadata(mapping, (SingularMapping)child);
                    continue;
                }
                throw new MappingException("EmbeddedId types cannot have plural mappings", mapping.getLocator());
            }
        }
    }

    private JoinColumn locateJoinColumn(AbstractColumn referencedColumn) {
        JoinColumn joinColumn = null;
        if (this.joinColumns.size() == 1 && StringUtils.isBlank((String)this.joinColumns.get(0).getReferencedColumnName())) {
            joinColumn = this.joinColumns.get(0);
        } else {
            for (JoinColumn column : this.joinColumns) {
                if (!referencedColumn.getName().equals(column.getReferencedColumnName())) continue;
                joinColumn = column;
                break;
            }
        }
        if (joinColumn == null) {
            throw new MappingException("Join column cannot be located in a composite key target entity", new AbstractLocator[0]);
        }
        return joinColumn;
    }

    private AbstractColumn locateMasterColumn(AssociationMapping<?, ?, ?> mapping, JoinColumn joinColumn) {
        EntityTypeDescriptor type = (EntityTypeDescriptor)mapping.getRoot().getTypeDescriptor();
        for (AbstractColumn column : type.getPrimaryTable().getPkColumns()) {
            if (!column.getName().equals(joinColumn.getName())) continue;
            return column;
        }
        throw new MappingException("Primary key column cannot be located: " + joinColumn.getName() + ". Possible columns are: " + type.getPrimaryTable().getPkColumnNames(), mapping.getLocator());
    }

    public void performAttachChild(Connection connection, Object instance, Joinable[] batch, int size) throws SQLException {
        String sql = this.getSingleChildSql();
        Object[] parameters = new Object[this.singleChildUpdates.length + this.singleChildRestrictions.length];
        for (int i = 0; i < size; ++i) {
            Joinable joinable = batch[i];
            int paramIndex = 0;
            for (AbstractColumn column : this.singleChildUpdates) {
                parameters[paramIndex++] = column instanceof JoinColumn ? column.getValue(connection, instance) : Integer.valueOf(joinable.getIndex());
            }
            for (AbstractColumn column : this.singleChildRestrictions) {
                try {
                    parameters[paramIndex++] = column.getValue(connection, joinable.getValue());
                }
                catch (NullPointerException e) {
                    System.out.println("");
                }
            }
            new QueryRunner(this.jdbcAdaptor, false).update(connection, sql, parameters);
        }
    }

    public void performDetachAll(Connection connection, Object instance) throws SQLException {
        String sql = this.getAllChildrenSql();
        Object[] parameters = new Object[this.allChildrenRestrictions.length];
        int i = 0;
        for (JoinColumn column : this.allChildrenRestrictions) {
            parameters[i++] = ((AbstractColumn)column).getValue(connection, instance);
        }
        new QueryRunner(this.jdbcAdaptor, false).update(connection, sql, parameters);
    }

    public void performDetachChild(Connection connection, Object key, Object child) throws SQLException {
        String sql = this.getSingleChildSql();
        Object[] parameters = new Object[this.singleChildUpdates.length + this.singleChildRestrictions.length];
        int i = 0;
        for (AbstractColumn column : this.singleChildUpdates) {
            parameters[i++] = column instanceof JoinColumn ? null : Integer.valueOf(0);
        }
        for (AbstractColumn column : this.singleChildRestrictions) {
            parameters[i++] = column.getValue(connection, child);
        }
        new QueryRunner(this.jdbcAdaptor, false).update(connection, sql, parameters);
    }

    public void setOrderColumn(ColumnMetadata orderColumn, String name, AbstractLocator locator) {
        this.orderColumn = new OrderColumn(this.table, orderColumn, name, locator);
    }

    public void setTable(AbstractTable table) {
        this.table = table;
        for (JoinColumn joinColumn : this.joinColumns) {
            joinColumn.setTable(table);
        }
        this.table.addForeignKey(this);
    }

    public String toString() {
        return "ForeignKey [tableName=" + this.table.getQName() + ", joinColumns=" + this.joinColumns + "]";
    }
}

