/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata;

import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.ColumnResult;
import javax.persistence.EntityResult;
import javax.persistence.SqlResultSetMapping;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.impl.metadata.ColumnResultMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.EntityResultMetadataImpl;
import org.batoo.jpa.parser.metadata.ColumnResultMetadata;
import org.batoo.jpa.parser.metadata.EntityResultMetadata;
import org.batoo.jpa.parser.metadata.SqlResultSetMappingMetadata;

public class SqlResultSetMappingMetadataImpl
implements SqlResultSetMappingMetadata {
    private final AbstractLocator locator;
    private final String name;
    private final List<ColumnResultMetadata> columns = Lists.newArrayList();
    private final List<EntityResultMetadata> entities = Lists.newArrayList();

    public SqlResultSetMappingMetadataImpl(AbstractLocator locator, SqlResultSetMapping annotation) {
        this.locator = locator;
        this.name = annotation.name();
        for (ColumnResult columnResult : annotation.columns()) {
            this.columns.add(new ColumnResultMetadataImpl(locator, columnResult));
        }
        for (ColumnResult columnResult : annotation.entities()) {
            this.entities.add(new EntityResultMetadataImpl(locator, (EntityResult)columnResult));
        }
    }

    @Override
    public List<ColumnResultMetadata> getColumns() {
        return this.columns;
    }

    @Override
    public List<EntityResultMetadata> getEntities() {
        return this.entities;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.locator;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

