/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata.attribute;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.List;
import java.util.Set;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import org.batoo.common.reflect.ReflectHelper;
import org.batoo.jpa.parser.impl.metadata.PrimaryKeyJoinColumnMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.attribute.AssociationAttributeMetadataImpl;
import org.batoo.jpa.parser.metadata.PrimaryKeyJoinColumnMetadata;
import org.batoo.jpa.parser.metadata.attribute.OneToOneAttributeMetadata;

public class OneToOneAttributeMetadataImpl
extends AssociationAttributeMetadataImpl
implements OneToOneAttributeMetadata {
    private final String mappedBy;
    private final boolean removesOprhans;
    private final boolean optional;
    private final String mapsId;
    private final boolean id;
    private final List<PrimaryKeyJoinColumnMetadata> pkJoinColumns = Lists.newArrayList();

    public OneToOneAttributeMetadataImpl(Member member, OneToOneAttributeMetadata metadata) {
        super(member, metadata);
        this.mappedBy = metadata.getMappedBy();
        this.optional = metadata.isOptional();
        this.removesOprhans = metadata.removesOrphans();
        this.mapsId = metadata.getMapsId();
        this.id = metadata.isId();
        this.pkJoinColumns.addAll(Lists.newArrayList(metadata.getPrimaryKeyJoinColumns()));
    }

    public OneToOneAttributeMetadataImpl(Member member, String name, OneToOne oneToOne, Set<Class<? extends Annotation>> parsed) {
        super(member, name, parsed, oneToOne.targetEntity().getName(), oneToOne.fetch(), oneToOne.cascade());
        this.mappedBy = oneToOne.mappedBy();
        this.optional = oneToOne.optional();
        this.removesOprhans = oneToOne.orphanRemoval();
        this.mapsId = this.handleMapsId(member, parsed);
        this.id = this.handleId(member, parsed);
        parsed.add(OneToOne.class);
        PrimaryKeyJoinColumns pkJoinColumns = ReflectHelper.getAnnotation(member, PrimaryKeyJoinColumns.class);
        PrimaryKeyJoinColumn pkJoinColumn = ReflectHelper.getAnnotation(member, PrimaryKeyJoinColumn.class);
        if (pkJoinColumns != null) {
            parsed.add(PrimaryKeyJoinColumns.class);
            for (PrimaryKeyJoinColumn joinColumn : pkJoinColumns.value()) {
                this.pkJoinColumns.add(new PrimaryKeyJoinColumnMetadataImpl(this.getLocator(), joinColumn));
            }
        } else if (pkJoinColumn != null) {
            parsed.add(PrimaryKeyJoinColumn.class);
            this.pkJoinColumns.add(new PrimaryKeyJoinColumnMetadataImpl(this.getLocator(), pkJoinColumn));
        }
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public String getMapsId() {
        return this.mapsId;
    }

    @Override
    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.pkJoinColumns;
    }

    @Override
    public boolean isId() {
        return this.id;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean removesOrphans() {
        return this.removesOprhans;
    }
}

