/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata.type;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.persistence.AccessType;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Cacheable;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.annotations.Index;
import org.batoo.jpa.annotations.Indexes;
import org.batoo.jpa.parser.impl.metadata.AssociationOverrideMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.AttributeOverrideMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.DiscriminatorColumnMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.IndexMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.NamedNativeQueryMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.NamedQueryMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.SecondaryTableMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.SequenceGeneratorMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.SqlResultSetMappingMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.TableGeneratorMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.TableMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.type.IdentifiableMetadataImpl;
import org.batoo.jpa.parser.metadata.AssociationMetadata;
import org.batoo.jpa.parser.metadata.AttributeOverrideMetadata;
import org.batoo.jpa.parser.metadata.DiscriminatorColumnMetadata;
import org.batoo.jpa.parser.metadata.IndexMetadata;
import org.batoo.jpa.parser.metadata.NamedNativeQueryMetadata;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;
import org.batoo.jpa.parser.metadata.SecondaryTableMetadata;
import org.batoo.jpa.parser.metadata.SequenceGeneratorMetadata;
import org.batoo.jpa.parser.metadata.SqlResultSetMappingMetadata;
import org.batoo.jpa.parser.metadata.TableGeneratorMetadata;
import org.batoo.jpa.parser.metadata.TableMetadata;
import org.batoo.jpa.parser.metadata.type.EntityMetadata;

public class EntityMetadataImpl
extends IdentifiableMetadataImpl
implements EntityMetadata {
    private final String name;
    private final Boolean cachable;
    private final TableMetadata table;
    private final SequenceGeneratorMetadata sequenceGenerator;
    private final TableGeneratorMetadata tableGenerator;
    private final List<SecondaryTableMetadata> secondaryTables = Lists.newArrayList();
    private final List<AssociationMetadata> associationOverrides = Lists.newArrayList();
    private final List<AttributeOverrideMetadata> attributeOverrides = Lists.newArrayList();
    private final List<NamedQueryMetadata> namedQueries = Lists.newArrayList();
    private final List<NamedNativeQueryMetadata> namedNativeQueries = Lists.newArrayList();
    private final List<SqlResultSetMappingMetadata> sqlResultSetMappings = Lists.newArrayList();
    private final List<IndexMetadata> indexes = Lists.newArrayList();
    private InheritanceType inheritanceType;
    private DiscriminatorColumnMetadata discriminatorColumn;
    private String discriminatorValue;

    public EntityMetadataImpl(Class<?> clazz, EntityMetadata metadata, AccessType parentAccessType) {
        super(clazz, metadata, parentAccessType);
        Set<Class<? extends Annotation>> parsed = this.getAnnotationsParsed();
        this.name = this.handleName(metadata, parsed);
        this.cachable = this.handleCacheable(metadata, parsed);
        this.table = this.handleTable(metadata, parsed);
        this.handleSecondaryTables(metadata, parsed);
        this.handleAttributeOverrides(metadata, parsed);
        this.handleAssociationOverrides(metadata, parsed);
        this.handleInheritance(metadata, parsed);
        this.sequenceGenerator = this.handleSequenceGenerator(metadata, parsed);
        this.tableGenerator = this.handleTableGenerator(metadata, parsed);
        this.handleNamedQuery(metadata, parsed);
        this.handleNamedNativeQuery(metadata, parsed);
        this.handleSqlResultSetMappings(metadata, parsed);
        this.handleIndexes(metadata, parsed);
    }

    @Override
    public List<AssociationMetadata> getAssociationOverrides() {
        return this.associationOverrides;
    }

    @Override
    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.attributeOverrides;
    }

    @Override
    public Boolean getCacheable() {
        return this.cachable;
    }

    @Override
    public DiscriminatorColumnMetadata getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    @Override
    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    @Override
    public List<IndexMetadata> getIndexes() {
        return this.indexes;
    }

    @Override
    public InheritanceType getInheritanceType() {
        return this.inheritanceType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<NamedNativeQueryMetadata> getNamedNativeQueries() {
        return this.namedNativeQueries;
    }

    @Override
    public List<NamedQueryMetadata> getNamedQueries() {
        return this.namedQueries;
    }

    @Override
    public List<SecondaryTableMetadata> getSecondaryTables() {
        return this.secondaryTables;
    }

    @Override
    public SequenceGeneratorMetadata getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    @Override
    public List<SqlResultSetMappingMetadata> getSqlResultSetMappings() {
        return this.sqlResultSetMappings;
    }

    @Override
    public TableMetadata getTable() {
        return this.table;
    }

    @Override
    public TableGeneratorMetadata getTableGenerator() {
        return this.tableGenerator;
    }

    private void handleAssociationOverrides(EntityMetadata metadata, Set<Class<? extends Annotation>> parsed) {
        if (metadata != null && metadata.getAssociationOverrides().size() > 0) {
            this.associationOverrides.addAll(metadata.getAssociationOverrides());
        } else {
            AssociationOverrides overrides = this.getClazz().getAnnotation(AssociationOverrides.class);
            if (overrides != null && overrides.value().length > 0) {
                parsed.add(AttributeOverrides.class);
                for (AssociationOverride override : overrides.value()) {
                    this.associationOverrides.add(new AssociationOverrideMetadataImpl(this.getLocator(), override));
                }
            } else {
                AssociationOverride override = this.getClazz().getAnnotation(AssociationOverride.class);
                parsed.add(AssociationOverride.class);
                if (override != null) {
                    this.associationOverrides.add(new AssociationOverrideMetadataImpl(this.getLocator(), override));
                }
            }
        }
    }

    private void handleAttributeOverrides(EntityMetadata metadata, Set<Class<? extends Annotation>> parsed) {
        if (metadata != null && metadata.getAttributeOverrides().size() > 0) {
            this.attributeOverrides.addAll(metadata.getAttributeOverrides());
        } else {
            AttributeOverrides overrides = this.getClazz().getAnnotation(AttributeOverrides.class);
            if (overrides != null && overrides.value().length > 0) {
                parsed.add(AttributeOverrides.class);
                for (AttributeOverride override : overrides.value()) {
                    this.attributeOverrides.add(new AttributeOverrideMetadataImpl(this.getLocator(), override));
                }
            } else {
                AttributeOverride override = this.getClazz().getAnnotation(AttributeOverride.class);
                parsed.add(AttributeOverride.class);
                if (override != null) {
                    this.attributeOverrides.add(new AttributeOverrideMetadataImpl(this.getLocator(), override));
                }
            }
        }
    }

    private Boolean handleCacheable(EntityMetadata metadata, Set<Class<? extends Annotation>> parsed) {
        if (metadata != null && metadata.getCacheable() != null) {
            return metadata.getCacheable();
        }
        Cacheable cacheable = this.getClazz().getAnnotation(Cacheable.class);
        if (cacheable != null) {
            parsed.add(Cacheable.class);
            return cacheable.value();
        }
        return null;
    }

    private void handleIndexes(EntityMetadata metadata, Set<Class<? extends Annotation>> parsed) {
        Indexes indexes = this.getClazz().getAnnotation(Indexes.class);
        if (indexes != null && indexes.value().length > 0) {
            parsed.add(Indexes.class);
            for (Index index : indexes.value()) {
                this.indexes.add(new IndexMetadataImpl(this.getLocator(), index));
            }
        } else {
            Index index = this.getClazz().getAnnotation(Index.class);
            parsed.add(Index.class);
            if (index != null) {
                this.indexes.add(new IndexMetadataImpl(this.getLocator(), index));
            }
        }
    }

    private void handleInheritance(EntityMetadata metadata, Set<Class<? extends Annotation>> parsed) {
        DiscriminatorValue discriminatorValue;
        DiscriminatorColumn discriminatorColumn;
        Inheritance inheritance;
        if (metadata != null) {
            this.inheritanceType = metadata.getInheritanceType();
            this.discriminatorColumn = metadata.getDiscriminatorColumn();
            this.discriminatorValue = metadata.getDiscriminatorValue();
        }
        if (this.inheritanceType == null && (inheritance = this.getClazz().getAnnotation(Inheritance.class)) != null) {
            this.inheritanceType = inheritance.strategy();
            parsed.add(Inheritance.class);
        }
        if (this.discriminatorColumn == null && (discriminatorColumn = this.getClazz().getAnnotation(DiscriminatorColumn.class)) != null) {
            this.discriminatorColumn = new DiscriminatorColumnMetadataImpl(this.getLocator(), discriminatorColumn);
            parsed.add(DiscriminatorColumn.class);
        }
        if (this.discriminatorValue == null && (discriminatorValue = this.getClazz().getAnnotation(DiscriminatorValue.class)) != null) {
            this.discriminatorValue = discriminatorValue.value();
            parsed.add(DiscriminatorValue.class);
        }
    }

    private String handleName(EntityMetadata metadata, Set<Class<? extends Annotation>> parsed) {
        if (metadata != null && StringUtils.isNotBlank((String)metadata.getName())) {
            return metadata.getName();
        }
        Entity entity = this.getClazz().getAnnotation(Entity.class);
        if (entity != null && StringUtils.isNotBlank((String)entity.name())) {
            parsed.add(Entity.class);
            return entity.name();
        }
        return this.getClazz().getSimpleName();
    }

    private void handleNamedNativeQuery(EntityMetadata metadata, Set<Class<? extends Annotation>> parsed) {
        NamedNativeQueries namedQueries;
        if (metadata != null && metadata.getNamedNativeQueries().size() > 0) {
            this.namedNativeQueries.addAll(metadata.getNamedNativeQueries());
        }
        if ((namedQueries = this.getClazz().getAnnotation(NamedNativeQueries.class)) != null && namedQueries.value().length > 0) {
            parsed.add(NamedNativeQueries.class);
            for (NamedNativeQuery namedQuery : namedQueries.value()) {
                this.namedNativeQueries.add(new NamedNativeQueryMetadataImpl(this.getLocator(), namedQuery));
            }
        } else {
            NamedNativeQuery namedQuery = this.getClazz().getAnnotation(NamedNativeQuery.class);
            parsed.add(NamedNativeQuery.class);
            if (namedQuery != null) {
                this.namedNativeQueries.add(new NamedNativeQueryMetadataImpl(this.getLocator(), namedQuery));
            }
        }
    }

    private void handleNamedQuery(EntityMetadata metadata, Set<Class<? extends Annotation>> parsed) {
        NamedQueries namedQueries;
        if (metadata != null && metadata.getNamedQueries().size() > 0) {
            this.namedQueries.addAll(metadata.getNamedQueries());
        }
        if ((namedQueries = this.getClazz().getAnnotation(NamedQueries.class)) != null && namedQueries.value().length > 0) {
            parsed.add(NamedQueries.class);
            for (NamedQuery namedQuery : namedQueries.value()) {
                this.namedQueries.add(new NamedQueryMetadataImpl(this.getLocator(), namedQuery));
            }
        } else {
            NamedQuery namedQuery = this.getClazz().getAnnotation(NamedQuery.class);
            parsed.add(NamedQuery.class);
            if (namedQuery != null) {
                this.namedQueries.add(new NamedQueryMetadataImpl(this.getLocator(), namedQuery));
            }
        }
    }

    private void handleSecondaryTables(EntityMetadata metadata, Set<Class<? extends Annotation>> parsed) {
        if (metadata != null && metadata.getSecondaryTables().size() > 0) {
            this.secondaryTables.addAll(metadata.getSecondaryTables());
        } else {
            SecondaryTables secondaryTables = this.getClazz().getAnnotation(SecondaryTables.class);
            if (secondaryTables != null && secondaryTables.value().length > 0) {
                parsed.add(SecondaryTables.class);
                for (SecondaryTable secondaryTable : secondaryTables.value()) {
                    this.secondaryTables.add(new SecondaryTableMetadataImpl(this.getLocator(), secondaryTable));
                }
            } else {
                SecondaryTable secondaryTable = this.getClazz().getAnnotation(SecondaryTable.class);
                if (secondaryTable != null) {
                    parsed.add(SecondaryTable.class);
                    this.secondaryTables.add(new SecondaryTableMetadataImpl(this.getLocator(), secondaryTable));
                }
            }
        }
    }

    private SequenceGeneratorMetadata handleSequenceGenerator(EntityMetadata metadata, Set<Class<? extends Annotation>> parsed) {
        if (metadata != null && metadata.getSequenceGenerator() != null) {
            return metadata.getSequenceGenerator();
        }
        SequenceGenerator annotation = this.getClazz().getAnnotation(SequenceGenerator.class);
        if (annotation != null) {
            parsed.add(SequenceGenerator.class);
            return new SequenceGeneratorMetadataImpl(this.getLocator(), annotation);
        }
        return null;
    }

    private void handleSqlResultSetMappings(EntityMetadata metadata, Set<Class<? extends Annotation>> parsed) {
        SqlResultSetMappings sqlResultSetMappings;
        if (metadata != null && metadata.getSqlResultSetMappings() != null) {
            this.sqlResultSetMappings.addAll(metadata.getSqlResultSetMappings());
        }
        if ((sqlResultSetMappings = this.getClazz().getAnnotation(SqlResultSetMappings.class)) != null && sqlResultSetMappings.value().length > 0) {
            parsed.add(SqlResultSetMappings.class);
            for (SqlResultSetMapping sqlResultSetMapping : sqlResultSetMappings.value()) {
                this.sqlResultSetMappings.add(new SqlResultSetMappingMetadataImpl(this.getLocator(), sqlResultSetMapping));
            }
        } else {
            SqlResultSetMapping annotation = this.getClazz().getAnnotation(SqlResultSetMapping.class);
            if (annotation != null) {
                parsed.add(SqlResultSetMapping.class);
                this.sqlResultSetMappings.add(new SqlResultSetMappingMetadataImpl(this.getLocator(), annotation));
            }
        }
    }

    private TableMetadata handleTable(EntityMetadata metadata, Set<Class<? extends Annotation>> parsed) {
        if (metadata != null && metadata.getTable() != null) {
            return metadata.getTable();
        }
        Table annotation = this.getClazz().getAnnotation(Table.class);
        if (annotation != null) {
            parsed.add(Table.class);
            return new TableMetadataImpl(this.getLocator(), annotation);
        }
        return null;
    }

    private TableGeneratorMetadata handleTableGenerator(EntityMetadata metadata, Set<Class<? extends Annotation>> parsed) {
        if (metadata != null && metadata.getTableGenerator() != null) {
            return metadata.getTableGenerator();
        }
        TableGenerator annotation = this.getClazz().getAnnotation(TableGenerator.class);
        if (annotation != null) {
            parsed.add(TableGenerator.class);
            return new TableGeneratorMetadataImpl(this.getLocator(), annotation);
        }
        return null;
    }
}

