/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata.type;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.PersistenceException;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.impl.metadata.JavaLocator;
import org.batoo.jpa.parser.impl.metadata.attribute.AttributesMetadataImpl;
import org.batoo.jpa.parser.metadata.attribute.AttributesMetadata;
import org.batoo.jpa.parser.metadata.type.ManagedTypeMetadata;

public abstract class ManagedTypeMetadatImpl
implements ManagedTypeMetadata {
    private final JavaLocator locator;
    private final Class<?> clazz;
    private final AccessType accessType;
    private final AttributesMetadataImpl attributes;
    private final Set<Class<? extends Annotation>> parsed = Sets.newHashSet();

    public ManagedTypeMetadatImpl(Class<?> clazz, ManagedTypeMetadata metadata, AccessType parentAccessType) {
        this.clazz = clazz;
        this.locator = new JavaLocator(clazz);
        this.accessType = this.getAccessType(metadata, parentAccessType);
        this.attributes = new AttributesMetadataImpl(this, clazz, metadata != null ? metadata.getAttributes() : null);
    }

    @Override
    public final AccessType getAccessType() {
        return this.accessType;
    }

    private AccessType getAccessType(ManagedTypeMetadata metadata, AccessType parentAccessType) {
        if (metadata != null && metadata.getAccessType() != null) {
            return metadata.getAccessType();
        }
        Access access = this.clazz.getAnnotation(Access.class);
        if (access != null && access.value() != null) {
            return access.value();
        }
        return this.inferAccessType(parentAccessType);
    }

    protected Set<Class<? extends Annotation>> getAnnotationsParsed() {
        return this.parsed;
    }

    @Override
    public AttributesMetadata getAttributes() {
        return this.attributes;
    }

    @Override
    public final String getClassName() {
        return this.clazz.getName();
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public final AbstractLocator getLocator() {
        return this.locator;
    }

    private AccessType inferAccessType(AccessType parentAccessType) {
        String name;
        boolean methodsHasAnnotations = false;
        boolean fieldsHasAnnotations = false;
        ArrayList alternated = Lists.newArrayList();
        Field[] fields = this.clazz.getDeclaredFields();
        Method[] methods = this.clazz.getDeclaredMethods();
        for (Method method : methods) {
            Access access;
            int mods = method.getModifiers();
            if (Modifier.isStatic(mods) || !Modifier.isPublic(mods) || method.isBridge() || method.isSynthetic() || method.getParameterTypes().length != 0 || method.getReturnType() == null || (access = method.getAnnotation(Access.class)) == null) continue;
            String name2 = method.getName();
            if (method.getReturnType() == Boolean.TYPE && name2.startsWith("is")) {
                alternated.add(StringUtils.capitalize((String)name2.substring(2)));
                continue;
            }
            if (!name2.startsWith("get")) continue;
            alternated.add(StringUtils.capitalize((String)name2.substring(3)));
        }
        for (AccessibleObject accessibleObject : fields) {
            Access access = ((Field)accessibleObject).getAnnotation(Access.class);
            if (access == null) continue;
            alternated.add(StringUtils.capitalize((String)((Field)accessibleObject).getName()));
        }
        block2: for (AccessibleObject accessibleObject : methods) {
            for (Annotation a : accessibleObject.getAnnotations()) {
                if (a instanceof Access && ((Access)a).value() != AccessType.PROPERTY || a instanceof Transient || ((Method)accessibleObject).getReturnType() == null || ((Method)accessibleObject).getParameterTypes().length > 0 || (name = a.annotationType().getName()).startsWith("javax.persistence.Post") || name.startsWith("javax.persistence.Pre") || !name.startsWith("javax.persistence") && !name.startsWith("org.batoo.jpa.annotation")) continue;
                name = ((Method)accessibleObject).getName();
                if (Boolean.TYPE == ((Method)accessibleObject).getReturnType() || name.startsWith("is")) {
                    name = name.substring(2);
                } else if (name.startsWith("get")) {
                    name = name.substring(3);
                }
                if (alternated.contains(StringUtils.capitalize((String)name))) continue;
                methodsHasAnnotations = true;
                continue block2;
            }
        }
        block4: for (AccessibleObject accessibleObject : fields) {
            for (Annotation a : accessibleObject.getAnnotations()) {
                if (a instanceof Access && ((Access)a).value() != AccessType.FIELD || a instanceof Transient || !(name = a.annotationType().getName()).startsWith("javax.persistence") && !name.startsWith("org.batoo.jpa.annotation") || alternated.contains(StringUtils.capitalize((String)((Field)accessibleObject).getName()))) continue;
                fieldsHasAnnotations = true;
                continue block4;
            }
        }
        if (fieldsHasAnnotations && methodsHasAnnotations) {
            throw new PersistenceException("At least one field and one method has persistence annotations: " + this.clazz.getName());
        }
        if (methodsHasAnnotations) {
            return AccessType.PROPERTY;
        }
        if (fieldsHasAnnotations) {
            return AccessType.FIELD;
        }
        if (parentAccessType != null) {
            return parentAccessType;
        }
        return AccessType.FIELD;
    }

    @Override
    public boolean isMetadataComplete() {
        return false;
    }
}

