/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.orm.AccessElement;
import org.batoo.jpa.parser.impl.orm.AssociationOverrideElement;
import org.batoo.jpa.parser.impl.orm.AttributeOverrideElement;
import org.batoo.jpa.parser.impl.orm.CascadesElement;
import org.batoo.jpa.parser.impl.orm.CatalogElement;
import org.batoo.jpa.parser.impl.orm.ColumnElement;
import org.batoo.jpa.parser.impl.orm.ColumnNameElement;
import org.batoo.jpa.parser.impl.orm.DiscriminatorColumnElement;
import org.batoo.jpa.parser.impl.orm.DiscriminatorValueElement;
import org.batoo.jpa.parser.impl.orm.ElementConstants;
import org.batoo.jpa.parser.impl.orm.EntityListenerElement;
import org.batoo.jpa.parser.impl.orm.EntityListenersElement;
import org.batoo.jpa.parser.impl.orm.EntityMappings;
import org.batoo.jpa.parser.impl.orm.EnumeratedElement;
import org.batoo.jpa.parser.impl.orm.ExcludeDefaultListenersElement;
import org.batoo.jpa.parser.impl.orm.ExcludeSuperclassListenersElement;
import org.batoo.jpa.parser.impl.orm.GeneratedValueElement;
import org.batoo.jpa.parser.impl.orm.HintElement;
import org.batoo.jpa.parser.impl.orm.IdClassElement;
import org.batoo.jpa.parser.impl.orm.InheritanceElement;
import org.batoo.jpa.parser.impl.orm.InverseJoinColumnElement;
import org.batoo.jpa.parser.impl.orm.JoinColumnElement;
import org.batoo.jpa.parser.impl.orm.JoinTableElement;
import org.batoo.jpa.parser.impl.orm.LobElement;
import org.batoo.jpa.parser.impl.orm.LockModeElement;
import org.batoo.jpa.parser.impl.orm.MapKeyAttributeOverrideElement;
import org.batoo.jpa.parser.impl.orm.MapKeyColumnElement;
import org.batoo.jpa.parser.impl.orm.MapKeyElement;
import org.batoo.jpa.parser.impl.orm.MapKeyEnumeratedElement;
import org.batoo.jpa.parser.impl.orm.MapKeyTemporalElement;
import org.batoo.jpa.parser.impl.orm.NamedNativeQueryElement;
import org.batoo.jpa.parser.impl.orm.NamedQueryElement;
import org.batoo.jpa.parser.impl.orm.OrderByElement;
import org.batoo.jpa.parser.impl.orm.OrderColumnElement;
import org.batoo.jpa.parser.impl.orm.ParentElement;
import org.batoo.jpa.parser.impl.orm.PersistenceUnitDefaults;
import org.batoo.jpa.parser.impl.orm.PersistenceUnitMetadataElement;
import org.batoo.jpa.parser.impl.orm.PrimaryKeyJoinColumnElement;
import org.batoo.jpa.parser.impl.orm.QueryElement;
import org.batoo.jpa.parser.impl.orm.SchemaElement;
import org.batoo.jpa.parser.impl.orm.SecondaryTableElement;
import org.batoo.jpa.parser.impl.orm.SequenceGeneratorElement;
import org.batoo.jpa.parser.impl.orm.SqlResultSetMappingElement;
import org.batoo.jpa.parser.impl.orm.TableElement;
import org.batoo.jpa.parser.impl.orm.TableGeneratorElement;
import org.batoo.jpa.parser.impl.orm.TemporalElement;
import org.batoo.jpa.parser.impl.orm.UniqueConstraintsElement;
import org.batoo.jpa.parser.impl.orm.XmlLocator;
import org.batoo.jpa.parser.impl.orm.XmlMappingMetadataCompleteElement;
import org.batoo.jpa.parser.impl.orm.attribute.AttributesElement;
import org.batoo.jpa.parser.impl.orm.attribute.BasicAttributeElement;
import org.batoo.jpa.parser.impl.orm.attribute.ElementCollectionAttributeElement;
import org.batoo.jpa.parser.impl.orm.attribute.EmbeddedAttributeElement;
import org.batoo.jpa.parser.impl.orm.attribute.EmbeddedIdAttributeElement;
import org.batoo.jpa.parser.impl.orm.attribute.IdAttributeElement;
import org.batoo.jpa.parser.impl.orm.attribute.ManyToManyAttributeElement;
import org.batoo.jpa.parser.impl.orm.attribute.ManyToOneAttributeElement;
import org.batoo.jpa.parser.impl.orm.attribute.OneToManyAttributeElement;
import org.batoo.jpa.parser.impl.orm.attribute.OneToOneAttributeElement;
import org.batoo.jpa.parser.impl.orm.attribute.TransientElement;
import org.batoo.jpa.parser.impl.orm.attribute.VersionAttributeElement;
import org.batoo.jpa.parser.impl.orm.type.EmbeddableElementFactory;
import org.batoo.jpa.parser.impl.orm.type.EntityElementFactory;
import org.batoo.jpa.parser.impl.orm.type.MappedSuperclassElementFactory;
import org.batoo.jpa.parser.metadata.LocatableMatadata;
import org.xml.sax.Locator;

public abstract class Element
extends ElementConstants
implements LocatableMatadata {
    private static final BLogger LOG = BLoggerFactory.getLogger(Element.class);
    private static final Map<String, Class<?>> factoryMap = Maps.newHashMap();
    private final ParentElement parent;
    private final Map<String, String> attributes;
    private final Set<String> expectedChildElements;
    private XmlLocator locator;

    public static Element forElement(Element parent, Map<String, String> attributes, XmlLocator xmlLocator) {
        Class<?> clazz = factoryMap.get(xmlLocator.getLocalName());
        try {
            Constructor<?> constructor = clazz.getConstructor(ParentElement.class, Map.class);
            Element element = (Element)constructor.newInstance(parent, attributes);
            element.setLocator(xmlLocator);
            return element;
        }
        catch (Exception e) {
            LOG.error(e, "Error while processing element: {0}", xmlLocator);
            return null;
        }
    }

    public Element(ParentElement parent, Map<String, String> attributes, String[] expectedChildElements) {
        this.parent = parent;
        this.attributes = attributes;
        this.expectedChildElements = Sets.newHashSet((Object[])expectedChildElements);
    }

    public void cdata(String cdata) {
        throw new UnsupportedOperationException();
    }

    public void end() {
        this.generate();
        if (this.parent != null) {
            LOG.trace("Parsed child {0}", this);
            this.parent.handleChild(this);
        }
    }

    public void expected(String element, Locator locator) throws MappingException {
        if (!this.expectedChildElements.contains(element)) {
            throw new MappingException("Unexpected element '" + element + "' encountered.", this.locator);
        }
    }

    protected void generate() {
    }

    protected String getAttribute(String name) {
        return this.attributes.get(name);
    }

    protected boolean getAttribute(String name, boolean devault) {
        String value = this.attributes.get(name);
        return value != null ? Boolean.valueOf(value) : devault;
    }

    protected int getAttribute(String name, int devault) {
        String value = this.attributes.get(name);
        return value != null ? Integer.valueOf(value) : devault;
    }

    protected String getAttribute(String name, String devault) {
        String value = this.attributes.get(name);
        return value != null ? value : devault;
    }

    public Set<String> getExpectedChildElements() {
        return this.expectedChildElements;
    }

    @Override
    public XmlLocator getLocator() {
        return this.locator;
    }

    public ParentElement getParent() {
        return this.parent;
    }

    private void setLocator(XmlLocator xmlLocator) {
        this.locator = xmlLocator;
    }

    static {
        factoryMap.put("entity-mappings", EntityMappings.class);
        factoryMap.put("catalog", CatalogElement.class);
        factoryMap.put("schema", SchemaElement.class);
        factoryMap.put("access", AccessElement.class);
        factoryMap.put("persistence-unit-metadata", PersistenceUnitMetadataElement.class);
        factoryMap.put("xml-mapping-metadata-complete", XmlMappingMetadataCompleteElement.class);
        factoryMap.put("persistence-unit-defaults", PersistenceUnitDefaults.class);
        factoryMap.put("named-query", NamedQueryElement.class);
        factoryMap.put("named-native-query", NamedNativeQueryElement.class);
        factoryMap.put("sql-result-set-mapping", SqlResultSetMappingElement.class);
        factoryMap.put("lock-mode", LockModeElement.class);
        factoryMap.put("query", QueryElement.class);
        factoryMap.put("hint", HintElement.class);
        factoryMap.put("exclude-default-listeners", ExcludeDefaultListenersElement.class);
        factoryMap.put("exclude-superclass-listeners", ExcludeSuperclassListenersElement.class);
        factoryMap.put("entity-listeners", EntityListenersElement.class);
        factoryMap.put("entity-listener", EntityListenerElement.class);
        factoryMap.put("post-load", EntityListenerElement.PostLoadElement.class);
        factoryMap.put("post-persist", EntityListenerElement.PostPersistElement.class);
        factoryMap.put("post-remove", EntityListenerElement.PostRemoveElement.class);
        factoryMap.put("post-update", EntityListenerElement.PostUpdateElement.class);
        factoryMap.put("pre-persist", EntityListenerElement.PrePersistElement.class);
        factoryMap.put("pre-remove", EntityListenerElement.PreRemoveElement.class);
        factoryMap.put("pre-update", EntityListenerElement.PreUpdateElement.class);
        factoryMap.put("mapped-superclass", MappedSuperclassElementFactory.class);
        factoryMap.put("embeddable", EmbeddableElementFactory.class);
        factoryMap.put("entity", EntityElementFactory.class);
        factoryMap.put("inheritance", InheritanceElement.class);
        factoryMap.put("attributes", AttributesElement.class);
        factoryMap.put("transient", TransientElement.class);
        factoryMap.put("id", IdAttributeElement.class);
        factoryMap.put("id-class", IdClassElement.class);
        factoryMap.put("embedded-id", EmbeddedIdAttributeElement.class);
        factoryMap.put("version", VersionAttributeElement.class);
        factoryMap.put("basic", BasicAttributeElement.class);
        factoryMap.put("embedded", EmbeddedAttributeElement.class);
        factoryMap.put("element-collection", ElementCollectionAttributeElement.class);
        factoryMap.put("one-to-one", OneToOneAttributeElement.class);
        factoryMap.put("one-to-many", OneToManyAttributeElement.class);
        factoryMap.put("many-to-many", ManyToManyAttributeElement.class);
        factoryMap.put("many-to-one", ManyToOneAttributeElement.class);
        factoryMap.put("map-key", MapKeyElement.class);
        factoryMap.put("map-key-class", MapKeyElement.class);
        factoryMap.put("map-key-enumerated", MapKeyEnumeratedElement.class);
        factoryMap.put("map-key-temporal", MapKeyTemporalElement.class);
        factoryMap.put("order-by", OrderByElement.class);
        factoryMap.put("order-column", OrderColumnElement.class);
        factoryMap.put("generated-value", GeneratedValueElement.class);
        factoryMap.put("sequence-generator", SequenceGeneratorElement.class);
        factoryMap.put("table-generator", TableGeneratorElement.class);
        factoryMap.put("temporal", TemporalElement.class);
        factoryMap.put("enumerated", EnumeratedElement.class);
        factoryMap.put("lob", LobElement.class);
        factoryMap.put("association-override", AssociationOverrideElement.class);
        factoryMap.put("attribute-override", AttributeOverrideElement.class);
        factoryMap.put("map-key-attribute-override", MapKeyAttributeOverrideElement.class);
        factoryMap.put("cascade", CascadesElement.class);
        factoryMap.put("cascade-all", CascadesElement.CascadeAllElement.class);
        factoryMap.put("cascade-detach", CascadesElement.CascadeDetachElement.class);
        factoryMap.put("cascade-merge", CascadesElement.CascadeMergeElement.class);
        factoryMap.put("cascade-persist", CascadesElement.CascadePersistElement.class);
        factoryMap.put("cascade-refresh", CascadesElement.CascadeRefreshElement.class);
        factoryMap.put("cascade-remove", CascadesElement.CascadeRemoveElement.class);
        factoryMap.put("column", ColumnElement.class);
        factoryMap.put("map-key-column", MapKeyColumnElement.class);
        factoryMap.put("column-name", ColumnNameElement.class);
        factoryMap.put("inverse-join-column", InverseJoinColumnElement.class);
        factoryMap.put("join-column", JoinColumnElement.class);
        factoryMap.put("primary-key-join-column", PrimaryKeyJoinColumnElement.class);
        factoryMap.put("discriminator-column", DiscriminatorColumnElement.class);
        factoryMap.put("discriminator-value", DiscriminatorValueElement.class);
        factoryMap.put("table", TableElement.class);
        factoryMap.put("secondary-table", SecondaryTableElement.class);
        factoryMap.put("join-table", JoinTableElement.class);
        factoryMap.put("collection-table", JoinTableElement.class);
        factoryMap.put("unique-constraint", UniqueConstraintsElement.class);
    }
}

