/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm.type;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.persistence.AccessType;
import javax.persistence.InheritanceType;
import org.batoo.jpa.parser.impl.orm.AssociationOverrideElement;
import org.batoo.jpa.parser.impl.orm.AttributeOverrideElement;
import org.batoo.jpa.parser.impl.orm.DiscriminatorValueElement;
import org.batoo.jpa.parser.impl.orm.Element;
import org.batoo.jpa.parser.impl.orm.EntityListenersElement;
import org.batoo.jpa.parser.impl.orm.EntityMappings;
import org.batoo.jpa.parser.impl.orm.ExcludeDefaultListenersElement;
import org.batoo.jpa.parser.impl.orm.ExcludeSuperclassListenersElement;
import org.batoo.jpa.parser.impl.orm.IdClassElement;
import org.batoo.jpa.parser.impl.orm.ParentElement;
import org.batoo.jpa.parser.impl.orm.SecondaryTableElement;
import org.batoo.jpa.parser.impl.orm.TableElement;
import org.batoo.jpa.parser.impl.orm.attribute.AttributesElement;
import org.batoo.jpa.parser.metadata.AssociationMetadata;
import org.batoo.jpa.parser.metadata.AttributeOverrideMetadata;
import org.batoo.jpa.parser.metadata.CallbackMetadata;
import org.batoo.jpa.parser.metadata.DiscriminatorColumnMetadata;
import org.batoo.jpa.parser.metadata.EntityListenerMetadata;
import org.batoo.jpa.parser.metadata.IndexMetadata;
import org.batoo.jpa.parser.metadata.InheritanceMetadata;
import org.batoo.jpa.parser.metadata.NamedNativeQueryMetadata;
import org.batoo.jpa.parser.metadata.NamedQueryMetadata;
import org.batoo.jpa.parser.metadata.SecondaryTableMetadata;
import org.batoo.jpa.parser.metadata.SequenceGeneratorMetadata;
import org.batoo.jpa.parser.metadata.SqlResultSetMappingMetadata;
import org.batoo.jpa.parser.metadata.TableGeneratorMetadata;
import org.batoo.jpa.parser.metadata.TableMetadata;
import org.batoo.jpa.parser.metadata.type.EntityMetadata;

public class EntityElementFactory
extends ParentElement
implements EntityMetadata {
    private String name;
    private String className;
    private boolean metadataComplete;
    private Boolean cachable;
    private AccessType accessType;
    private SequenceGeneratorMetadata sequenceGenerator;
    private TableGeneratorMetadata tableGenerator;
    private AttributesElement attrs;
    private TableMetadata table;
    private final List<SecondaryTableMetadata> secondaryTables = Lists.newArrayList();
    private final List<AttributeOverrideMetadata> attributeOverrides = Lists.newArrayList();
    private final List<AssociationMetadata> associationOverrides = Lists.newArrayList();
    private InheritanceType inheritanceType;
    private DiscriminatorColumnMetadata discriminatorColumn;
    private String discriminatorValue;
    private String idClass;
    private boolean excludeDefaultListeners;
    private boolean excludeSuperclassListeners;
    private final List<EntityListenerMetadata> listeners = Lists.newArrayList();
    private final List<CallbackMetadata> callbacks = Lists.newArrayList();
    private final List<NamedQueryMetadata> namedQueries = Lists.newArrayList();
    private final List<NamedNativeQueryMetadata> namedNativeQueries = Lists.newArrayList();
    private final List<SqlResultSetMappingMetadata> sqlResultSetMappings = Lists.newArrayList();

    public EntityElementFactory(ParentElement parent, Map<String, String> attributes) {
        super(parent, attributes, "attribute-override", "association-override", "attributes", "table-generator", "sequence-generator", "table", "secondary-table", "inheritance", "discriminator-column", "discriminator-value", "id-class", "entity-listeners", "pre-persist", "pre-remove", "pre-update", "post-load", "post-persist", "post-remove", "post-update", "exclude-default-listeners", "exclude-superclass-listeners", "named-query", "named-native-query", "sql-result-set-mapping");
    }

    @Override
    public boolean excludeDefaultListeners() {
        return this.excludeDefaultListeners;
    }

    @Override
    public boolean excludeSuperclassListeners() {
        return this.excludeSuperclassListeners;
    }

    @Override
    protected void generate() {
        this.name = this.getAttribute("name", "");
        this.className = this.getAttribute("class", "");
        this.metadataComplete = this.getAttribute("metadata-complete", false);
        this.cachable = this.getAttribute("cachable") != null ? Boolean.valueOf(this.getAttribute("cachable")) : null;
        this.accessType = this.getAttribute("access") != null ? AccessType.valueOf((String)this.getAttribute("access")) : null;
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType != null ? this.accessType : ((EntityMappings)this.getParent()).getAccessType();
    }

    @Override
    public List<AssociationMetadata> getAssociationOverrides() {
        return this.associationOverrides;
    }

    @Override
    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.attributeOverrides;
    }

    @Override
    public AttributesElement getAttributes() {
        return this.attrs;
    }

    @Override
    public Boolean getCacheable() {
        return this.cachable;
    }

    @Override
    public List<CallbackMetadata> getCallbacks() {
        return this.callbacks;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public DiscriminatorColumnMetadata getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    @Override
    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    @Override
    public String getIdClass() {
        return this.idClass;
    }

    @Override
    public List<IndexMetadata> getIndexes() {
        return Lists.newArrayList();
    }

    @Override
    public InheritanceType getInheritanceType() {
        return this.inheritanceType;
    }

    @Override
    public List<EntityListenerMetadata> getListeners() {
        return this.listeners;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<NamedNativeQueryMetadata> getNamedNativeQueries() {
        return this.namedNativeQueries;
    }

    @Override
    public List<NamedQueryMetadata> getNamedQueries() {
        return this.namedQueries;
    }

    @Override
    public List<SecondaryTableMetadata> getSecondaryTables() {
        return this.secondaryTables;
    }

    @Override
    public SequenceGeneratorMetadata getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    @Override
    public List<SqlResultSetMappingMetadata> getSqlResultSetMappings() {
        return this.sqlResultSetMappings;
    }

    @Override
    public TableMetadata getTable() {
        return this.table;
    }

    @Override
    public TableGeneratorMetadata getTableGenerator() {
        return this.tableGenerator;
    }

    @Override
    protected void handleChild(Element child) {
        if (child instanceof AttributesElement) {
            this.attrs = (AttributesElement)child;
        }
        if (child instanceof SequenceGeneratorMetadata) {
            this.sequenceGenerator = (SequenceGeneratorMetadata)((Object)child);
        }
        if (child instanceof TableGeneratorMetadata) {
            this.tableGenerator = (TableGeneratorMetadata)((Object)child);
        }
        if (child instanceof TableElement) {
            this.table = (TableMetadata)((Object)child);
        }
        if (child instanceof SecondaryTableElement) {
            this.secondaryTables.add((SecondaryTableMetadata)((Object)child));
        }
        if (child instanceof AttributeOverrideElement) {
            this.attributeOverrides.add((AttributeOverrideMetadata)((Object)child));
        }
        if (child instanceof AssociationOverrideElement) {
            this.associationOverrides.add((AssociationMetadata)((Object)child));
        }
        if (child instanceof InheritanceMetadata) {
            this.inheritanceType = ((InheritanceMetadata)((Object)child)).getInheritanceType();
        }
        if (child instanceof DiscriminatorColumnMetadata) {
            this.discriminatorColumn = (DiscriminatorColumnMetadata)((Object)child);
        }
        if (child instanceof DiscriminatorValueElement) {
            this.discriminatorValue = ((DiscriminatorValueElement)child).getDiscriminatorValue();
        }
        if (child instanceof IdClassElement) {
            this.idClass = ((IdClassElement)child).getIdClass();
        }
        if (child instanceof EntityListenersElement) {
            this.listeners.addAll(((EntityListenersElement)child).getListeners());
        }
        if (child instanceof CallbackMetadata) {
            this.callbacks.add((CallbackMetadata)((Object)this.callbacks));
        }
        if (child instanceof ExcludeDefaultListenersElement) {
            this.excludeDefaultListeners = true;
        }
        if (child instanceof ExcludeSuperclassListenersElement) {
            this.excludeSuperclassListeners = true;
        }
        if (child instanceof NamedQueryMetadata) {
            this.namedQueries.add((NamedQueryMetadata)((Object)child));
        }
        if (child instanceof NamedNativeQueryMetadata) {
            this.namedNativeQueries.add((NamedNativeQueryMetadata)((Object)child));
        }
        if (child instanceof SqlResultSetMappingMetadata) {
            this.sqlResultSetMappings.add((SqlResultSetMappingMetadata)((Object)child));
        }
    }

    @Override
    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }
}

