/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.acl;

import com.google.common.collect.Sets;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.parser.impl.acl.BaseAnnotatedClassLocator;

public class ClassloaderAnnotatedClassLocator
extends BaseAnnotatedClassLocator {
    private static final BLogger LOG = BLoggerFactory.getLogger(ClassloaderAnnotatedClassLocator.class);
    private static final ClassloaderAnnotatedClassLocator INSTANCE = new ClassloaderAnnotatedClassLocator();

    public static ClassloaderAnnotatedClassLocator getInstance() {
        return INSTANCE;
    }

    private ClassloaderAnnotatedClassLocator() {
    }

    private Set<Class<?>> findClasses(ClassLoader cl, Set<Class<?>> classes, String root, String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            LOG.debug("Processing directory {0}", new Object[]{path});
            for (String child : file.list()) {
                this.findClasses(cl, classes, root, path + "/" + child);
            }
        } else if (FilenameUtils.isExtension((String)path, (String)"class")) {
            String normalizedPath = FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)path));
            int rootLength = FilenameUtils.normalizeNoEndSeparator((String)root).length();
            String className = normalizedPath.substring(rootLength + 1).replaceAll("/", ".");
            Class<?> clazz = this.isPersistentClass(cl, className = StringUtils.left((String)className, (int)(className.length() - 6)));
            if (clazz != null) {
                LOG.debug("Found persistent class {0}", new Object[]{className});
                classes.add(clazz);
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Class<?>> locateClasses(PersistenceUnitInfo persistenceUnitInfo, URL url) {
        Set<Class<?>> set;
        String root = FilenameUtils.separatorsToUnix((String)FilenameUtils.normalize((String)url.getFile()));
        LOG.info("Checking persistence root {0} for persistence classes...", new Object[]{root});
        HashSet classes = Sets.newHashSet();
        try {
            set = this.findClasses(persistenceUnitInfo.getClassLoader(), classes, root, root);
        }
        catch (Throwable throwable) {
            LOG.info("Found persistent classes {0}", new Object[]{classes.toString()});
            throw throwable;
        }
        LOG.info("Found persistent classes {0}", new Object[]{classes.toString()});
        return set;
    }
}

