/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.acl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.spi.PersistenceUnitInfo;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.spi.AnnotatedClassLocator;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class JBoss7AnnotatedClassLocator
implements AnnotatedClassLocator {
    private static final BLogger LOG = BLoggerFactory.getLogger(JBoss7AnnotatedClassLocator.class);
    private static AnnotatedClassLocator INSTANCE = new JBoss7AnnotatedClassLocator();
    private static volatile ReentrantLock lock = new ReentrantLock();
    private static final Map<PersistenceUnitMetadata, Map<URL, Set<Class<?>>>> CLASS_CACHE = Maps.newHashMap();

    private static Map<URL, Set<Class<?>>> getClassCache(PersistenceUnitMetadata pu) {
        HashMap classMap = CLASS_CACHE.get(pu);
        if (classMap == null) {
            classMap = Maps.newHashMap();
            CLASS_CACHE.put(pu, classMap);
        }
        return classMap;
    }

    public static AnnotatedClassLocator getInstance() {
        return INSTANCE;
    }

    private JBoss7AnnotatedClassLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Class<?>> locateClasses(PersistenceUnitInfo persistenceUnitInfo, URL url) {
        PersistenceUnitMetadata pu;
        HashSet classes;
        block4: {
            Index index;
            block5: {
                Set<Class<?>> set;
                LOG.info("Checking persistence root {0} for persistence classes...", new Object[]{url.getFile()});
                lock.lock();
                classes = Sets.newHashSet();
                try {
                    pu = (PersistenceUnitMetadata)persistenceUnitInfo;
                    if (pu.getAnnotationIndex() == null) break block4;
                    index = (Index)pu.getAnnotationIndex().get(url);
                    if (index != null) break block5;
                    LOG.info("No classes present in the jar url {0}", new Object[]{url});
                    set = Collections.emptySet();
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    LOG.info("Found persistent classes {0}", new Object[]{((Object)classes).toString()});
                    throw throwable;
                }
                LOG.info("Found persistent classes {0}", new Object[]{((Object)classes).toString()});
                return set;
            }
            this.locateClassesFor(pu.getClassLoader(), index, Embeddable.class, classes);
            this.locateClassesFor(pu.getClassLoader(), index, MappedSuperclass.class, classes);
            this.locateClassesFor(pu.getClassLoader(), index, Entity.class, classes);
            JBoss7AnnotatedClassLocator.getClassCache(pu).put(url, classes);
            HashSet hashSet = classes;
            lock.unlock();
            LOG.info("Found persistent classes {0}", new Object[]{((Object)classes).toString()});
            return hashSet;
        }
        Set<Class<?>> set = JBoss7AnnotatedClassLocator.getClassCache(pu).get(url);
        lock.unlock();
        LOG.info("Found persistent classes {0}", new Object[]{((Object)classes).toString()});
        return set;
    }

    private void locateClassesFor(ClassLoader classLoader, Index index, Class<? extends Annotation> annotation, Set<Class<?>> classes) {
        DotName annotationName = DotName.createSimple((String)annotation.getName());
        List classesWithAnnotation = index.getAnnotations(annotationName);
        for (AnnotationInstance annotationInstance : classesWithAnnotation) {
            if (!(annotationInstance.target() instanceof ClassInfo)) continue;
            String className = annotationInstance.target().toString();
            try {
                LOG.info("Located persistent {0} class {1}", new Object[]{annotation.getSimpleName(), className});
                classes.add(classLoader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot load persitent class: " + className);
            }
        }
    }
}

