/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.acl;

import com.google.common.collect.Sets;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitInfo;
import org.batoo.jpa.parser.impl.acl.ClassloaderAnnotatedClassLocator;
import org.batoo.jpa.parser.impl.acl.JarAnnotatedClassLocator;
import org.batoo.jpa.spi.AnnotatedClassLocator;

public class StandaloneAnnotatedClassLocator
implements AnnotatedClassLocator {
    private static final StandaloneAnnotatedClassLocator INSTANCE = new StandaloneAnnotatedClassLocator();

    public static StandaloneAnnotatedClassLocator getInstance() {
        return INSTANCE;
    }

    private StandaloneAnnotatedClassLocator() {
    }

    public Set<Class<?>> locateClasses(PersistenceUnitInfo puInfo, URL url) {
        ClassLoader classLoader = puInfo.getClassLoader();
        List jarFiles = puInfo.getJarFileUrls();
        List managedClassNames = puInfo.getManagedClassNames();
        boolean excludeUnlistedClasses = puInfo.excludeUnlistedClasses();
        HashSet classes = Sets.newHashSet();
        if (jarFiles != null && !jarFiles.isEmpty()) {
            for (URL jarUrl : jarFiles) {
                classes.addAll(JarAnnotatedClassLocator.getInstance().locateClasses(puInfo, jarUrl));
            }
        }
        for (String className : managedClassNames) {
            try {
                classes.add(classLoader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException("Unable to load listed persistent class " + className, (Throwable)e);
            }
        }
        if (!excludeUnlistedClasses) {
            classes.addAll(ClassloaderAnnotatedClassLocator.getInstance().locateClasses(puInfo, null));
        }
        return classes;
    }
}

