/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata;

import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.JoinColumn;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.impl.metadata.JoinColumnMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.JoinTableMetadaImpl;
import org.batoo.jpa.parser.metadata.AssociationMetadata;
import org.batoo.jpa.parser.metadata.JoinColumnMetadata;
import org.batoo.jpa.parser.metadata.JoinTableMetadata;

public class AssociationOverrideMetadataImpl
implements AssociationMetadata {
    private final AbstractLocator locator;
    private final String name;
    private final List<JoinColumnMetadata> joinColumns = Lists.newArrayList();
    private final JoinTableMetadata joinTable;

    public AssociationOverrideMetadataImpl(AbstractLocator locator, AssociationOverride annotation) {
        this.locator = locator;
        this.name = annotation.name();
        if (annotation.joinColumns().length > 0) {
            for (JoinColumn joinColumn : annotation.joinColumns()) {
                this.joinColumns.add(new JoinColumnMetadataImpl(this.locator, joinColumn));
            }
            this.joinTable = null;
        } else {
            this.joinTable = new JoinTableMetadaImpl(locator, annotation.joinTable());
        }
    }

    @Override
    public List<JoinColumnMetadata> getJoinColumns() {
        return this.joinColumns;
    }

    @Override
    public JoinTableMetadata getJoinTable() {
        return this.joinTable;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.locator;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

