/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata;

import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.EntityResult;
import javax.persistence.FieldResult;
import org.batoo.jpa.parser.AbstractLocator;
import org.batoo.jpa.parser.impl.metadata.FieldResultMetadataImpl;
import org.batoo.jpa.parser.metadata.EntityResultMetadata;
import org.batoo.jpa.parser.metadata.FieldResultMetadata;

public class EntityResultMetadataImpl
implements EntityResultMetadata {
    private final AbstractLocator locator;
    private final String entityClass;
    private final String discriminatorColumn;
    private final List<FieldResultMetadata> fields = Lists.newArrayList();

    public EntityResultMetadataImpl(AbstractLocator locator, EntityResult annotation) {
        this.locator = locator;
        this.entityClass = annotation.entityClass().getName();
        this.discriminatorColumn = annotation.discriminatorColumn();
        for (FieldResult field : annotation.fields()) {
            this.fields.add(new FieldResultMetadataImpl(locator, field));
        }
    }

    @Override
    public String getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    @Override
    public String getEntityClass() {
        return this.entityClass;
    }

    @Override
    public List<FieldResultMetadata> getFields() {
        return this.fields;
    }

    @Override
    public AbstractLocator getLocator() {
        return this.locator;
    }
}

