/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.metadata.attribute;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.MapKey;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyTemporal;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import javax.persistence.TemporalType;
import org.batoo.common.reflect.ReflectHelper;
import org.batoo.jpa.parser.impl.metadata.AttributeOverrideMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.CollectionTableMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.ColumnMetadataImpl;
import org.batoo.jpa.parser.impl.metadata.attribute.AttributeMetadataImpl;
import org.batoo.jpa.parser.metadata.AssociationMetadata;
import org.batoo.jpa.parser.metadata.AttributeOverrideMetadata;
import org.batoo.jpa.parser.metadata.CollectionTableMetadata;
import org.batoo.jpa.parser.metadata.ColumnMetadata;
import org.batoo.jpa.parser.metadata.attribute.ElementCollectionAttributeMetadata;

public class ElementCollectionAttributeMetadataImpl
extends AttributeMetadataImpl
implements ElementCollectionAttributeMetadata {
    private final CollectionTableMetadata collectionTable;
    private final FetchType fetchType;
    private final String targetClass;
    private final ColumnMetadata column;
    private final String mapKey;
    private final String mapKeyClassName;
    private final EnumType enumType;
    private final boolean lob;
    private final List<AttributeOverrideMetadata> attributeOverrides = Lists.newArrayList();
    private final List<AssociationMetadata> associationOverrides = Lists.newArrayList();
    private final List<AttributeOverrideMetadata> mapKeyAttributeOverrides = Lists.newArrayList();
    private final EnumType mapKeyEnumType;
    private final String orderBy;
    private final TemporalType mapKeyTemporalType;
    private final ColumnMetadata orderColumn;
    private final TemporalType temporalType;
    private final ColumnMetadata mapKeyColumn;

    public ElementCollectionAttributeMetadataImpl(Member member, ElementCollectionAttributeMetadata metadata) {
        super(member, metadata);
        this.collectionTable = metadata.getCollectionTable();
        this.targetClass = metadata.getTargetClass();
        this.fetchType = metadata.getFetchType();
        this.column = metadata.getColumn();
        this.lob = metadata.isLob();
        this.attributeOverrides.addAll(metadata.getAttributeOverrides());
        this.associationOverrides.addAll(metadata.getAssociationOverrides());
        this.enumType = metadata.getEnumType();
        this.temporalType = metadata.getTemporalType();
        this.mapKey = metadata.getMapKey();
        this.mapKeyAttributeOverrides.addAll(metadata.getMapKeyAttributeOverrides());
        this.mapKeyClassName = metadata.getMapKeyClassName();
        this.mapKeyColumn = metadata.getMapKeyColumn();
        this.mapKeyEnumType = metadata.getMapKeyEnumType();
        this.mapKeyTemporalType = metadata.getMapKeyTemporalType();
        this.orderBy = metadata.getOrderBy();
        this.orderColumn = metadata.getOrderColumn();
    }

    public ElementCollectionAttributeMetadataImpl(Member member, String name, ElementCollection elementCollection, Set<Class<? extends Annotation>> parsed) {
        super(member, name);
        parsed.add(ElementCollection.class);
        this.targetClass = "void".equals(elementCollection.targetClass()) ? null : elementCollection.targetClass().getName();
        this.fetchType = elementCollection.fetch();
        this.collectionTable = this.handleCollectionTable(member, parsed);
        this.handleAttributeOverrides(member, parsed);
        this.column = this.handleColumn(member, parsed);
        this.lob = this.handleLob(member, parsed);
        this.enumType = this.handleEnumType(member, parsed);
        this.temporalType = this.handleTemporalType(member, parsed);
        this.mapKey = this.handleMapKey(member, parsed);
        this.mapKeyClassName = this.handleMapKeyClassName(member, parsed);
        this.mapKeyColumn = this.handleMapKeyColumn(member, parsed);
        this.mapKeyEnumType = this.handleMapKeyEnumType(member, parsed);
        this.mapKeyTemporalType = this.handleMapKeyTemporalType(member, parsed);
        this.orderColumn = this.handleOrderColumn(member, parsed);
        this.orderBy = this.handleOrderBy(member, parsed);
    }

    @Override
    public List<AssociationMetadata> getAssociationOverrides() {
        return this.associationOverrides;
    }

    @Override
    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.attributeOverrides;
    }

    @Override
    public CollectionTableMetadata getCollectionTable() {
        return this.collectionTable;
    }

    @Override
    public ColumnMetadata getColumn() {
        return this.column;
    }

    @Override
    public EnumType getEnumType() {
        return this.enumType;
    }

    @Override
    public FetchType getFetchType() {
        return this.fetchType;
    }

    @Override
    public String getMapKey() {
        return this.mapKey;
    }

    @Override
    public List<AttributeOverrideMetadata> getMapKeyAttributeOverrides() {
        return this.mapKeyAttributeOverrides;
    }

    @Override
    public String getMapKeyClassName() {
        return this.mapKeyClassName;
    }

    @Override
    public ColumnMetadata getMapKeyColumn() {
        return this.mapKeyColumn;
    }

    @Override
    public EnumType getMapKeyEnumType() {
        return this.mapKeyEnumType;
    }

    @Override
    public TemporalType getMapKeyTemporalType() {
        return this.mapKeyTemporalType;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    public ColumnMetadata getOrderColumn() {
        return this.orderColumn;
    }

    @Override
    public String getTargetClass() {
        return this.targetClass;
    }

    @Override
    public TemporalType getTemporalType() {
        return this.temporalType;
    }

    private void handleAttributeOverrides(Member member, Set<Class<? extends Annotation>> parsed) {
        AttributeOverrides attributeOverrides = (AttributeOverrides)ReflectHelper.getAnnotation((Member)member, AttributeOverrides.class);
        AttributeOverride attributeOverride = (AttributeOverride)ReflectHelper.getAnnotation((Member)member, AttributeOverride.class);
        if (attributeOverrides != null && attributeOverrides.value() != null && attributeOverrides.value().length > 0) {
            parsed.add(AttributeOverrides.class);
            for (AttributeOverride a : attributeOverrides.value()) {
                this.attributeOverrides.add(new AttributeOverrideMetadataImpl(this.getLocator(), a));
            }
        } else if (attributeOverride != null) {
            parsed.add(AttributeOverride.class);
            this.attributeOverrides.add(new AttributeOverrideMetadataImpl(this.getLocator(), attributeOverride));
        }
    }

    private CollectionTableMetadata handleCollectionTable(Member member, Set<Class<? extends Annotation>> parsed) {
        CollectionTable annotation = (CollectionTable)ReflectHelper.getAnnotation((Member)member, CollectionTable.class);
        if (annotation != null) {
            parsed.add(CollectionTable.class);
            return new CollectionTableMetadataImpl(this.getLocator(), annotation);
        }
        return null;
    }

    private ColumnMetadata handleColumn(Member member, Set<Class<? extends Annotation>> parsed) {
        Column annotation = (Column)ReflectHelper.getAnnotation((Member)member, Column.class);
        if (annotation != null) {
            parsed.add(Column.class);
            return new ColumnMetadataImpl(this.getLocator(), annotation);
        }
        return null;
    }

    private EnumType handleEnumType(Member member, Set<Class<? extends Annotation>> parsed) {
        Enumerated annotation = (Enumerated)ReflectHelper.getAnnotation((Member)member, Enumerated.class);
        if (annotation != null) {
            parsed.add(Enumerated.class);
            return annotation.value();
        }
        Class memberType = ReflectHelper.getMemberType((Member)member);
        int index = memberType == Map.class ? 1 : 0;
        Class type = ReflectHelper.getGenericType((Member)member, (int)index);
        return type.isEnum() ? EnumType.ORDINAL : null;
    }

    private boolean handleLob(Member member, Set<Class<? extends Annotation>> parsed) {
        Lob annotation = (Lob)ReflectHelper.getAnnotation((Member)member, Lob.class);
        if (annotation != null) {
            parsed.add(Lob.class);
            return true;
        }
        return false;
    }

    private String handleMapKey(Member member, Set<Class<? extends Annotation>> parsed) {
        MapKey annotation = (MapKey)ReflectHelper.getAnnotation((Member)member, MapKey.class);
        if (annotation != null) {
            parsed.add(MapKey.class);
            return annotation.name();
        }
        return null;
    }

    private String handleMapKeyClassName(Member member, Set<Class<? extends Annotation>> parsed) {
        MapKeyClass annotation = (MapKeyClass)ReflectHelper.getAnnotation((Member)member, MapKeyClass.class);
        if (annotation != null) {
            parsed.add(MapKeyClass.class);
            return annotation.value().getName();
        }
        return null;
    }

    private ColumnMetadata handleMapKeyColumn(Member member, Set<Class<? extends Annotation>> parsed) {
        MapKeyColumn annotation = (MapKeyColumn)ReflectHelper.getAnnotation((Member)member, MapKeyColumn.class);
        if (annotation != null) {
            parsed.add(MapKeyColumn.class);
            return new ColumnMetadataImpl(this.getLocator(), annotation);
        }
        return null;
    }

    private EnumType handleMapKeyEnumType(Member member, Set<Class<? extends Annotation>> parsed) {
        MapKeyEnumerated annotation = (MapKeyEnumerated)ReflectHelper.getAnnotation((Member)member, MapKeyEnumerated.class);
        if (annotation != null) {
            parsed.add(MapKeyEnumerated.class);
            return annotation.value();
        }
        return null;
    }

    private TemporalType handleMapKeyTemporalType(Member member, Set<Class<? extends Annotation>> parsed) {
        MapKeyTemporal annotation = (MapKeyTemporal)ReflectHelper.getAnnotation((Member)member, MapKeyTemporal.class);
        if (annotation != null) {
            parsed.add(MapKeyTemporal.class);
            return annotation.value();
        }
        return null;
    }

    private String handleOrderBy(Member member, Set<Class<? extends Annotation>> parsed) {
        OrderBy annotation = (OrderBy)ReflectHelper.getAnnotation((Member)member, OrderBy.class);
        if (annotation != null) {
            parsed.add(OrderBy.class);
            return annotation.value();
        }
        return null;
    }

    private ColumnMetadata handleOrderColumn(Member member, Set<Class<? extends Annotation>> parsed) {
        OrderColumn annotation = (OrderColumn)ReflectHelper.getAnnotation((Member)member, OrderColumn.class);
        if (annotation != null) {
            parsed.add(OrderColumn.class);
            return new ColumnMetadataImpl(this.getLocator(), annotation);
        }
        return null;
    }

    private TemporalType handleTemporalType(Member member, Set<Class<? extends Annotation>> parsed) {
        MapKeyTemporal annotation = (MapKeyTemporal)ReflectHelper.getAnnotation((Member)member, MapKeyTemporal.class);
        if (annotation != null) {
            parsed.add(MapKeyTemporal.class);
            return annotation.value();
        }
        return null;
    }

    @Override
    public boolean isLob() {
        return this.lob;
    }
}

