/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.batoo.common.log.BLogger;
import org.batoo.common.log.BLoggerFactory;
import org.batoo.jpa.parser.MappingException;
import org.batoo.jpa.parser.impl.orm.Element;
import org.batoo.jpa.parser.impl.orm.EntityMappings;
import org.batoo.jpa.parser.impl.orm.XmlLocator;
import org.batoo.jpa.parser.metadata.Metadata;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class OrmContentHandler
implements ContentHandler {
    private static final BLogger LOG = BLoggerFactory.getLogger(OrmContentHandler.class);
    private final String fileName;
    private Locator locator;
    private final Stack<Element> elementStack = new Stack();
    private EntityMappings entityMappings;

    public OrmContentHandler(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String cdata = new String(ch, start, length);
        if (cdata.startsWith("![CDATA[")) {
            cdata = cdata.substring(8, cdata.length() - 2);
        }
        if (StringUtils.isNotBlank((String)cdata)) {
            LOG.trace("Element body {0}", new Object[]{cdata});
            this.elementStack.peek().cdata(cdata);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        LOG.debug("ORM Parsing is over for {0}", new Object[]{this.fileName});
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        LOG.trace("End of element url: {0}, localName: {1}, qName: {2}", new Object[]{uri, localName, qName});
        Element element = this.elementStack.pop();
        element.end();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        LOG.trace("End of prefix mapping {0}", new Object[]{prefix});
    }

    public Metadata getMetadata() {
        return this.entityMappings;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        LOG.trace("Ignorable whitespace {0}", new Object[]{new String(ch, start, length)});
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        LOG.trace("Processing instructions {0}, {1}", new Object[]{target, data});
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        LOG.warn("Skipped entity {0}", new Object[]{name});
    }

    @Override
    public void startDocument() throws SAXException {
        LOG.debug("ORM Parsing started for {0}", new Object[]{this.fileName});
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        HashMap attributes = Maps.newHashMap();
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            attributes.put(name, value);
        }
        LOG.trace("Start of element url: {0}, localName: {1}, qName: {2}, attributes: {3}", new Object[]{uri, localName, qName, attributes});
        if (this.elementStack.size() == 0) {
            if (!"entity-mappings".equals(localName)) {
                throw new MappingException("Unexpected element 'entity-mappings' encountered.", new XmlLocator(this.fileName, localName, this.locator));
            }
            this.entityMappings = new EntityMappings(attributes);
            this.elementStack.push(this.entityMappings);
        } else {
            this.elementStack.peek().expected(localName, this.locator);
            XmlLocator xmlLocator = new XmlLocator(this.fileName, localName, this.locator);
            this.elementStack.push(Element.forElement(this.elementStack.peek(), attributes, xmlLocator));
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        LOG.trace("Start of prefix mapping url: {0}, prefix: {1}", new Object[]{uri, prefix});
    }
}

