/*
 * Decompiled with CFR 0.152.
 */
package org.batoo.jpa.parser.impl.orm.attribute;

import java.util.Map;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import org.batoo.jpa.parser.impl.orm.Element;
import org.batoo.jpa.parser.impl.orm.EnumeratedElement;
import org.batoo.jpa.parser.impl.orm.LobElement;
import org.batoo.jpa.parser.impl.orm.ParentElement;
import org.batoo.jpa.parser.impl.orm.attribute.PhysicalAttributeElement;
import org.batoo.jpa.parser.metadata.ColumnTransformerMetadata;
import org.batoo.jpa.parser.metadata.IndexMetadata;
import org.batoo.jpa.parser.metadata.attribute.BasicAttributeMetadata;

public class BasicAttributeElement
extends PhysicalAttributeElement
implements BasicAttributeMetadata {
    private EnumType enumType = EnumType.ORDINAL;
    private boolean lob = false;
    private boolean optional = true;
    private FetchType fetchType;

    public BasicAttributeElement(ParentElement parent, Map<String, String> attributes) {
        super(parent, attributes, "temporal", "enumerated", "column", "lob");
    }

    @Override
    protected void generate() {
        super.generate();
        this.fetchType = FetchType.valueOf((String)this.getAttribute("fetch", FetchType.EAGER.name()));
        this.optional = this.getAttribute("optional", true);
    }

    @Override
    public ColumnTransformerMetadata getColumnTransformer() {
        return null;
    }

    @Override
    public EnumType getEnumType() {
        return this.enumType;
    }

    @Override
    public FetchType getFetchType() {
        return this.fetchType;
    }

    @Override
    public IndexMetadata getIndex() {
        return null;
    }

    @Override
    protected void handleChild(Element child) {
        super.handleChild(child);
        if (child instanceof EnumeratedElement) {
            this.enumType = ((EnumeratedElement)child).getEnumType();
        }
        if (child instanceof LobElement) {
            this.lob = true;
        }
    }

    @Override
    public boolean isLob() {
        return this.lob;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }
}

