/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;

public class PersistenceProviderResolverHolder {
    private static PersistenceProviderResolver singleton = new DefaultPersistenceProviderResolver();

    public static PersistenceProviderResolver getPersistenceProviderResolver() {
        return singleton;
    }

    public static void setPersistenceProviderResolver(PersistenceProviderResolver resolver) {
        singleton = resolver == null ? new DefaultPersistenceProviderResolver() : resolver;
    }

    private static class DefaultPersistenceProviderResolver
    implements PersistenceProviderResolver {
        private volatile WeakHashMap<ClassLoader, List<PersistenceProvider>> providers = new WeakHashMap();
        private static final String LOGGER_SUBSYSTEM = "javax.persistence.spi";
        private Logger logger;
        private static final String SERVICE_PROVIDER_FILE = "META-INF/services/javax.persistence.spi.PersistenceProvider";
        private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");

        private DefaultPersistenceProviderResolver() {
        }

        private void addProviderNames(URL url, Collection<ProviderName> providerNames) {
            InputStream in = null;
            try {
                String line;
                in = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                while ((line = reader.readLine()) != null) {
                    Matcher m = nonCommentPattern.matcher(line = line.trim());
                    if (!m.find()) continue;
                    providerNames.add(new ProviderName(m.group().trim(), url));
                }
            }
            catch (IOException ioe) {
                throw new PersistenceException("IOException caught reading: " + url, ioe);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        @Override
        public void clearCachedProviders() {
            this.providers.clear();
        }

        @Override
        public List<PersistenceProvider> getPersistenceProviders() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            List<PersistenceProvider> loadedProviders = this.providers.get(loader);
            if (loadedProviders == null) {
                Collection<ProviderName> providerNames = this.getProviderNames(loader);
                loadedProviders = new ArrayList<PersistenceProvider>();
                for (ProviderName providerName : providerNames) {
                    try {
                        PersistenceProvider provider = (PersistenceProvider)loader.loadClass(providerName.getName()).newInstance();
                        loadedProviders.add(provider);
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.log(Level.FINEST, cnfe + ": " + providerName);
                    }
                    catch (InstantiationException ie) {
                        this.log(Level.FINEST, ie + ": " + providerName);
                    }
                    catch (IllegalAccessException iae) {
                        this.log(Level.FINEST, iae + ": " + providerName);
                    }
                    catch (ClassCastException cce) {
                        this.log(Level.FINEST, cce + ": " + providerName);
                    }
                }
                if (loadedProviders.isEmpty() && !providerNames.isEmpty()) {
                    this.log(Level.WARNING, "No valid providers found using:");
                    for (ProviderName name : providerNames) {
                        this.log(Level.WARNING, name.toString());
                    }
                }
                this.providers.put(loader, loadedProviders);
            }
            return loadedProviders;
        }

        private Collection<ProviderName> getProviderNames(ClassLoader loader) {
            Enumeration<URL> resources = null;
            try {
                resources = loader.getResources(SERVICE_PROVIDER_FILE);
            }
            catch (IOException ioe) {
                throw new PersistenceException("IOException caught: " + loader + ".getResources(" + SERVICE_PROVIDER_FILE + ")", ioe);
            }
            ArrayList<ProviderName> providerNames = new ArrayList<ProviderName>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                this.addProviderNames(url, providerNames);
            }
            return providerNames;
        }

        private void log(Level level, String message) {
            if (this.logger == null) {
                this.logger = Logger.getLogger(LOGGER_SUBSYSTEM);
            }
            this.logger.log(level, "javax.persistence.spi::" + message);
        }

        private class ProviderName {
            private final String name;
            private final URL source;

            public ProviderName(String name, URL sourceURL) {
                this.name = name;
                this.source = sourceURL;
            }

            public String getName() {
                return this.name;
            }

            public URL getSource() {
                return this.source;
            }

            public String toString() {
                return this.getName() + " - " + this.getSource();
            }
        }
    }
}

