/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.utils.cli;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.bdgenomics.utils.cli.Args4jBase;
import org.bdgenomics.utils.cli.BDGSparkCommand;
import org.bdgenomics.utils.instrumentation.DurationFormatting$;
import org.bdgenomics.utils.instrumentation.Metrics$;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.bdgenomics.utils.instrumentation.RecordedMetrics;
import org.bdgenomics.utils.instrumentation.StageTiming;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class BDGSparkCommand$class {
    public static void run(BDGSparkCommand $this) {
        None$ none$;
        long start = System.nanoTime();
        SparkConf conf = new SparkConf().setAppName($this.companion().commandName());
        Object object = conf.getOption("spark.master").isEmpty() ? conf.setMaster(new StringOps(Predef$.MODULE$.augmentString("local[%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Runtime.getRuntime().availableProcessors())}))) : BoxedUnit.UNIT;
        SparkContext sc = new SparkContext(conf);
        Option<MetricsListener> metricsListener = $this.initializeMetrics(sc);
        try {
            $this.run(sc);
            none$ = None$.MODULE$;
        }
        catch (Throwable throwable) {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("Command body threw exception:\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable})));
            none$ = new Some((Object)throwable);
        }
        None$ e = none$;
        long totalTime = System.nanoTime() - start;
        $this.printMetrics(totalTime, metricsListener);
        e.foreach((Function1)new Serializable($this){

            public final Nothing$ apply(Throwable x$1) {
                throw x$1;
            }
        });
    }

    public static Option initializeMetrics(BDGSparkCommand $this, SparkContext sc) {
        None$ none$;
        if (((Args4jBase)$this.args()).printMetrics()) {
            MetricsListener metricsListener = new MetricsListener(new RecordedMetrics());
            sc.addSparkListener((SparkListenerInterface)metricsListener);
            Metrics$.MODULE$.initialize(sc);
            none$ = new Some((Object)metricsListener);
        } else {
            Metrics$.MODULE$.stopRecording();
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static void printMetrics(BDGSparkCommand $this, long totalTime, Option metricsListener) {
        $this.logInfo((Function0)new Serializable($this, totalTime){
            private final long totalTime$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Overall Duration: ").append((Object)DurationFormatting$.MODULE$.formatNanosecondDuration((Number)Predef$.MODULE$.long2Long(this.totalTime$1))).toString();
            }
            {
                this.totalTime$1 = totalTime$1;
            }
        });
        if (((Args4jBase)$this.args()).printMetrics() && metricsListener.isDefined()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter out = new PrintWriter(stringWriter);
            out.println("Metrics:");
            out.println();
            Metrics$.MODULE$.print(out, metricsListener.map((Function1)new Serializable($this){

                public final ArrayBuffer<StageTiming> apply(MetricsListener x$2) {
                    return x$2.metrics().sparkMetrics().stageTimes();
                }
            }));
            out.println();
            metricsListener.foreach((Function1)new Serializable($this, out){
                private final PrintWriter out$1;

                public final void apply(MetricsListener x$3) {
                    x$3.metrics().sparkMetrics().print(this.out$1);
                }
                {
                    this.out$1 = out$1;
                }
            });
            out.flush();
            $this.logInfo((Function0)new Serializable($this, stringWriter){
                private final StringWriter stringWriter$1;

                public final String apply() {
                    return this.stringWriter$1.getBuffer().toString();
                }
                {
                    this.stringWriter$1 = stringWriter$1;
                }
            });
        }
    }

    public static void $init$(BDGSparkCommand $this) {
    }
}

