/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JProgressBar;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelProvider;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.event.WeakPropertyChangeListener;
import org.beanfabrics.model.ConversionException;
import org.beanfabrics.model.IIntegerPM;

public class BnProgressBar
extends JProgressBar
implements View<IIntegerPM>,
ModelSubscriber {
    private final Link link = new Link((View)this);
    private final PropertyChangeListener listener = new MyWeakPropertyChangeListener();
    private IIntegerPM pModel;

    public BnProgressBar() {
    }

    public BnProgressBar(IIntegerPM pModel) {
        this();
        this.setPresentationModel(pModel);
    }

    public BnProgressBar(ModelProvider provider, Path path) {
        this.setModelProvider((IModelProvider)provider);
        this.setPath(path);
    }

    public BnProgressBar(ModelProvider provider) {
        this.setModelProvider((IModelProvider)provider);
        this.setPath(new Path());
    }

    boolean isConnected() {
        return this.pModel != null;
    }

    private void refresh() {
        this.refreshProgressBar();
    }

    private void refreshProgressBar() {
        if (this.pModel == null) {
            this.setValue(0);
            this.setToolTipText(null);
            this.setEnabled(false);
        } else {
            try {
                Integer value = this.pModel.getInteger();
                if (value != null) {
                    this.setValue(value);
                } else {
                    this.setValue(0);
                }
            }
            catch (ConversionException ex) {
                this.setValue(0);
            }
            this.setToolTipText(!this.pModel.isValid() ? this.pModel.getValidationState().getMessage() : this.pModel.getDescription());
            this.setEnabled(true);
        }
    }

    public IIntegerPM getPresentationModel() {
        return this.pModel;
    }

    public void setPresentationModel(IIntegerPM newModel) {
        IIntegerPM oldModel = this.pModel;
        if (this.pModel != null) {
            this.pModel.removePropertyChangeListener(this.listener);
        }
        this.pModel = newModel;
        if (this.pModel != null) {
            this.pModel.addPropertyChangeListener(this.listener);
        }
        this.refresh();
        this.firePropertyChange("presentationModel", oldModel, newModel);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public void setModelProvider(IModelProvider provider) {
        this.link.setModelProvider(provider);
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    private class MyWeakPropertyChangeListener
    implements WeakPropertyChangeListener,
    Serializable {
        private MyWeakPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            BnProgressBar.this.refresh();
        }
    }
}

