/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.net.URL;
import javax.swing.ImageIcon;

public class ErrorIconPainter
implements Serializable {
    private static final URL ERROR_ICON = ErrorIconPainter.class.getResource("error_overlay.gif");
    private static final URL ERROR_ICON_FOCUSED = ErrorIconPainter.class.getResource("error_overlay.gif");
    private ImageIcon errorIcon;
    private ImageIcon errorIconFocused;
    private Insets margin = new Insets(2, 4, 2, 4);
    private int horizontalAlignment = 4;
    private int verticalAlignment = 0;
    private Point offset = new Point(0, 0);
    private Dimension dimension;

    public ErrorIconPainter() {
        this.errorIcon = new ImageIcon(ERROR_ICON);
        this.errorIconFocused = new ImageIcon(ERROR_ICON_FOCUSED);
        this.updateDimension();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        if (margin == null) {
            throw new IllegalArgumentException("margin==null");
        }
        this.margin = margin;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.checkHorizontalKey(horizontalAlignment);
        this.horizontalAlignment = horizontalAlignment;
    }

    protected void checkHorizontalKey(int key) {
        if (key == 2 || key == 0 || key == 4 || key == 10 || key == 11) {
            return;
        }
        throw new IllegalArgumentException("unknown value for horizontalAlignment: " + key);
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.checkVerticalKey(verticalAlignment);
        this.verticalAlignment = verticalAlignment;
    }

    protected void checkVerticalKey(int key) {
        if (key == 1 || key == 3 || key == 0) {
            return;
        }
        throw new IllegalArgumentException("unknown value for verticalAlignment: " + key);
    }

    public Point getOffset() {
        return this.offset;
    }

    public void setOffset(Point offset) {
        if (offset == null) {
            throw new IllegalArgumentException("offset == null");
        }
        this.offset = offset;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public ImageIcon getErrorIcon() {
        return this.errorIcon;
    }

    public void setErrorIcon(ImageIcon aErrorIcon) {
        if (aErrorIcon == null) {
            throw new IllegalArgumentException("aErrorIcon == null");
        }
        this.errorIcon = aErrorIcon;
        this.updateDimension();
    }

    public ImageIcon getErrorIconFocused() {
        return this.errorIconFocused;
    }

    public void setErrorIconFocused(ImageIcon aErrorIconFocused) {
        if (aErrorIconFocused == null) {
            throw new IllegalArgumentException("aErrorIconFocused == null");
        }
        this.errorIconFocused = aErrorIconFocused;
        this.updateDimension();
    }

    private void updateDimension() {
        this.dimension = new Dimension(Math.max(this.errorIcon.getIconWidth(), this.errorIconFocused.getIconWidth()), Math.max(this.errorIcon.getIconHeight(), this.errorIconFocused.getIconHeight()));
    }

    public void paint(Graphics g, Component c) {
        int y;
        int x;
        if (this.horizontalAlignment == 4 || this.horizontalAlignment == 11) {
            x = c.getWidth() - (this.dimension.width + this.margin.right) + this.offset.x;
        } else if (this.horizontalAlignment == 2 || this.horizontalAlignment == 10) {
            x = this.margin.left + this.offset.x;
        } else if (this.horizontalAlignment == 0) {
            x = (c.getWidth() - (this.dimension.width + this.margin.left + this.margin.right)) / 2 + this.margin.left + this.offset.x;
        } else {
            throw new IllegalStateException("Unexpected value for horizontalAlignment: " + this.horizontalAlignment);
        }
        if (this.verticalAlignment == 3) {
            y = c.getHeight() - (this.dimension.height + this.margin.bottom) + this.offset.y;
        } else if (this.verticalAlignment == 1) {
            y = this.margin.top + this.offset.y;
        } else if (this.verticalAlignment == 0) {
            y = (c.getHeight() - (this.dimension.height + this.margin.top + this.margin.bottom)) / 2 + this.margin.top + this.offset.y;
        } else {
            throw new IllegalStateException("Unexpected value for verticalAlignment: " + this.verticalAlignment);
        }
        boolean hasFocus = c.hasFocus();
        this.paintErrorImage(g, x, y, hasFocus, c);
    }

    private void paintErrorImage(Graphics g, int x, int y, boolean hasFocus, ImageObserver observer) {
        if (g == null) {
            return;
        }
        ImageIcon icon = hasFocus ? this.errorIconFocused : this.errorIcon;
        g.drawImage(icon.getImage(), x, y, observer);
    }
}

