/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.beanfabrics.Path;

public class PathPainter {
    private Color foreground = new Color(125, 91, 47);
    private Color background = new Color(241, 204, 156);
    private Color borderColor = new Color(200, 151, 86);
    private Font font;
    private int verticalAlignment = 0;
    private int horizontalAlignment = 10;
    private int verticalTextPosition = 0;
    private int horizontalTextPosition = 10;
    private final Rectangle emptyR = new Rectangle(0, 0, 0, 0);

    public PathPainter() {
        Font basefont = UIManager.getLookAndFeelDefaults().getFont("Label.font");
        this.font = basefont.deriveFont(basefont.getSize2D() * 0.8f).deriveFont(0);
    }

    public void paintPath(Graphics g, int x, int y, Path path, JComponent c) {
        if (path != null) {
            Rectangle viewR = c.getBounds();
            FontMetrics fm = c.getFontMetrics(this.font);
            Rectangle textR = new Rectangle(viewR.x, viewR.y, viewR.width - 20, viewR.height);
            String text = path.toString();
            String clippedText = this.layoutCL(c, fm, text, textR, textR);
            int dx = c.getInsets().left;
            int dy = c.getInsets().top;
            int h = fm.getHeight();
            int w = fm.stringWidth(clippedText);
            g.setColor(this.background);
            g.fillRect(x + dx, y + dy, w + 2, h);
            g.setColor(this.borderColor);
            g.drawRect(x + dx, y + dy, w + 2, h);
            g.setColor(this.foreground);
            g.setFont(this.font);
            g.drawString(clippedText, x + dy + 2, y + dy + h - 1);
        }
    }

    private String layoutCL(JComponent c, FontMetrics fontMetrics, String text, Rectangle viewR, Rectangle textR) {
        Rectangle iconR = this.emptyR;
        return SwingUtilities.layoutCompoundLabel(c, fontMetrics, text, null, this.verticalAlignment, this.horizontalAlignment, this.verticalTextPosition, this.horizontalTextPosition, viewR, iconR, textR, 0);
    }
}

