/*
 * Decompiled with CFR 0.152.
 */
package org.beanfabrics.swing.customizer.path;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.beanfabrics.IModelProvider;
import org.beanfabrics.Link;
import org.beanfabrics.ModelProvider;
import org.beanfabrics.ModelSubscriber;
import org.beanfabrics.Path;
import org.beanfabrics.View;
import org.beanfabrics.model.PresentationModel;
import org.beanfabrics.swing.BnAction;
import org.beanfabrics.swing.BnButton;
import org.beanfabrics.swing.BnLabel;
import org.beanfabrics.swing.BnTextField;
import org.beanfabrics.swing.customizer.path.PathBrowserPM;
import org.beanfabrics.swing.customizer.util.CustomizerUtil;
import org.beanfabrics.swing.customizer.util.SeparatorLabel;
import org.beanfabrics.swing.customizer.util.ToolbarButton;
import org.beanfabrics.swing.table.BnColumnBuilder;
import org.beanfabrics.swing.table.BnTable;

public class PathBrowserPanel
extends JPanel
implements View<PathBrowserPM>,
ModelSubscriber {
    private BnAction gotoParentAction;
    private BnButton folderUpButton;
    private SeparatorLabel chooseModelSeparatorLabel;
    private JPanel panel_1;
    private JPanel panel;
    private BnLabel lbHeader;
    private BnAction gotoCurrentPathAction;
    private BnTextField tfType;
    private JLabel typeLabel;
    private JPanel headerPanel;
    private JLabel pathLabel;
    private BnTextField tfPath;
    private JPanel chooserPanel;
    private BnAction gotoSelectedChildAction;
    private BnTable bnTable;
    private JScrollPane scrollPane;
    private JPanel centerPanel;
    private Action transferFocusToTfPath;
    private Action transferFocusToBnTable;
    private final Link link = new Link((View)this);
    private ModelProvider localProvider;

    public PathBrowserPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getCenterPanel(), "Center");
        this.add((Component)this.getHeaderPanel(), "North");
    }

    protected ModelProvider getLocalProvider() {
        if (this.localProvider == null) {
            this.localProvider = new ModelProvider();
            this.localProvider.setPresentationModelType(PathBrowserPM.class);
        }
        return this.localProvider;
    }

    public PathBrowserPM getPresentationModel() {
        return (PathBrowserPM)this.getLocalProvider().getPresentationModel();
    }

    public void setPresentationModel(PathBrowserPM pModel) {
        this.getLocalProvider().setPresentationModel((PresentationModel)pModel);
    }

    public IModelProvider getModelProvider() {
        return this.link.getModelProvider();
    }

    public void setModelProvider(IModelProvider provider) {
        this.link.setModelProvider(provider);
    }

    public Path getPath() {
        return this.link.getPath();
    }

    public void setPath(Path path) {
        this.link.setPath(path);
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.columnWeights = new double[]{0.0, 1.0};
            gridBagLayout.columnWidths = new int[]{40, 0};
            gridBagLayout.rowHeights = new int[]{7, 34};
            this.centerPanel.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(4, 4, 4, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.ipadx = 256;
            gridBagConstraints.ipady = 21;
            GridBagConstraints gridBagConstraints_2 = new GridBagConstraints();
            gridBagConstraints_2.insets = new Insets(4, 4, 5, 5);
            gridBagConstraints_2.anchor = 17;
            gridBagConstraints_2.gridy = 1;
            gridBagConstraints_2.gridx = 0;
            this.centerPanel.add((Component)this.getFolderUpButton(), gridBagConstraints_2);
            this.centerPanel.add((Component)this.getChooserPanel(), gridBagConstraints);
            GridBagConstraints gridBagConstraints_1 = new GridBagConstraints();
            gridBagConstraints_1.gridwidth = 2;
            gridBagConstraints_1.insets = new Insets(4, 8, 5, 0);
            gridBagConstraints_1.weightx = 1.0;
            gridBagConstraints_1.fill = 2;
            gridBagConstraints_1.gridx = 0;
            gridBagConstraints_1.gridy = 0;
            this.centerPanel.add((Component)this.getChooseModelSeparatorLabel(), gridBagConstraints_1);
            this.centerPanel.setOpaque(false);
        }
        return this.centerPanel;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setPreferredSize(new Dimension(200, 200));
            this.scrollPane.setViewportView(this.getBnTable());
            this.scrollPane.getViewport().setBackground(this.getBnTable().getBackground());
        }
        return this.scrollPane;
    }

    private BnTable getBnTable() {
        if (this.bnTable == null) {
            this.bnTable = new BnTable();
            this.bnTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        PathBrowserPanel.this.getGotoSelectedChildAction().actionPerformed(null);
                    }
                }
            });
            this.bnTable.setPath(new Path("this.children"));
            this.bnTable.setColumns(new BnColumnBuilder().addColumn().withPath("this.name").withName("Name").withWidth(140).withWidthFixed(true).addColumn().withPath("this.type").withName("Type").withWidth(200).build());
            this.bnTable.setModelProvider((IModelProvider)this.getLocalProvider());
            this.bnTable.setGridColor(this.bnTable.getBackground());
            this.bnTable.setIntercellSpacing(new Dimension(0, 0));
            this.bnTable.setRowHeight(this.bnTable.getRowHeight() + 2);
            this.bnTable.getActionMap().put("gotoSelectedChild", this.getGotoSelectedChildAction());
            this.bnTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "gotoSelectedChild");
            this.bnTable.getActionMap().put("transferFocus", this.getTransferFocusToTfPath());
            this.bnTable.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), "transferFocus");
            this.bnTable.getActionMap().put("gotoParent", this.getGotoParentAction());
            this.bnTable.getInputMap(1).put(KeyStroke.getKeyStroke(8, 0), "gotoParent");
        }
        return this.bnTable;
    }

    private BnAction getGotoSelectedChildAction() {
        if (this.gotoSelectedChildAction == null) {
            this.gotoSelectedChildAction = new BnAction();
            this.gotoSelectedChildAction.setModelProvider((IModelProvider)this.getLocalProvider());
            this.gotoSelectedChildAction.setPath(new Path("gotoSelectedChild"));
        }
        return this.gotoSelectedChildAction;
    }

    private JPanel getChooserPanel() {
        if (this.chooserPanel == null) {
            this.chooserPanel = new JPanel();
            this.chooserPanel.setOpaque(false);
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.columnWidths = new int[]{7, 7};
            this.chooserPanel.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            GridBagConstraints gridBagConstraints_2 = new GridBagConstraints();
            gridBagConstraints_2.anchor = 17;
            gridBagConstraints_2.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints_2.gridy = 1;
            gridBagConstraints_2.gridx = 0;
            this.chooserPanel.add((Component)this.getPathLabel(), gridBagConstraints_2);
            this.chooserPanel.add((Component)this.getTfPath(), gridBagConstraints);
            GridBagConstraints gridBagConstraints_3 = new GridBagConstraints();
            gridBagConstraints_3.gridy = 2;
            gridBagConstraints_3.gridx = 0;
            gridBagConstraints_3.insets = new Insets(4, 4, 4, 4);
            this.chooserPanel.add((Component)this.getTypeLabel(), gridBagConstraints_3);
            GridBagConstraints gridBagConstraints_4 = new GridBagConstraints();
            gridBagConstraints_4.fill = 2;
            gridBagConstraints_4.anchor = 17;
            gridBagConstraints_4.gridy = 2;
            gridBagConstraints_4.gridx = 1;
            gridBagConstraints_4.insets = new Insets(4, 4, 4, 4);
            this.chooserPanel.add((Component)this.getTfType(), gridBagConstraints_4);
            GridBagConstraints gridBagConstraints_1 = new GridBagConstraints();
            gridBagConstraints_1.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints_1.fill = 1;
            gridBagConstraints_1.weighty = 1.0;
            gridBagConstraints_1.weightx = 1.0;
            gridBagConstraints_1.gridwidth = 3;
            gridBagConstraints_1.gridy = 0;
            gridBagConstraints_1.gridx = 0;
            this.chooserPanel.add((Component)this.getPanel_1(), gridBagConstraints_1);
        }
        return this.chooserPanel;
    }

    private BnTextField getTfPath() {
        if (this.tfPath == null) {
            this.tfPath = new BnTextField();
            this.tfPath.setPath(new Path("this.currentSelectedPath"));
            this.tfPath.setModelProvider((IModelProvider)this.getLocalProvider());
            this.tfPath.setColumns(10);
            this.tfPath.getActionMap().put("gotoCurrentPath", this.getGotoCurrentPathAction());
            this.tfPath.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "gotoCurrentPath");
            this.tfPath.getActionMap().put("transferFocus", this.getTransferFocusToBnTable());
            this.tfPath.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), "transferFocus");
        }
        return this.tfPath;
    }

    private JLabel getPathLabel() {
        if (this.pathLabel == null) {
            this.pathLabel = new JLabel();
            this.pathLabel.setText("Path");
        }
        return this.pathLabel;
    }

    private JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel();
            this.headerPanel.setBackground(Color.WHITE);
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.columnWidths = new int[]{0, 7};
            this.headerPanel.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.headerPanel.add((Component)this.getLbHeader(), gridBagConstraints);
            GridBagConstraints gridBagConstraints_1 = new GridBagConstraints();
            gridBagConstraints_1.ipady = 40;
            gridBagConstraints_1.gridy = 0;
            gridBagConstraints_1.gridx = 0;
            gridBagConstraints_1.insets = new Insets(4, 4, 4, 4);
            this.headerPanel.add((Component)this.getPanel(), gridBagConstraints_1);
        }
        return this.headerPanel;
    }

    private JLabel getTypeLabel() {
        if (this.typeLabel == null) {
            this.typeLabel = new JLabel();
            this.typeLabel.setText("Type");
        }
        return this.typeLabel;
    }

    private BnTextField getTfType() {
        if (this.tfType == null) {
            this.tfType = new BnTextField();
            this.tfType.setOpaque(false);
            this.tfType.setFocusable(false);
            this.tfType.setPath(new Path("this.currentSelectedType"));
            this.tfType.setModelProvider((IModelProvider)this.getLocalProvider());
            this.tfType.setColumns(15);
        }
        return this.tfType;
    }

    private BnAction getGotoCurrentPathAction() {
        if (this.gotoCurrentPathAction == null) {
            this.gotoCurrentPathAction = new BnAction();
            this.gotoCurrentPathAction.setModelProvider((IModelProvider)this.getLocalProvider());
            this.gotoCurrentPathAction.setPath(new Path("gotoCurrentPath"));
        }
        return this.gotoCurrentPathAction;
    }

    private Action getTransferFocusToTfPath() {
        if (this.transferFocusToTfPath == null) {
            this.transferFocusToTfPath = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PathBrowserPanel.this.getTfPath().requestFocusInWindow();
                }
            };
        }
        return this.transferFocusToTfPath;
    }

    private Action getTransferFocusToBnTable() {
        if (this.transferFocusToBnTable == null) {
            this.transferFocusToBnTable = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PathBrowserPanel.this.getBnTable().requestFocusInWindow();
                }
            };
        }
        return this.transferFocusToBnTable;
    }

    private BnLabel getLbHeader() {
        if (this.lbHeader == null) {
            this.lbHeader = new BnLabel();
            this.lbHeader.setPath(new Path("this.status"));
            this.lbHeader.setModelProvider((IModelProvider)this.getLocalProvider());
        }
        return this.lbHeader;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setOpaque(false);
        }
        return this.panel;
    }

    protected JPanel getPanel_1() {
        if (this.panel_1 == null) {
            this.panel_1 = new JPanel();
            this.panel_1.setLayout(new BorderLayout());
            this.panel_1.add(this.getScrollPane());
        }
        return this.panel_1;
    }

    protected SeparatorLabel getChooseModelSeparatorLabel() {
        if (this.chooseModelSeparatorLabel == null) {
            this.chooseModelSeparatorLabel = new SeparatorLabel();
            this.chooseModelSeparatorLabel.setText("Choose Path to Model");
        }
        return this.chooseModelSeparatorLabel;
    }

    protected BnButton getFolderUpButton() {
        if (this.folderUpButton == null) {
            this.folderUpButton = PathBrowserPanel.createFolderUpButton();
            this.folderUpButton.setMargin(new Insets(2, 2, 2, 2));
            this.folderUpButton.setModelProvider((IModelProvider)this.getLocalProvider());
            this.folderUpButton.setPath(new Path("this.gotoParent"));
            this.folderUpButton.setFocusable(false);
            this.folderUpButton.setIcon(new ImageIcon(this.getFolderUpIconURL()));
        }
        return this.folderUpButton;
    }

    protected BnAction getGotoParentAction() {
        if (this.gotoParentAction == null) {
            this.gotoParentAction = new BnAction();
            this.gotoParentAction.setModelProvider((IModelProvider)this.getLocalProvider());
            this.gotoParentAction.setPath(new Path("this.gotoParent"));
        }
        return this.gotoParentAction;
    }

    private static BnButton createFolderUpButton() {
        if (CustomizerUtil.isWindows()) {
            ToolbarButton result = new ToolbarButton();
            result.setBorderPainted(false);
            return result;
        }
        BnButton result = new BnButton();
        PathBrowserPanel.setTexturedButtonType(result);
        return result;
    }

    private URL getFolderUpIconURL() {
        if (CustomizerUtil.isWindows()) {
            return this.getClass().getResource("upFolder-win.png");
        }
        if (CustomizerUtil.isAquaLookAndFeel()) {
            return this.getClass().getResource("symbolArrowUp.png");
        }
        return this.getClass().getResource("upFolder-win.png");
    }

    private static void setTexturedButtonType(AbstractButton btn) {
        btn.putClientProperty("JButton.buttonType", "textured");
    }
}

